<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seller_level_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('seller_id');
            $table->unsignedBigInteger('seller_level_id');
            $table->string('level');
            $table->dateTime('assigned_at');
            $table->integer('orders_at_assignment')->nullable();
            $table->decimal('order_amount_at_assignment', 10, 2)->nullable();
            $table->foreign('seller_id')->references('id')->on('users');
            $table->foreign('seller_level_id')->references('id')->on('seller_levels');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seller_level_histories');
    }
};
