<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seller_levels', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('icon')->nullable();
            $table->integer('min_orders')->default(0); 
            $table->decimal('commission', 5, 2);
            $table->decimal('basic_price', 8, 2)->default(0);
            $table->decimal('min_order_amount', 8, 2)->default(0);
            $table->enum('is_new_seller', ['yes', 'no'])->default('no');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seller_levels');
    }
};
