<?php

namespace Modules\Page\App\Http\Controllers;

use Image, File, Str;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Modules\Page\App\Models\AboutUs;
use Illuminate\Http\RedirectResponse;
use Modules\Page\App\Models\AboutUsTranslation;
use Modules\Page\App\Http\Requests\AboutUsRequest;
use App\Models\Admin;

class AboutusController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('about_us_view')) {
            abort(403, 'Forbidden: missing permission about_us_view');
        }

        $about_us = AboutUs::first();
        $translate = AboutUsTranslation::where(['about_us_id' => $about_us->id, 'lang_code' => $request->lang_code])->first();

        return view('page::about_us', ['about_us' => $about_us, 'translate' => $translate]);
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(AboutUsRequest $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('about_us_update')) {
            abort(403, 'Forbidden: missing permission about_us_update');
        }

        $about_us = AboutUs::first();
        $translate = AboutUsTranslation::where(['about_us_id' => $about_us->id, 'lang_code' => $request->lang_code])->first();

        $translate->short_title = $request->short_title;
        $translate->title = $request->title;
        $translate->description = $request->description;
        $translate->item1 = $request->item1;
        $translate->item2 = $request->item2;
        $translate->item3 = $request->item3;
        $translate->save();


        if ($request->seo_signature) {
            $file_path = uploadPublicFile($request->seo_signature, 'uploads/custom-images', $about_us->seo_signature);
            $about_us->seo_signature = $file_path;
            $about_us->save();
        }

        if ($request->seo_image) {
            $file_path = uploadPublicFile($request->seo_image, 'uploads/custom-images', $about_us->seo_image);
            $about_us->seo_image = $file_path;
            $about_us->save();
        }

        if ($request->about_image) {
            $file_path = uploadPublicFile($request->about_image, 'uploads/custom-images', $about_us->about_image);
            $about_us->about_image = $file_path;
            $about_us->save();
        }

        $notify_message = trans('translate.Update successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function setup_language($lang_code)
    {
        $about_translate = AboutUsTranslation::where('lang_code', admin_lang())->first();

        $new_trans = new AboutUsTranslation();
        $new_trans->lang_code = $lang_code;
        $new_trans->about_us_id = $about_translate->about_us_id;
        $new_trans->short_title = $about_translate->short_title;
        $new_trans->title = $about_translate->title;
        $new_trans->description = $about_translate->description;
        $new_trans->item1 = $about_translate->item1;
        $new_trans->item2 = $about_translate->item2;
        $new_trans->item3 = $about_translate->item3;
        $new_trans->save();
    }
}
