<?php

namespace Modules\AdminTeam\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Log;
use Modules\AdminTeam\App\Models\AdminPermissionList;

class AdminPermissionListSeeder extends Seeder
{
    public function run(): void
    {
        $permissions = [
            // Dashboard Management
            [
                'name' => 'dashboard_management',
                'display_name' => 'Dashboard Management',
                'module' => 'dashboard',
                'description' => 'Access to dashboard and main admin panel',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'dashboard_view',
                'display_name' => 'View Dashboard',
                'module' => 'dashboard',
                'description' => 'View admin dashboard',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            //Manage Profile
            [
                'name' => 'profile_management',
                'display_name' => 'Manage Profile',
                'module' => 'profile',
                'description' => 'Manage profile and profile related operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'profile_view',
                'display_name' => 'View Profile',
                'module' => 'profile',
                'description' => 'View profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',

            ],
            [
                'name' => 'profile_update',
                'display_name' => 'Update Profile',
                'module' => 'profile',
                'description' => 'Update profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'password_update',
                'display_name' => 'Update Password',
                'module' => 'profile',
                'description' => 'Update password',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Order Management
            [
                'name' => 'order_management',
                'display_name' => 'Order Management',
                'module' => 'order',
                'description' => 'Manage orders and order related operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'order_view',
                'display_name' => 'View All Orders',
                'module' => 'order',
                'description' => 'View all orders',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_detail_view',
                'display_name' => 'Show Order Detail',
                'module' => 'order',
                'description' => 'Show order detail',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_approve',
                'display_name' => 'Approve Order',
                'module' => 'order',
                'description' => 'Approve order',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_delete',
                'display_name' => 'Delete Order',
                'module' => 'order',
                'description' => 'Delete order',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_cancel',
                'display_name' => 'Cancel Order',
                'module' => 'order',
                'description' => 'Cancel order',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_active_view',
                'display_name' => 'View Active Orders',
                'module' => 'order',
                'description' => 'View active orders',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_awaiting_view',
                'display_name' => 'View Awaiting Orders',
                'module' => 'order',
                'description' => 'View awaiting orders',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_rejected_view',
                'display_name' => 'View Rejected Orders',
                'module' => 'order',
                'description' => 'View rejected orders',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_cancel_view',
                'display_name' => 'View Cancel Orders',
                'module' => 'order',
                'description' => 'View cancelled orders',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_complete_view',
                'display_name' => 'View Complete Orders',
                'module' => 'order',
                'description' => 'View completed orders',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'order_pending_payment_view',
                'display_name' => 'View Pending Payment Orders',
                'module' => 'order',
                'description' => 'View pending payment orders',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Service Management
            [
                'name' => 'service_management',
                'display_name' => 'Service Management',
                'module' => 'service',
                'description' => 'Manage services and service related operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'category_view',
                'display_name' => 'View Categories',
                'module' => 'service',
                'description' => 'View service categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'category_create',
                'display_name' => 'Create Category',
                'module' => 'service',
                'description' => 'Create a new service category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'category_edit',
                'display_name' => 'Edit Category',
                'module' => 'service',
                'description' => 'Edit an existing service category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'category_update',
                'display_name' => 'Update Category',
                'module' => 'service',
                'description' => 'Update details of a service category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'category_delete',
                'display_name' => 'Delete Category',
                'module' => 'service',
                'description' => 'Delete a service category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'sub_category_view',
                'display_name' => 'View Sub Categories',
                'module' => 'service',
                'description' => 'View service sub categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'sub_category_create',
                'display_name' => 'Create Sub Category',
                'module' => 'service',
                'description' => 'Create a new service sub category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'sub_category_edit',
                'display_name' => 'Edit Sub Category',
                'module' => 'service',
                'description' => 'Edit an existing service sub category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'sub_category_update',
                'display_name' => 'Update Sub Category',
                'module' => 'service',
                'description' => 'Update details of a service sub category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'sub_category_delete',
                'display_name' => 'Delete Sub Category',
                'module' => 'service',
                'description' => 'Delete a service sub category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_create',
                'display_name' => 'Create Service',
                'module' => 'service',
                'description' => 'Create new services',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_view',
                'display_name' => 'View Services',
                'module' => 'service',
                'description' => 'View existing services',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_edit',
                'display_name' => 'Edit Service',
                'module' => 'service',
                'description' => 'Edit existing services',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_update',
                'display_name' => 'Update Service',
                'module' => 'service',
                'description' => 'Update service details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_delete',
                'display_name' => 'Delete Service',
                'module' => 'service',
                'description' => 'Delete existing services',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_make_featured',
                'display_name' => 'Make Service Featured',
                'module' => 'service',
                'description' => 'Mark a service as featured',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_gallery_item_view',
                'display_name' => 'View Service Gallery Items',
                'module' => 'service',
                'description' => 'View items in the service gallery',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_gallery_item_upload',
                'display_name' => 'Upload Service Gallery Item',
                'module' => 'service',
                'description' => 'Upload new items to the service gallery',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_gallery_item_delete',
                'display_name' => 'Delete Service Gallery Item',
                'module' => 'service',
                'description' => 'Delete items from the service gallery',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_awaiting_view',
                'display_name' => 'View Awaiting Services',
                'module' => 'service',
                'description' => 'View awaiting services',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'service_featured_view',
                'display_name' => 'View Featured Services',
                'module' => 'service',
                'description' => 'View featured services',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'review_view',
                'display_name' => 'View Reviews',
                'module' => 'service',
                'description' => 'View service reviews',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'review_view_details',
                'display_name' => 'View Review Details',
                'module' => 'service',
                'description' => 'View detailed information about a review',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'review_delete',
                'display_name' => 'Delete Review',
                'module' => 'service',
                'description' => 'Delete a service review',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'review_approve',
                'display_name' => 'Approve Review',
                'module' => 'service',
                'description' => 'Approve a pending service review',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Job Post Management
            [
                'name' => 'jobpost_management',
                'display_name' => 'Job Post Management',
                'module' => 'jobpost',
                'description' => 'Manage job posts and job related operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'city_view',
                'display_name' => 'View Cities',
                'module' => 'jobpost',
                'description' => 'View cities',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'city_create',
                'display_name' => 'Create City',
                'module' => 'jobpost',
                'description' => 'Create a new city',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'city_edit',
                'display_name' => 'Edit City',
                'module' => 'jobpost',
                'description' => 'Edit existing city',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'city_update',
                'display_name' => 'Update City',
                'module' => 'jobpost',
                'description' => 'Update city details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'city_delete',
                'display_name' => 'Delete City',
                'module' => 'jobpost',
                'description' => 'Delete a city',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_view',
                'display_name' => 'View Job Posts',
                'module' => 'jobpost',
                'description' => 'View all job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_create',
                'display_name' => 'Create Job Post',
                'module' => 'jobpost',
                'description' => 'Create a new job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_edit',
                'display_name' => 'Edit Job Post',
                'module' => 'jobpost',
                'description' => 'Edit an existing job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_update',
                'display_name' => 'Update Job Post',
                'module' => 'jobpost',
                'description' => 'Update job post details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_delete',
                'display_name' => 'Delete Job Post',
                'module' => 'jobpost',
                'description' => 'Delete a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_application_view',
                'display_name' => 'View Job Applications',
                'module' => 'jobpost',
                'description' => 'View Job Applications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_application_deatils_show',
                'display_name' => 'View Job Application Details',
                'module' => 'jobpost',
                'description' => 'View Job Application Details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_application_delete',
                'display_name' => 'Delete Job Application',
                'module' => 'jobpost',
                'description' => 'Delete Job Application',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_application_approval',
                'display_name' => 'Approve Job Application',
                'module' => 'jobpost',
                'description' => 'Approve Job Application',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_awaiting_view',
                'display_name' => 'View Awaiting Job Posts',
                'module' => 'jobpost',
                'description' => 'View awaiting job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Refund Management
            [
                'name' => 'refund_management',
                'display_name' => 'Refund Management',
                'module' => 'refund',
                'description' => 'Manage refunds and refund related operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'refund_list',
                'display_name' => 'Refund List',
                'module' => 'refund',
                'description' => 'View list of all refunds',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'refund_show',
                'display_name' => 'Show Refund',
                'module' => 'refund',
                'description' => 'View detailed refund information',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'refund_delete',
                'display_name' => 'Delete Refund',
                'module' => 'refund',
                'description' => 'Delete a refund record',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'refund_approve',
                'display_name' => 'Approve Refund',
                'module' => 'refund',
                'description' => 'Approve refund requests',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'refund_reject',
                'display_name' => 'Reject Refund',
                'module' => 'refund',
                'description' => 'Reject refund requests',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'refund_pending',
                'display_name' => 'Pending Refunds',
                'module' => 'refund',
                'description' => 'View or manage pending refund requests',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Subscription Management
            [
                'name' => 'subscription_management',
                'display_name' => 'Subscription Management',
                'module' => 'subscription',
                'description' => 'Manage subscriptions and subscription related operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_plan_list',
                'display_name' => 'Plan List',
                'module' => 'subscription',
                'description' => 'View list of subscription plans',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_plan_create',
                'display_name' => 'Create Plan',
                'module' => 'subscription',
                'description' => 'Create new subscription plans',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_plan_edit',
                'display_name' => 'Edit Plan',
                'module' => 'subscription',
                'description' => 'Edit subscription plans',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_plan_update',
                'display_name' => 'Update Plan',
                'module' => 'subscription',
                'description' => 'Update subscription plan details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_plan_delete',
                'display_name' => 'Delete Plan',
                'module' => 'subscription',
                'description' => 'Delete subscription plans',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_purchase_history',
                'display_name' => 'Purchase History',
                'module' => 'subscription',
                'description' => 'View purchase history of subscriptions',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_pending_history',
                'display_name' => 'Pending History',
                'module' => 'subscription',
                'description' => 'View pending subscription histories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_history_view_details',
                'display_name' => 'View History Details',
                'module' => 'subscription',
                'description' => 'View detailed subscription history',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_history_delete',
                'display_name' => 'Delete History',
                'module' => 'subscription',
                'description' => 'Delete subscription history records',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscription_assign_plan',
                'display_name' => 'Assign Plan',
                'module' => 'subscription',
                'description' => 'Assign subscription plans to users',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

             // KYC Management
             [
                'name' => 'kyc_management',
                'display_name' => 'KYC Management',
                'module' => 'kyc',
                'description' => 'Manage KYC and KYC related operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_type_view',
                'display_name' => 'View KYC Types',
                'module' => 'kyc',
                'description' => 'View KYC types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_type_create',
                'display_name' => 'Create KYC Type',
                'module' => 'kyc',
                'description' => 'Create new KYC type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_type_edit',
                'display_name' => 'Edit KYC Type',
                'module' => 'kyc',
                'description' => 'Edit existing KYC type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_type_update',
                'display_name' => 'Update KYC Type',
                'module' => 'kyc',
                'description' => 'Update KYC type details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_type_delete',
                'display_name' => 'Delete KYC Type',
                'module' => 'kyc',
                'description' => 'Delete KYC type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_pending_list',
                'display_name' => 'Pending KYC List',
                'module' => 'kyc',
                'description' => 'View list of pending KYC requests',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_approved_list',
                'display_name' => 'Approved KYC List',
                'module' => 'kyc',
                'description' => 'View list of approved KYC requests',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'kyc_rejected_list',
                'display_name' => 'Rejected KYC List',
                'module' => 'kyc',
                'description' => 'View list of rejected KYC requests',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],



            // Withdraw Management
            [
                'name' => 'withdraw_management',
                'display_name' => 'Withdraw Management',
                'module' => 'withdraw',
                'description' => 'Manage withdrawals and withdraw methods',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_method_view',
                'display_name' => 'View Withdraw Methods',
                'module' => 'withdraw',
                'description' => 'View withdraw methods',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_method_create',
                'display_name' => 'Create Withdraw Method',
                'module' => 'withdraw',
                'description' => 'Create new withdraw method',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_method_edit',
                'display_name' => 'Edit Withdraw Method',
                'module' => 'withdraw',
                'description' => 'Edit existing withdraw method',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_method_update',
                'display_name' => 'Update Withdraw Method',
                'module' => 'withdraw',
                'description' => 'Update existing withdraw method',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_method_delete',
                'display_name' => 'Delete Withdraw Method',
                'module' => 'withdraw',
                'description' => 'Delete withdraw method',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_list_view',
                'display_name' => 'View Withdraw List',
                'module' => 'withdraw',
                'description' => 'View withdraw list',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_view',
                'display_name' => 'Show Withdraw Details',
                'module' => 'withdraw',
                'description' => 'View withdraw',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_delete',
                'display_name' => 'Delete Withdraw',
                'module' => 'withdraw',
                'description' => 'Delete withdraw',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_approve',
                'display_name' => 'Approve Withdraw',
                'module' => 'withdraw',
                'description' => 'Approve withdraw',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'withdraw_reject',
                'display_name' => 'Reject Withdraw',
                'module' => 'withdraw',
                'description' => 'Reject withdraw',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Seller Management
            [
                'name' => 'seller_management',
                'display_name' => 'Seller Management',
                'module' => 'seller',
                'description' => 'Manage sellers and seller operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'seller_list_view',
                'display_name' => 'View Seller List',
                'module' => 'seller',
                'description' => 'View seller list',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_pending_view',
                'display_name' => 'View Pending Sellers',
                'module' => 'seller',
                'description' => 'View pending sellers',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_status_change',
                'display_name' => 'Change Seller Status',
                'module' => 'seller',
                'description' => 'Change status of a seller',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_view',
                'display_name' => 'View Seller',
                'module' => 'seller',
                'description' => 'View individual seller details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_delete',
                'display_name' => 'Delete Seller',
                'module' => 'seller',
                'description' => 'Delete a seller',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_go_to_public_profile',
                'display_name' => 'Go To Public Profile',
                'module' => 'seller',
                'description' => 'Access seller public profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_ban_profile',
                'display_name' => 'Ban Profile',
                'module' => 'seller',
                'description' => 'Ban seller profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_edit_profile',
                'display_name' => 'Edit Profile',
                'module' => 'seller',
                'description' => 'Edit seller profile information',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seller_delete_profile',
                'display_name' => 'Delete Profile',
                'module' => 'seller',
                'description' => 'Delete seller profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Buyer Management
            [
                'name' => 'buyer_management',
                'display_name' => 'Buyer Management',
                'module' => 'buyer',
                'description' => 'Manage buyers and buyer operations',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_list_view',
                'display_name' => 'View Buyer List',
                'module' => 'buyer',
                'description' => 'View buyer list',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_pending_view',
                'display_name' => 'View Pending Buyers',
                'module' => 'buyer',
                'description' => 'View pending buyers',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_status_change',
                'display_name' => 'Change Buyer Status',
                'module' => 'buyer',
                'description' => 'Change status of a buyer',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_view',
                'display_name' => 'View Buyer',
                'module' => 'buyer',
                'description' => 'View individual buyer details',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_delete',
                'display_name' => 'Delete Buyer',
                'module' => 'buyer',
                'description' => 'Delete a buyer',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_go_to_public_profile',
                'display_name' => 'Go To Public Profile',
                'module' => 'buyer',
                'description' => 'Access buyer public profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_ban_profile',
                'display_name' => 'Ban Profile',
                'module' => 'buyer',
                'description' => 'Ban buyer profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_edit_profile',
                'display_name' => 'Edit Profile',
                'module' => 'buyer',
                'description' => 'Edit buyer profile information',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'buyer_delete_profile',
                'display_name' => 'Delete Profile',
                'module' => 'buyer',
                'description' => 'Delete buyer profile',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Contact Message Management
            [
                'name' => 'contact_message_management',
                'display_name' => 'Contact Message Management',
                'module' => 'contact',
                'description' => 'Manage contact messages',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'contact_message_view',
                'display_name' => 'View Contact Messages',
                'module' => 'contact',
                'description' => 'View contact messages',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'contact_message_detail',
                'display_name' => 'View Contact Message Detail',
                'module' => 'contact',
                'description' => 'View contact message detail',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'contact_message_delete',
                'display_name' => 'Delete Contact Message',
                'module' => 'contact',
                'description' => 'Delete contact message',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // CMS Management
            [
                'name' => 'cms_management',
                'display_name' => 'CMS/Blog Management',
                'module' => 'cms',
                'description' => 'Manage content management system',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'blog_index',
                'display_name' => 'Blog Index',
                'module' => 'cms',
                'description' => 'View blog list',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_create',
                'display_name' => 'Create Blog',
                'module' => 'cms',
                'description' => 'Create new blog posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_store',
                'display_name' => 'Store Blog',
                'module' => 'cms',
                'description' => 'Store new blog posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_show',
                'display_name' => 'Show Blog',
                'module' => 'cms',
                'description' => 'View specific blog post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_edit',
                'display_name' => 'Edit Blog',
                'module' => 'cms',
                'description' => 'Edit blog posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_update',
                'display_name' => 'Update Blog',
                'module' => 'cms',
                'description' => 'Update blog posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_destroy',
                'display_name' => 'Delete Blog',
                'module' => 'cms',
                'description' => 'Delete blog posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_category_index',
                'display_name' => 'Blog Category Index',
                'module' => 'cms',
                'description' => 'View blog categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_category_create',
                'display_name' => 'Create Blog Category',
                'module' => 'cms',
                'description' => 'Create new blog categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_category_store',
                'display_name' => 'Store Blog Category',
                'module' => 'cms',
                'description' => 'Store new blog categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_category_show',
                'display_name' => 'Show Blog Category',
                'module' => 'cms',
                'description' => 'View specific blog category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_category_edit',
                'display_name' => 'Edit Blog Category',
                'module' => 'cms',
                'description' => 'Edit blog categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_category_update',
                'display_name' => 'Update Blog Category',
                'module' => 'cms',
                'description' => 'Update blog categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'blog_category_destroy',
                'display_name' => 'Delete Blog Category',
                'module' => 'cms',
                'description' => 'Delete blog categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'comment_list_view',
                'display_name' => 'View Comment List',
                'module' => 'cms',
                'description' => 'View blog comments',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'comment_show',
                'display_name' => 'Show Comment',
                'module' => 'cms',
                'description' => 'View specific comment',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'comment_status_update',
                'display_name' => 'Update Comment Status',
                'module' => 'cms',
                'description' => 'Update comment status',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'comment_delete',
                'display_name' => 'Delete Comment',
                'module' => 'cms',
                'description' => 'Delete comments',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Pages Management
            [
                'name' => 'pages_management',
                'display_name' => 'Pages Management',
                'module' => 'pages',
                'description' => 'Manage static pages',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'about_us_view',
                'display_name' => 'View About Us',
                'module' => 'pages',
                'description' => 'View about us page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'about_us_update',
                'display_name' => 'Update About Us',
                'module' => 'pages',
                'description' => 'Update about us page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'contact_us_view',
                'display_name' => 'View Contact Us',
                'module' => 'pages',
                'description' => 'View contact us page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'contact_us_update',
                'display_name' => 'Update Contact Us',
                'module' => 'pages',
                'description' => 'Update contact us page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'terms_conditions_view',
                'display_name' => 'View Terms & Conditions',
                'module' => 'pages',
                'description' => 'View terms and conditions',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'terms_conditions_update',
                'display_name' => 'Update Terms & Conditions',
                'module' => 'pages',
                'description' => 'Update terms and conditions',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'privacy_policy_view',
                'display_name' => 'View Privacy Policy',
                'module' => 'pages',
                'description' => 'View privacy policy',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'privacy_policy_update',
                'display_name' => 'Update Privacy Policy',
                'module' => 'pages',
                'description' => 'Update privacy policy',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'faq_view',
                'display_name' => 'View FAQ',
                'module' => 'pages',
                'description' => 'View FAQ page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'faq_create',
                'display_name' => 'Create FAQ',
                'module' => 'pages',
                'description' => 'Create FAQ page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'faq_edit',
                'display_name' => 'Edit FAQ',
                'module' => 'pages',
                'description' => 'Edit FAQ page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'faq_update',
                'display_name' => 'Update FAQ',
                'module' => 'pages',
                'description' => 'Update FAQ page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'faq_delete',
                'display_name' => 'Delete FAQ',
                'module' => 'pages',
                'description' => 'Delete FAQ page',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'custom_page_view',
                'display_name' => 'View Custom Pages',
                'module' => 'pages',
                'description' => 'View custom pages',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'custom_page_create',
                'display_name' => 'Create Custom Pages',
                'module' => 'pages',
                'description' => 'Create custom pages',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'custom_page_edit',
                'display_name' => 'Edit Custom Pages',
                'module' => 'pages',
                'description' => 'Edit custom pages',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'custom_page_update',
                'display_name' => 'Update Custom Pages',
                'module' => 'pages',
                'description' => 'Update custom pages',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'custom_page_delete',
                'display_name' => 'Delete Custom Pages',
                'module' => 'pages',
                'description' => 'Delete custom pages',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Section Management
            [
                'name' => 'section_management',
                'display_name' => 'Section Management',
                'module' => 'section',
                'description' => 'Manage frontend sections',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'intro_section_view',
                'display_name' => 'View Intro Section',
                'module' => 'section',
                'description' => 'View intro section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'intro_section_update',
                'display_name' => 'Update Intro Section',
                'module' => 'section',
                'description' => 'Update intro section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'intro2_section_view',
                'display_name' => 'View Intro Section 2',
                'module' => 'section',
                'description' => 'View intro section 2',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'intro2_section_update',
                'display_name' => 'Update Intro Section 2',
                'module' => 'section',
                'description' => 'Update intro section 2',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'working_step_view',
                'display_name' => 'View Working Step',
                'module' => 'section',
                'description' => 'View working step section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'working_step_update',
                'display_name' => 'Update Working Step',
                'module' => 'section',
                'description' => 'Update working step section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'our_feature_view',
                'display_name' => 'View Our Feature',
                'module' => 'section',
                'description' => 'View our feature section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'our_feature_update',
                'display_name' => 'Update Our Feature',
                'module' => 'section',
                'description' => 'Update our feature section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'join_seller_view',
                'display_name' => 'View Join Seller',
                'module' => 'section',
                'description' => 'View join seller section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'join_seller_update',
                'display_name' => 'Update Join Seller',
                'module' => 'section',
                'description' => 'Update join seller section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'explore_section_view',
                'display_name' => 'View Explore Section',
                'module' => 'section',
                'description' => 'View explore section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'explore_section_update',
                'display_name' => 'Update Explore Section',
                'module' => 'section',
                'description' => 'Update explore section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'footer_view',
                'display_name' => 'View Footer Info',
                'module' => 'section',
                'description' => 'View footer information',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'footer_update',
                'display_name' => 'Update Footer Info',
                'module' => 'section',
                'description' => 'Update footer information',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'testimonial_view',
                'display_name' => 'View Testimonials',
                'module' => 'section',
                'description' => 'View testimonials',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'testimonial_create',
                'display_name' => 'Create Testimonials',
                'module' => 'section',
                'description' => 'Create testimonials',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'testimonial_edit',
                'display_name' => 'Edit Testimonials',
                'module' => 'section',
                'description' => 'Edit testimonials',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'testimonial_update',
                'display_name' => 'Update Testimonials',
                'module' => 'section',
                'description' => 'Update testimonials',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'testimonial_delete',
                'display_name' => 'Delete Testimonials',
                'module' => 'section',
                'description' => 'Delete testimonials',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'splash_screen_view',
                'display_name' => 'View Splash Screen',
                'module' => 'section',
                'description' => 'View splash screen settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'splash_screen_update',
                'display_name' => 'Update Splash Screen',
                'module' => 'section',
                'description' => 'Update splash screen settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'slider_view',
                'display_name' => 'View Slider Section',
                'module' => 'section',
                'description' => 'View slider section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'slider_create',
                'display_name' => 'Create Slider Section',
                'module' => 'section',
                'description' => 'Create slider section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'slider_edit',
                'display_name' => 'Edit Slider Section',
                'module' => 'section',
                'description' => 'Edit slider section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'slider_delete',
                'display_name' => 'Delete Slider Section',
                'module' => 'section',
                'description' => 'Delete slider section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'slider_update',
                'display_name' => 'Update Slider Section',
                'module' => 'section',
                'description' => 'Update slider section',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Settings & Configuration
            [
                'name' => 'settings_management',
                'display_name' => 'Settings & Configuration',
                'module' => 'settings',
                'description' => 'Manage system settings and configuration',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'general_setting_view',
                'display_name' => 'View General Settings',
                'module' => 'settings',
                'description' => 'View general settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'general_setting_update',
                'display_name' => 'Update General Settings',
                'module' => 'settings',
                'description' => 'Update general settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'update_logo_favicon',
                'display_name' => 'Update Logo & Favicon',
                'module' => 'settings',
                'description' => 'Update logo and favicon',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'update_google_captcha',
                'display_name' => 'Update Google Captcha',
                'module' => 'settings',
                'description' => 'Update Google Captcha settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'update_tawk_chat',
                'display_name' => 'Update Tawk Chat',
                'module' => 'settings',
                'description' => 'Update Tawk Chat settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'update_google_analytic',
                'display_name' => 'Update Google Analytic',
                'module' => 'settings',
                'description' => 'Update Google Analytic settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'update_facebook_pixel',
                'display_name' => 'Update Facebook Pixel',
                'module' => 'settings',
                'description' => 'Update Facebook Pixel settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'database_clear',
                'display_name' => 'Clear Database',
                'module' => 'settings',
                'description' => 'Clear database',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Multi Currency Management
            [
                'name' => 'multi_currency_management',
                'display_name' => 'Multi Currency Management',
                'module' => 'multi_currency',
                'description' => 'Manage multi currency settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'multi_currency_view',
                'display_name' => 'View Multi Currency',
                'module' => 'multi_currency',
                'description' => 'View multi currency settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'multi_currency_create',
                'display_name' => 'Create Multi Currency',
                'module' => 'multi_currency',
                'description' => 'Create multi currency settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'multi_currency_edit',
                'display_name' => 'Edit Multi Currency',
                'module' => 'multi_currency',
                'description' => 'Edit multi currency settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'multi_currency_update',
                'display_name' => 'Update Multi Currency',
                'module' => 'multi_currency',
                'description' => 'Update multi currency settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'multi_currency_delete',
                'display_name' => 'Delete Multi Currency',
                'module' => 'multi_currency',
                'description' => 'Delete multi currency settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Language Management
            [
                'name' => 'language_management',
                'display_name' => 'Language Management',
                'module' => 'language',
                'description' => 'Manage language settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'language_view',
                'display_name' => 'View Languages',
                'module' => 'language',
                'description' => 'View language settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'language_create',
                'display_name' => 'Create Languages',
                'module' => 'language',
                'description' => 'Create language settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'language_edit',
                'display_name' => 'Edit Languages',
                'module' => 'language',
                'description' => 'Edit language settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'language_update',
                'display_name' => 'Update Languages',
                'module' => 'language',
                'description' => 'Update language settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'language_delete',
                'display_name' => 'Delete Languages',
                'module' => 'language',
                'description' => 'Delete language settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'theme_language_view',
                'display_name' => 'View Theme Languages',
                'module' => 'language',
                'description' => 'View theme language settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'theme_language_update',
                'display_name' => 'Update Theme Languages',
                'module' => 'language',
                'description' => 'Update theme language settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Email Management
            [
                'name' => 'email_management',
                'display_name' => 'Email Management',
                'module' => 'email',
                'description' => 'Manage email settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'email_setting_view',
                'display_name' => 'View Email Configuration',
                'module' => 'email',
                'description' => 'View email configuration',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'email_setting_update',
                'display_name' => 'Update Email Configuration',
                'module' => 'email',
                'description' => 'Update email configuration',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'email_template_view',
                'display_name' => 'View Email Template',
                'module' => 'email',
                'description' => 'View email templates',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'email_template_edit',
                'display_name' => 'Edit Email Template',
                'module' => 'email',
                'description' => 'Edit email templates',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'email_template_update',
                'display_name' => 'Update Email Template',
                'module' => 'email',
                'description' => 'Update email templates',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Website Setup Management
            [
                'name' => 'website_setup_management',
                'display_name' => 'Website Setup Management',
                'module' => 'website_setup',
                'description' => 'Manage website setup settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'cookie_consent_view',
                'display_name' => 'View Cookie Consent',
                'module' => 'website_setup',
                'description' => 'View cookie consent settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'cookie_consent_update',
                'display_name' => 'Update Cookie Consent',
                'module' => 'website_setup',
                'description' => 'Update cookie consent settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'error_image_view',
                'display_name' => 'View Error Page',
                'module' => 'website_setup',
                'description' => 'View error page settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'error_image_update',
                'display_name' => 'Update Error Page',
                'module' => 'website_setup',
                'description' => 'Update error page settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'login_image_view',
                'display_name' => 'View Login Page',
                'module' => 'website_setup',
                'description' => 'View login page settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'login_image_update',
                'display_name' => 'Update Login Page',
                'module' => 'website_setup',
                'description' => 'Update login page settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_login_image_view',
                'display_name' => 'View Admin Login',
                'module' => 'website_setup',
                'description' => 'View admin login page settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_login_image_update',
                'display_name' => 'Update Admin Login',
                'module' => 'website_setup',
                'description' => 'Update admin login page settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'breadcrumb_view',
                'display_name' => 'View Breadcrumb Image',
                'module' => 'website_setup',
                'description' => 'View breadcrumb image settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'breadcrumb_update',
                'display_name' => 'Update Breadcrumb Image',
                'module' => 'website_setup',
                'description' => 'Update breadcrumb image settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'social_login_view',
                'display_name' => 'View Social Login',
                'module' => 'website_setup',
                'description' => 'View social login settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'social_login_update',
                'display_name' => 'Update Social Login',
                'module' => 'website_setup',
                'description' => 'Update social login settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'default_avatar_view',
                'display_name' => 'View Default Avatar',
                'module' => 'website_setup',
                'description' => 'View default avatar settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'default_avatar_update',
                'display_name' => 'Update Default Avatar',
                'module' => 'website_setup',
                'description' => 'Update default avatar settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'default_placeholder_view',
                'display_name' => 'View Default Placeholder',
                'module' => 'website_setup',
                'description' => 'View default placeholder settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'default_placeholder_update',
                'display_name' => 'Update Default Placeholder',
                'module' => 'website_setup',
                'description' => 'Update default placeholder settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'maintenance_mode_view',
                'display_name' => 'View Maintenance Mode',
                'module' => 'website_setup',
                'description' => 'View maintenance mode settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'maintenance_mode_update',
                'display_name' => 'Update Maintenance Mode',
                'module' => 'website_setup',
                'description' => 'Update maintenance mode settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // SEO Setup Management
            [
                'name' => 'seo_setting_management',
                'display_name' => 'SEO Setup Management',
                'module' => 'seo_setup',
                'description' => 'Manage SEO settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'seo_setting_view',
                'display_name' => 'View SEO Setup',
                'module' => 'seo_setup',
                'description' => 'View SEO settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'seo_setting_update',
                'display_name' => 'Update SEO Setup',
                'module' => 'seo_setup',
                'description' => 'Update SEO settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            //Payment Method Management
            [
                'name' => 'payment_method_management',
                'display_name' => 'Payment Method Management',
                'module' => 'payment_method',
                'description' => 'Manage payment method settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'payment_gateway_view',
                'display_name' => 'View Payment Method',
                'module' => 'payment_method',
                'description' => 'View payment gateway settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'payment_gateway_update',
                'display_name' => 'Update Payment Method',
                'module' => 'payment_method',
                'description' => 'Update payment gateway settings',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Admin Team Management
            [
                'name' => 'admin_team_management',
                'display_name' => 'Admin Team Management',
                'module' => 'admin_team',
                'description' => 'Manage admin team, roles and permissions',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'admin_role_view',
                'display_name' => 'View Admin Roles',
                'module' => 'admin_team',
                'description' => 'View admin roles',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_role_create',
                'display_name' => 'Create Admin Role',
                'module' => 'admin_team',
                'description' => 'Create new admin roles',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_role_edit',
                'display_name' => 'Edit Admin Role',
                'module' => 'admin_team',
                'description' => 'Edit admin roles',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_role_delete',
                'display_name' => 'Delete Admin Role',
                'module' => 'admin_team',
                'description' => 'Delete admin roles',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_permission_view',
                'display_name' => 'View Admin Permissions',
                'module' => 'admin_team',
                'description' => 'View admin permissions',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_role_assign',
                'display_name' => 'Assign Admin Roles',
                'module' => 'admin_team',
                'description' => 'Assign roles to admin users',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_list_view',
                'display_name' => 'View Admin List',
                'module' => 'admin_team',
                'description' => 'View admin list',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_create',
                'display_name' => 'Admin Create ',
                'module' => 'admin_team',
                'description' => 'Admin Create',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_edit',
                'display_name' => 'Admin Edit ',
                'module' => 'admin_team',
                'description' => 'Admin Edit',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'admin_delete',
                'display_name' => 'Admin Delete ',
                'module' => 'admin_team',
                'description' => 'Admin Delete',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Newsletter Management
            [
                'name' => 'newsletter_management',
                'display_name' => 'Newsletter Management',
                'module' => 'newsletter',
                'description' => 'Manage newsletter settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'subscriber_list_view',
                'display_name' => 'View Subscriber List',
                'module' => 'newsletter',
                'description' => 'View subscriber list',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'subscriber_list_delete',
                'display_name' => 'Delete Subscriber List',
                'module' => 'newsletter',
                'description' => 'Delete subscriber list',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'send_email_to_subscriber',
                'display_name' => 'Send Email to Subscriber',
                'module' => 'newsletter',
                'description' => 'Send email to subscriber',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',

            ],

            // Others Management
            [
                'name' => 'others_item_management',
                'display_name' => 'Others Item Management',
                'module' => 'others_item',
                'description' => 'Other administrative functions',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'cache_clear_view',
                'display_name' => 'Cache Clear',
                'module' => 'others_item',
                'description' => 'Clear application cache',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
        ];

        $groupIds = [];
        foreach ($permissions as $index => $permission) {
            if ($permission['is_group']) {
                $createdPermission = AdminPermissionList::updateOrCreate(
                    ['name' => $permission['name']],
                    $permission
                );
                $groupIds[$permission['name']] = $createdPermission->id;
            }
        }

        foreach ($permissions as $permission) {
            if (!$permission['is_group']) {
                $parentGroupName = $this->getParentGroupName($permission['module']);
                if (isset($groupIds[$parentGroupName])) {
                    $permission['parent_id'] = $groupIds[$parentGroupName];
                }

                AdminPermissionList::updateOrCreate(
                    ['name' => $permission['name']],
                    $permission
                );
            }
        }


        // $per_list = [];

        // foreach ($permissions as $permission) {
        //     if (!$permission['is_group'] && $permission['module'] === 'job') {
        //         $parentGroupName = $this->getParentGroupName($permission['module']);
        //         if (isset($groupIds[$parentGroupName])) {
        //             $permission['parent_id'] = $groupIds[$parentGroupName];
        //         }

        //         $per_list[] = $permission;

        //         // AdminPermissionList::updateOrCreate(
        //         //     ['name' => $permission['name']],
        //         //     $permission
        //         // );
        //     }
        // }

        // Log::info($per_list);

    }

    private function getParentGroupName($module)
    {
        $groupMapping = [
            'dashboard' => 'dashboard_management',
            'profile' => 'profile_management',
            'order' => 'order_management',
            'service' => 'service_management',
            'jobpost' => 'jobpost_management',
            'refund' => 'refund_management',
            'subscription' => 'subscription_management',
            'kyc' => 'kyc_management',
            'withdraw' => 'withdraw_management',
            'seller' => 'seller_management',
            'buyer' => 'buyer_management',
            'contact' => 'contact_message_management',
            'service_reports' => 'service_reports_management',

            'cms' => 'cms_management',
            'pages' => 'pages_management',
            'section' => 'section_management',


            'settings' => 'settings_management',
            'multi_currency' => 'multi_currency_management',
            'language' => 'language_management',
            'email' => 'email_management',
            'website_setup' => 'website_setup_management',
            'seo_setup' => 'seo_setting_management',
            'payment_method' => 'payment_method_management',
            'admin_team' => 'admin_team_management',
            'newsletter' => 'newsletter_management',
            'others_item' => 'others_item_management',


        ];
        return $groupMapping[$module] ?? null;
    }
}
