@extends('layout')
@section('title')
    <title>{{ env('APP_NAME') }} || {{ __('translate.Payment') }}</title>
@endsection

@section('front-content')
    <!-- Main Start -->
    <main>
        <!-- Breadcrumb -->
        <section class="w-breadcrumb-area"
            style="background-image: url({{ custom_asset($general_setting->breadcrumb_image) }});">
            <div class="container">
                <div class="row">
                    <div class="col-auto">
                        <div class="position-relative z-2" data-aos="fade-up" data-aos-duration="1000" data-aos-easing="linear">
                            <h2 class="section-title-light mb-2">{{ __('translate.Payment') }}</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb w-breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('translate.Home') }}</a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        {{ __('translate.Payment') }}
                                    </li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Breadcrumb End -->



        <!-- Services Details Start -->
        <section class="py-110 bg-offWhite">
            <div class="container">
                <div class="row row-gap-4">
                    <!-- Left -->
                    <div class="col-xl-4 mt-30 mt-xl-0">
                        <aside class="d-flex flex-column gap-4">
                            <div>
                                <div class="package-header">
                                    <p>{{ __('translate.Package Information') }}</p>
                                </div>
                                <div class="package-tab-content bg-white">
                                    @if ($package_name == 'Basic')
                                        <div>
                                            <div class="d-flex mb-2 justify-content-between align-items-center">
                                                <h4 class="package-name fw-semibold">{{ __('translate.Basic') }}</h4>
                                                <h3 class="package-price fw-bold">
                                                    {{ currency($service_package->basic_price) }}</h3>
                                            </div>
                                            <p class="text-dark-200 fs-6">
                                                {{ $service_package->basic_description }}
                                            </p>
                                            <div class="d-flex align-items-center gap-4 pt-2 pb04">
                                                <p class="package-title d-flex gap-2 align-items-center">
                                                    <svg width="18" height="18" viewBox="0 0 18 18" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M12.2067 10.5894L9.69703 8.70714V4.87293C9.69703 4.48741 9.38541 4.17578 8.99988 4.17578C8.61436 4.17578 8.30273 4.48741 8.30273 4.87293V9.05575C8.30273 9.27534 8.40592 9.48241 8.58159 9.61347L11.3701 11.7049C11.4956 11.799 11.642 11.8443 11.7877 11.8443C12.0003 11.8443 12.2095 11.7488 12.3461 11.5647C12.5776 11.2573 12.5149 10.8202 12.2067 10.5894Z"
                                                            fill="#06131C" />
                                                        <path
                                                            d="M9 0C4.0371 0 0 4.0371 0 9C0 13.9629 4.0371 18 9 18C13.9629 18 18 13.9629 18 9C18 4.0371 13.9629 0 9 0ZM9 16.6057C4.80674 16.6057 1.39426 13.1933 1.39426 9C1.39426 4.80674 4.80674 1.39426 9 1.39426C13.194 1.39426 16.6057 4.80674 16.6057 9C16.6057 13.1933 13.1933 16.6057 9 16.6057Z"
                                                            fill="#06131C" />
                                                    </svg>
                                                    {{ $service_package->basic_delivery_date }}
                                                    {{ __('translate.Day Delivery') }}
                                                </p>
                                                <p class="package-title d-flex gap-2 align-items-center">
                                                    <svg width="14" height="18" viewBox="0 0 14 18" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M7.65918 0.000467673C7.63557 -0.000442585 7.61192 -2.38521e-05 7.58836 0.00172189C7.46703 0.0129311 7.35144 0.0590761 7.25535 0.134669L4.71057 2.0599C4.63134 2.11968 4.56702 2.19728 4.52271 2.28655C4.47841 2.37582 4.45534 2.47428 4.45534 2.57413C4.45534 2.67397 4.47841 2.77244 4.52271 2.86171C4.56702 2.95097 4.63134 3.02858 4.71057 3.08836L7.25535 5.01735C7.32198 5.07115 7.39865 5.11087 7.4808 5.13415C7.56295 5.15742 7.6489 5.16377 7.73353 5.15283C7.81817 5.14188 7.89975 5.11386 7.97344 5.07042C8.04712 5.02699 8.11139 4.96904 8.16243 4.90002C8.21346 4.831 8.25022 4.75232 8.2705 4.66866C8.29079 4.585 8.2942 4.49808 8.28051 4.41307C8.26683 4.32806 8.23635 4.2467 8.19087 4.17382C8.14539 4.10095 8.08585 4.03806 8.0158 3.98889L6.99689 3.21629C10.1668 3.21628 12.7264 5.79487 12.7264 8.99448C12.7264 9.16496 12.7935 9.32846 12.9129 9.449C13.0323 9.56955 13.1943 9.63727 13.3632 9.63727C13.5321 9.63727 13.6941 9.56955 13.8135 9.449C13.9329 9.32846 14 9.16496 14 8.99448C14 5.10267 10.8569 1.9347 7.00186 1.93197L8.0158 1.16313C8.12387 1.0845 8.20475 0.973607 8.24704 0.846092C8.28932 0.718577 8.29088 0.580879 8.25148 0.452426C8.21208 0.323972 8.13371 0.211248 8.02744 0.130158C7.92117 0.0490672 7.79236 0.00370371 7.65918 0.000467673ZM0.617556 8.35232C0.452091 8.35726 0.295043 8.42708 0.179744 8.54697C0.0644443 8.66687 -3.14633e-05 8.82739 1.15183e-08 8.99448C1.15183e-08 12.888 3.13957 16.0633 6.99689 16.0633L5.98296 16.8309C5.9129 16.88 5.85336 16.9429 5.80789 17.0158C5.76241 17.0887 5.73192 17.17 5.71824 17.255C5.70456 17.34 5.70796 17.427 5.72825 17.5106C5.74854 17.5943 5.78529 17.673 5.83633 17.742C5.88736 17.811 5.95164 17.869 6.02532 17.9124C6.099 17.9558 6.18059 17.9838 6.26522 17.9948C6.34986 18.0057 6.43581 17.9994 6.51796 17.9761C6.60011 17.9528 6.67678 17.9131 6.74341 17.8593L9.28943 15.9303C9.36795 15.8705 9.43164 15.7931 9.4755 15.7042C9.51935 15.6152 9.54218 15.5173 9.54218 15.418C9.54218 15.3187 9.51935 15.2207 9.4755 15.1318C9.43164 15.0429 9.36795 14.9655 9.28943 14.9056L6.74341 12.9766C6.62554 12.885 6.47956 12.8379 6.33088 12.8437C6.19875 12.849 6.07154 12.8957 5.96696 12.9774C5.86237 13.0591 5.7856 13.1716 5.74733 13.2994C5.70906 13.4271 5.71118 13.5638 5.75341 13.6902C5.79565 13.8167 5.87588 13.9268 5.98296 14.0051L7.00559 14.7777H6.99689C3.82701 14.7777 1.27239 12.1941 1.27239 8.99448C1.2724 8.90855 1.25534 8.82349 1.2222 8.74434C1.18906 8.66519 1.14052 8.59355 1.07946 8.53367C1.0184 8.47379 0.946061 8.42689 0.86672 8.39574C0.787379 8.36459 0.702652 8.34983 0.617556 8.35232Z"
                                                            fill="black" />
                                                    </svg>
                                                    {{ $service_package->basic_revision }} {{ __('translate.Revisions') }}
                                                </p>
                                            </div>
                                            <ul class="py-4">
                                                @if ($service_package->basic_fn_website == 'yes')
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                            height="14" viewBox="0 0 14 14" fill="none">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path
                                                                d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                fill="#06131C" />
                                                        </svg>{{ __('translate.Functional website') }}
                                                    </li>
                                                @else
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">

                                                        <svg width="14" height="14" viewBox="0 0 14 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                stroke="#28303F" stroke-width="1.1705"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        {{ __('translate.Functional website') }}
                                                    </li>
                                                @endif

                                                <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                        viewBox="0 0 14 14" fill="none">
                                                        <rect width="14" height="14" rx="7" fill="#EDEBE7" />
                                                        <path
                                                            d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                            fill="#06131C" />
                                                    </svg>{{ $service_package->basic_page }} {{ __('translate.Pages') }}
                                                </li>

                                                @if ($service_package->basic_responsive == 'yes')
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                            height="14" viewBox="0 0 14 14" fill="none">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path
                                                                d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                fill="#06131C" />
                                                        </svg>{{ __('translate.Responsive design') }}
                                                    </li>
                                                @else
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg width="14" height="14" viewBox="0 0 14 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                stroke="#28303F" stroke-width="1.1705"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        {{ __('translate.Responsive design') }}
                                                    </li>
                                                    @endif @if ($service_package->basic_source_code == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Source file') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Source file') }}
                                                        </li>
                                                    @endif

                                                    @if ($service_package->basic_content_upload == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Content upload') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Content upload') }}
                                                        </li>
                                                    @endif

                                                    @if ($service_package->basic_speed_optimized == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Speed optimization') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Speed optimization') }}
                                                        </li>
                                                    @endif

                                            </ul>

                                        </div>
                                    @elseif ($package_name == 'Standard')
                                        <div>
                                            <div class="d-flex mb-2 justify-content-between align-items-center">
                                                <h4 class="package-name fw-semibold">{{ __('translate.Standard') }}</h4>
                                                <h3 class="package-price fw-bold">
                                                    {{ currency($service_package->standard_price) }}</h3>
                                            </div>
                                            <p class="text-dark-200 fs-6">
                                                {{ $service_package->standard_description }}
                                            </p>
                                            <div class="d-flex align-items-center gap-4 pt-2 pb04">
                                                <p class="package-title d-flex gap-2 align-items-center">
                                                    <svg width="18" height="18" viewBox="0 0 18 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M12.2067 10.5894L9.69703 8.70714V4.87293C9.69703 4.48741 9.38541 4.17578 8.99988 4.17578C8.61436 4.17578 8.30273 4.48741 8.30273 4.87293V9.05575C8.30273 9.27534 8.40592 9.48241 8.58159 9.61347L11.3701 11.7049C11.4956 11.799 11.642 11.8443 11.7877 11.8443C12.0003 11.8443 12.2095 11.7488 12.3461 11.5647C12.5776 11.2573 12.5149 10.8202 12.2067 10.5894Z"
                                                            fill="#06131C" />
                                                        <path
                                                            d="M9 0C4.0371 0 0 4.0371 0 9C0 13.9629 4.0371 18 9 18C13.9629 18 18 13.9629 18 9C18 4.0371 13.9629 0 9 0ZM9 16.6057C4.80674 16.6057 1.39426 13.1933 1.39426 9C1.39426 4.80674 4.80674 1.39426 9 1.39426C13.194 1.39426 16.6057 4.80674 16.6057 9C16.6057 13.1933 13.1933 16.6057 9 16.6057Z"
                                                            fill="#06131C" />
                                                    </svg>
                                                    {{ $service_package->standard_delivery_date }}
                                                    {{ __('translate.Day Delivery') }}
                                                </p>
                                                <p class="package-title d-flex gap-2 align-items-center">
                                                    <svg width="14" height="18" viewBox="0 0 14 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M7.65918 0.000467673C7.63557 -0.000442585 7.61192 -2.38521e-05 7.58836 0.00172189C7.46703 0.0129311 7.35144 0.0590761 7.25535 0.134669L4.71057 2.0599C4.63134 2.11968 4.56702 2.19728 4.52271 2.28655C4.47841 2.37582 4.45534 2.47428 4.45534 2.57413C4.45534 2.67397 4.47841 2.77244 4.52271 2.86171C4.56702 2.95097 4.63134 3.02858 4.71057 3.08836L7.25535 5.01735C7.32198 5.07115 7.39865 5.11087 7.4808 5.13415C7.56295 5.15742 7.6489 5.16377 7.73353 5.15283C7.81817 5.14188 7.89975 5.11386 7.97344 5.07042C8.04712 5.02699 8.11139 4.96904 8.16243 4.90002C8.21346 4.831 8.25022 4.75232 8.2705 4.66866C8.29079 4.585 8.2942 4.49808 8.28051 4.41307C8.26683 4.32806 8.23635 4.2467 8.19087 4.17382C8.14539 4.10095 8.08585 4.03806 8.0158 3.98889L6.99689 3.21629C10.1668 3.21628 12.7264 5.79487 12.7264 8.99448C12.7264 9.16496 12.7935 9.32846 12.9129 9.449C13.0323 9.56955 13.1943 9.63727 13.3632 9.63727C13.5321 9.63727 13.6941 9.56955 13.8135 9.449C13.9329 9.32846 14 9.16496 14 8.99448C14 5.10267 10.8569 1.9347 7.00186 1.93197L8.0158 1.16313C8.12387 1.0845 8.20475 0.973607 8.24704 0.846092C8.28932 0.718577 8.29088 0.580879 8.25148 0.452426C8.21208 0.323972 8.13371 0.211248 8.02744 0.130158C7.92117 0.0490672 7.79236 0.00370371 7.65918 0.000467673ZM0.617556 8.35232C0.452091 8.35726 0.295043 8.42708 0.179744 8.54697C0.0644443 8.66687 -3.14633e-05 8.82739 1.15183e-08 8.99448C1.15183e-08 12.888 3.13957 16.0633 6.99689 16.0633L5.98296 16.8309C5.9129 16.88 5.85336 16.9429 5.80789 17.0158C5.76241 17.0887 5.73192 17.17 5.71824 17.255C5.70456 17.34 5.70796 17.427 5.72825 17.5106C5.74854 17.5943 5.78529 17.673 5.83633 17.742C5.88736 17.811 5.95164 17.869 6.02532 17.9124C6.099 17.9558 6.18059 17.9838 6.26522 17.9948C6.34986 18.0057 6.43581 17.9994 6.51796 17.9761C6.60011 17.9528 6.67678 17.9131 6.74341 17.8593L9.28943 15.9303C9.36795 15.8705 9.43164 15.7931 9.4755 15.7042C9.51935 15.6152 9.54218 15.5173 9.54218 15.418C9.54218 15.3187 9.51935 15.2207 9.4755 15.1318C9.43164 15.0429 9.36795 14.9655 9.28943 14.9056L6.74341 12.9766C6.62554 12.885 6.47956 12.8379 6.33088 12.8437C6.19875 12.849 6.07154 12.8957 5.96696 12.9774C5.86237 13.0591 5.7856 13.1716 5.74733 13.2994C5.70906 13.4271 5.71118 13.5638 5.75341 13.6902C5.79565 13.8167 5.87588 13.9268 5.98296 14.0051L7.00559 14.7777H6.99689C3.82701 14.7777 1.27239 12.1941 1.27239 8.99448C1.2724 8.90855 1.25534 8.82349 1.2222 8.74434C1.18906 8.66519 1.14052 8.59355 1.07946 8.53367C1.0184 8.47379 0.946061 8.42689 0.86672 8.39574C0.787379 8.36459 0.702652 8.34983 0.617556 8.35232Z"
                                                            fill="black" />
                                                    </svg>
                                                    {{ $service_package->standard_revision }}
                                                    {{ __('translate.Revisions') }}
                                                </p>
                                            </div>
                                            <ul class="py-4">
                                                @if ($service_package->standard_fn_website == 'yes')
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                            height="14" viewBox="0 0 14 14" fill="none">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path
                                                                d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                fill="#06131C" />
                                                        </svg>{{ __('translate.Functional website') }}
                                                    </li>
                                                @else
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">

                                                        <svg width="14" height="14" viewBox="0 0 14 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                stroke="#28303F" stroke-width="1.1705"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        {{ __('translate.Functional website') }}
                                                    </li>
                                                @endif

                                                <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                        viewBox="0 0 14 14" fill="none">
                                                        <rect width="14" height="14" rx="7"
                                                            fill="#EDEBE7" />
                                                        <path
                                                            d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                            fill="#06131C" />
                                                    </svg>{{ $service_package->standard_page }}
                                                    {{ __('translate.Pages') }}
                                                </li>

                                                @if ($service_package->standard_responsive == 'yes')
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                            height="14" viewBox="0 0 14 14" fill="none">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path
                                                                d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                fill="#06131C" />
                                                        </svg>{{ __('translate.Responsive design') }}
                                                    </li>
                                                @else
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg width="14" height="14" viewBox="0 0 14 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                stroke="#28303F" stroke-width="1.1705"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        {{ __('translate.Responsive design') }}
                                                    </li>
                                                    @endif @if ($service_package->standard_source_code == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Source file') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Source file') }}
                                                        </li>
                                                    @endif

                                                    @if ($service_package->standard_content_upload == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Content upload') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Content upload') }}
                                                        </li>
                                                    @endif

                                                    @if ($service_package->standard_speed_optimized == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Speed optimization') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Speed optimization') }}
                                                        </li>
                                                    @endif

                                            </ul>

                                        </div>
                                    @elseif ($package_name == 'Premium')
                                        <div>
                                            <div class="d-flex mb-2 justify-content-between align-items-center">
                                                <h4 class="package-name fw-semibold">{{ __('translate.Standard') }}</h4>
                                                <h3 class="package-price fw-bold">
                                                    {{ currency($service_package->premium_price) }}</h3>
                                            </div>
                                            <p class="text-dark-200 fs-6">
                                                {{ $service_package->premium_description }}
                                            </p>
                                            <div class="d-flex align-items-center gap-4 pt-2 pb04">
                                                <p class="package-title d-flex gap-2 align-items-center">
                                                    <svg width="18" height="18" viewBox="0 0 18 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M12.2067 10.5894L9.69703 8.70714V4.87293C9.69703 4.48741 9.38541 4.17578 8.99988 4.17578C8.61436 4.17578 8.30273 4.48741 8.30273 4.87293V9.05575C8.30273 9.27534 8.40592 9.48241 8.58159 9.61347L11.3701 11.7049C11.4956 11.799 11.642 11.8443 11.7877 11.8443C12.0003 11.8443 12.2095 11.7488 12.3461 11.5647C12.5776 11.2573 12.5149 10.8202 12.2067 10.5894Z"
                                                            fill="#06131C" />
                                                        <path
                                                            d="M9 0C4.0371 0 0 4.0371 0 9C0 13.9629 4.0371 18 9 18C13.9629 18 18 13.9629 18 9C18 4.0371 13.9629 0 9 0ZM9 16.6057C4.80674 16.6057 1.39426 13.1933 1.39426 9C1.39426 4.80674 4.80674 1.39426 9 1.39426C13.194 1.39426 16.6057 4.80674 16.6057 9C16.6057 13.1933 13.1933 16.6057 9 16.6057Z"
                                                            fill="#06131C" />
                                                    </svg>
                                                    {{ $service_package->premium_delivery_date }}
                                                    {{ __('translate.Day Delivery') }}
                                                </p>
                                                <p class="package-title d-flex gap-2 align-items-center">
                                                    <svg width="14" height="18" viewBox="0 0 14 18"
                                                        fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                                            d="M7.65918 0.000467673C7.63557 -0.000442585 7.61192 -2.38521e-05 7.58836 0.00172189C7.46703 0.0129311 7.35144 0.0590761 7.25535 0.134669L4.71057 2.0599C4.63134 2.11968 4.56702 2.19728 4.52271 2.28655C4.47841 2.37582 4.45534 2.47428 4.45534 2.57413C4.45534 2.67397 4.47841 2.77244 4.52271 2.86171C4.56702 2.95097 4.63134 3.02858 4.71057 3.08836L7.25535 5.01735C7.32198 5.07115 7.39865 5.11087 7.4808 5.13415C7.56295 5.15742 7.6489 5.16377 7.73353 5.15283C7.81817 5.14188 7.89975 5.11386 7.97344 5.07042C8.04712 5.02699 8.11139 4.96904 8.16243 4.90002C8.21346 4.831 8.25022 4.75232 8.2705 4.66866C8.29079 4.585 8.2942 4.49808 8.28051 4.41307C8.26683 4.32806 8.23635 4.2467 8.19087 4.17382C8.14539 4.10095 8.08585 4.03806 8.0158 3.98889L6.99689 3.21629C10.1668 3.21628 12.7264 5.79487 12.7264 8.99448C12.7264 9.16496 12.7935 9.32846 12.9129 9.449C13.0323 9.56955 13.1943 9.63727 13.3632 9.63727C13.5321 9.63727 13.6941 9.56955 13.8135 9.449C13.9329 9.32846 14 9.16496 14 8.99448C14 5.10267 10.8569 1.9347 7.00186 1.93197L8.0158 1.16313C8.12387 1.0845 8.20475 0.973607 8.24704 0.846092C8.28932 0.718577 8.29088 0.580879 8.25148 0.452426C8.21208 0.323972 8.13371 0.211248 8.02744 0.130158C7.92117 0.0490672 7.79236 0.00370371 7.65918 0.000467673ZM0.617556 8.35232C0.452091 8.35726 0.295043 8.42708 0.179744 8.54697C0.0644443 8.66687 -3.14633e-05 8.82739 1.15183e-08 8.99448C1.15183e-08 12.888 3.13957 16.0633 6.99689 16.0633L5.98296 16.8309C5.9129 16.88 5.85336 16.9429 5.80789 17.0158C5.76241 17.0887 5.73192 17.17 5.71824 17.255C5.70456 17.34 5.70796 17.427 5.72825 17.5106C5.74854 17.5943 5.78529 17.673 5.83633 17.742C5.88736 17.811 5.95164 17.869 6.02532 17.9124C6.099 17.9558 6.18059 17.9838 6.26522 17.9948C6.34986 18.0057 6.43581 17.9994 6.51796 17.9761C6.60011 17.9528 6.67678 17.9131 6.74341 17.8593L9.28943 15.9303C9.36795 15.8705 9.43164 15.7931 9.4755 15.7042C9.51935 15.6152 9.54218 15.5173 9.54218 15.418C9.54218 15.3187 9.51935 15.2207 9.4755 15.1318C9.43164 15.0429 9.36795 14.9655 9.28943 14.9056L6.74341 12.9766C6.62554 12.885 6.47956 12.8379 6.33088 12.8437C6.19875 12.849 6.07154 12.8957 5.96696 12.9774C5.86237 13.0591 5.7856 13.1716 5.74733 13.2994C5.70906 13.4271 5.71118 13.5638 5.75341 13.6902C5.79565 13.8167 5.87588 13.9268 5.98296 14.0051L7.00559 14.7777H6.99689C3.82701 14.7777 1.27239 12.1941 1.27239 8.99448C1.2724 8.90855 1.25534 8.82349 1.2222 8.74434C1.18906 8.66519 1.14052 8.59355 1.07946 8.53367C1.0184 8.47379 0.946061 8.42689 0.86672 8.39574C0.787379 8.36459 0.702652 8.34983 0.617556 8.35232Z"
                                                            fill="black" />
                                                    </svg>
                                                    {{ $service_package->premium_revision }}
                                                    {{ __('translate.Revisions') }}
                                                </p>
                                            </div>
                                            <ul class="py-4">
                                                @if ($service_package->premium_fn_website == 'yes')
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                            height="14" viewBox="0 0 14 14" fill="none">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path
                                                                d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                fill="#06131C" />
                                                        </svg>{{ __('translate.Functional website') }}
                                                    </li>
                                                @else
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">

                                                        <svg width="14" height="14" viewBox="0 0 14 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                stroke="#28303F" stroke-width="1.1705"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        {{ __('translate.Functional website') }}
                                                    </li>
                                                @endif

                                                <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                                        viewBox="0 0 14 14" fill="none">
                                                        <rect width="14" height="14" rx="7"
                                                            fill="#EDEBE7" />
                                                        <path
                                                            d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                            fill="#06131C" />
                                                    </svg>{{ $service_package->premium_page }} {{ __('translate.Pages') }}
                                                </li>

                                                @if ($service_package->premium_responsive == 'yes')
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                            height="14" viewBox="0 0 14 14" fill="none">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path
                                                                d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                fill="#06131C" />
                                                        </svg>{{ __('translate.Responsive design') }}
                                                    </li>
                                                @else
                                                    <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                        <svg width="14" height="14" viewBox="0 0 14 14"
                                                            fill="none" xmlns="http://www.w3.org/2000/svg">
                                                            <rect width="14" height="14" rx="7"
                                                                fill="#EDEBE7" />
                                                            <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                stroke="#28303F" stroke-width="1.1705"
                                                                stroke-linecap="round" stroke-linejoin="round" />
                                                        </svg>
                                                        {{ __('translate.Responsive design') }}
                                                    </li>
                                                    @endif @if ($service_package->premium_source_code == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Source file') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Source file') }}
                                                        </li>
                                                    @endif

                                                    @if ($service_package->premium_content_upload == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Content upload') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Content upload') }}
                                                        </li>
                                                    @endif

                                                    @if ($service_package->premium_speed_optimized == 'yes')
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="14"
                                                                height="14" viewBox="0 0 14 14" fill="none">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path
                                                                    d="M10.9989 4.56984C11.0104 4.74646 10.9288 4.88498 10.8005 5.00444C9.44356 6.26706 8.08607 7.52917 6.72804 8.79076C6.43121 9.06522 6.10773 9.07037 5.8109 8.80209C5.26037 8.30466 4.71781 7.79934 4.18322 7.28612C4.12574 7.2337 4.07992 7.17091 4.04845 7.10145C4.01699 7.03199 4.00052 6.95727 4.00001 6.88169C3.99951 6.80612 4.01497 6.7312 4.0455 6.66138C4.07603 6.59155 4.12101 6.52821 4.17778 6.4751C4.40938 6.25368 4.7758 6.24441 5.03403 6.4751C5.33956 6.74338 5.63204 7.02659 5.92724 7.30363C6.25941 7.61259 6.25887 7.61259 6.60137 7.2959C7.68178 6.29109 8.76237 5.28749 9.84314 4.28508C9.92373 4.20401 10.0151 4.13322 10.115 4.07447C10.2055 4.02511 10.3083 3.99942 10.4127 4.00001C10.5172 4.0006 10.6196 4.02747 10.7095 4.07785C10.7995 4.12824 10.8736 4.20034 10.9245 4.28678C10.9753 4.37322 11.001 4.47091 10.9989 4.56984Z"
                                                                    fill="#06131C" />
                                                            </svg>{{ __('translate.Speed optimization') }}
                                                        </li>
                                                    @else
                                                        <li class="fs-6 d-flex align-items-center gap-3 text-dark-200">
                                                            <svg width="14" height="14" viewBox="0 0 14 14"
                                                                fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <rect width="14" height="14" rx="7"
                                                                    fill="#EDEBE7" />
                                                                <path d="M9.41422 5.00003L5 9.41425M9.41422 9.41422L5 5"
                                                                    stroke="#28303F" stroke-width="1.1705"
                                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                            </svg>
                                                            {{ __('translate.Speed optimization') }}
                                                        </li>
                                                    @endif

                                            </ul>

                                        </div>
                                    @endif


                                </div>
                            </div>
                        </aside>
                    </div>
                    <!-- Right -->
                    <div class="col-xl-8">
                        <div class="bg-white payment-options-wrapper">
                            <ul class="payment-options">
                                @if ($payment_setting->stripe_status == 1)
                                    <li class="single-payment-option position-relative" data-bs-toggle="modal"
                                        data-bs-target="#stripePayment">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->stripe_image) }}" alt="" />
                                    </li>
                                @endif

                                @if ($payment_setting->paypal_status == 1)
                                    <li class="single-payment-option position-relative" id="paypal_payment">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->paypal_image) }}" alt="" />
                                    </li>
                                @endif

                                @if ($payment_setting->razorpay_status == 1)
                                    <li class="single-payment-option position-relative" id="razorpay_btn">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->razorpay_image) }}" alt="" />
                                    </li>

                                    <form
                                        action="{{ route('payment.razorpay', ['service_package_id' => $service_package->id, 'package_name' => $package_name]) }}"
                                        method="POST" class="d-none">
                                        @csrf
                                        @php

                                            $payable_amount = $payable_amount * $razorpay_currency->currency_rate;
                                            $payable_amount = round($payable_amount, 2);
                                        @endphp
                                        <script src="https://checkout.razorpay.com/v1/checkout.js" data-key="{{ $payment_setting->razorpay_key }}"
                                            data-currency="{{ $razorpay_currency->currency_code }}" data-amount="{{ $payable_amount * 100 }}"
                                            data-buttontext="{{ __('translate.Pay') }}" data-name="{{ $payment_setting->razorpay_name }}"
                                            data-description="{{ $payment_setting->razorpay_description }}"
                                            data-image="{{ custom_asset($payment_setting->razorpay_image) }}" data-prefill.name="" data-prefill.email=""
                                            data-theme.color="{{ $payment_setting->razorpay_theme_color }}"></script>
                                    </form>
                                @endif


                                @if ($payment_setting->flutterwave_status == 1)
                                    <li class="single-payment-option position-relative" id="payWithFlutterwave">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->flutterwave_logo) }}" alt="" />
                                    </li>
                                @endif

                                @if ($payment_setting->mollie_status == 1)
                                    <li class="single-payment-option position-relative" id="mollie_payment">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->mollie_image) }}" alt="" />
                                    </li>
                                @endif


                                @if ($payment_setting->paystack_status == 1)
                                    <li class="single-payment-option position-relative" id="paystackPayment">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->paystack_image) }}" alt="" />
                                    </li>
                                @endif

                                @if ($payment_setting->instamojo_status == 1)
                                    <li class="single-payment-option position-relative" id="instamojoPayment">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->instamojo_image) }}" alt="" />
                                    </li>
                                @endif

                                @if ($payment_setting->bank_status == 1)
                                    <li class="single-payment-option position-relative" data-bs-toggle="modal"
                                        data-bs-target="#bankPayment">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset($payment_setting->bank_image) }}" alt="" />
                                    </li>
                                @endif


                                @if (checkModule('Wallet'))
                                    <li class="single-payment-option position-relative" id="walletPayment">
                                        <div class="selected-icon">
                                            <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M10.9919 21.9997C17.0625 21.9997 21.9837 17.0749 21.9837 10.9998C21.9837 4.9248 17.0625 0 10.9919 0C4.92122 0 0 4.9248 0 10.9998C0 17.0749 4.92122 21.9997 10.9919 21.9997Z"
                                                    fill="#22BE0D" />
                                                <path
                                                    d="M10.1583 14.0474C9.86772 14.052 9.58712 13.9413 9.3779 13.7394L6.87175 11.2754C6.66332 11.0697 6.54506 10.7896 6.543 10.4967C6.54093 10.2038 6.65524 9.92203 6.86076 9.71344C7.06628 9.50485 7.34619 9.38651 7.63891 9.38444C7.93162 9.38238 8.21317 9.49677 8.42161 9.70244L10.1583 11.4074L14.665 7.00748C14.7682 6.90564 14.8904 6.82514 15.0247 6.77058C15.159 6.71602 15.3027 6.68846 15.4477 6.68948C15.5926 6.6905 15.7359 6.72008 15.8694 6.77653C16.003 6.83298 16.1241 6.91519 16.2258 7.01848C16.3276 7.12176 16.408 7.24409 16.4626 7.37848C16.5171 7.51288 16.5446 7.6567 16.5436 7.80174C16.5426 7.94679 16.513 8.09021 16.4566 8.22382C16.4002 8.35743 16.318 8.47862 16.2148 8.58045L10.9277 13.7834C10.7144 13.9666 10.4391 14.0611 10.1583 14.0474Z"
                                                    fill="white" />
                                            </svg>
                                        </div>
                                        <img src="{{ custom_asset('uploads/website-images/wallet.png') }}" alt="" />
                                    </li>
                                @endif

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Services Details End -->


    </main>
    <!-- Main End -->


    {{-- start stripe modal --}}
    <div class="modal fade" id="stripePayment" tabindex="-1" aria-labelledby="jobDetailsModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="bg-white p-lg-5 rounded-3">
                        <div class="proposal-container">
                            <div class="proposal-header">
                                <h3 class="text-dark-300 text-24 fw-bold">{{ __('translate.Pay via Stripe') }}</h3>
                            </div>
                            <form class="stripe-modal-form require-validation " role="form"
                                action="{{ route('payment.stripe', ['service_package_id' => $service_package->id, 'package_name' => $package_name]) }}"
                                method="POST" data-cc-on-file="false"
                                data-stripe-publishable-key="{{ $payment_setting->stripe_key }}" id="payment-form">
                                @csrf

                                <div class="d-flex flex-column gap-4">

                                    <div class="proposal-input-container">
                                        <label for="amount"
                                            class="proposal-form-label">{{ __('translate.Card Number') }}*</label>
                                        <input type="text" class="form-control shadow-none card-number"
                                            placeholder="{{ __('translate.Card Number') }}" name="card_number" />
                                    </div>

                                    <div class="proposal-input-container">
                                        <label for="amount"
                                            class="proposal-form-label">{{ __('translate.Expired Month') }}*</label>
                                        <input type="text" class="form-control shadow-none card-expiry-month"
                                            placeholder="{{ __('translate.Expired Month') }}" name="month" />
                                    </div>

                                    <div class="proposal-input-container">
                                        <label for="amount"
                                            class="proposal-form-label">{{ __('translate.Expired Year') }}*</label>
                                        <input type="text" class="form-control shadow-none card-expiry-year"
                                            placeholder="{{ __('translate.Expired Year') }}" name="year" />
                                    </div>

                                    <div class="proposal-input-container">
                                        <label for="amount"
                                            class="proposal-form-label">{{ __('translate.CVC') }}*</label>
                                        <input type="text" class="form-control shadow-none card-cvc"
                                            placeholder="{{ __('translate.CVC') }}" name="cvc" />
                                    </div>

                                    <div class="proposal-input-container stripe_error d-none">
                                        <div class="stripe-modal-form-inner">
                                            <div class='alert-danger alert '>
                                                {{ __('translate.Please provide your valid card information') }}</div>
                                        </div>
                                    </div>


                                    <div class="d-flex gap-4 align-items-center justify-content-end">
                                        <button type="button" class="w-btn-gray-sm" data-bs-dismiss="modal">
                                            {{ __('translate.Cancel') }}
                                        </button>
                                        <button class="w-btn-secondary-sm">
                                            {{ __('translate.Pay Now') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- end stripe modal --}}


    {{-- start bank modal --}}
    <div class="modal fade" id="bankPayment" tabindex="-1" aria-labelledby="jobDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="bg-white p-lg-5 rounded-3">
                        <div class="proposal-container">
                            <div class="proposal-header">
                                <h3 class="text-dark-300 text-24 fw-bold">{{ __('translate.Pay via Bank') }}</h3>
                            </div>
                            <form
                                action="{{ route('payment.bank', ['service_package_id' => $service_package->id, 'package_name' => $package_name]) }}"
                                method="POST">
                                @csrf

                                <div class="mb-3">
                                    {!! clean(nl2br($payment_setting->bank_account_info)) !!}
                                </div>


                                <div class="d-flex flex-column gap-4">

                                    <div class="proposal-input-container">
                                        <label for="time"
                                            class="proposal-form-label">{{ __('translate.Transaction information') }}*</label>
                                        <textarea placeholder="{{ 'Transaction information' }}" class="form-textarea shadow-none" name="tnx_info"></textarea>
                                    </div>

                                    <div class="d-flex gap-4 align-items-center justify-content-end">
                                        <button type="button" class="w-btn-gray-sm" data-bs-dismiss="modal">
                                            {{ __('translate.Cancel') }}
                                        </button>
                                        <button class="w-btn-secondary-sm">
                                            {{ __('translate.Submit Now') }}
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- end bank modal --}}




@endsection


@push('js_section')
    <!-- Stripe JS -->

    <script type="text/javascript" src="https://js.stripe.com/v2/"></script>
    <script>
        "use strict";
        $(function() {

            var $form = $(".require-validation");
            $('form.require-validation').on('submit', function(e) {
                var $form = $(".require-validation"),
                    inputSelector = ['input[type=email]', 'input[type=password]',
                        'input[type=text]', 'input[type=file]',
                        'textarea'
                    ].join(', '),
                    $inputs = $form.find('.required').find(inputSelector),
                    $errorMessage = $form.find('div.stripe_error'),
                    valid = true;
                $errorMessage.addClass('d-none');

                $('.has-error').removeClass('has-error');
                $inputs.each(function(i, el) {
                    var $input = $(el);
                    if ($input.val() === '') {
                        $input.parent().addClass('has-error');
                        $errorMessage.removeClass('d-none');
                        e.preventDefault();
                    }
                });

                if (!$form.data('cc-on-file')) {
                    e.preventDefault();
                    Stripe.setPublishableKey($form.data('stripe-publishable-key'));
                    Stripe.createToken({
                        number: $('.card-number').val(),
                        cvc: $('.card-cvc').val(),
                        exp_month: $('.card-expiry-month').val(),
                        exp_year: $('.card-expiry-year').val()
                    }, stripeResponseHandler);
                }

            });

            function stripeResponseHandler(status, response) {
                if (response.error) {
                    $('.stripe_error')
                        .removeClass('d-none')
                        .find('.alert')
                        .text(response.error.message);
                } else {
                    var token = response['id'];
                    $form.find('input[type=text]').empty();
                    $form.append("<input type='hidden' name='stripeToken' value='" + token + "'/>");
                    $form.get(0).submit();
                }
            }

            $("#paypal_payment").on("click", function() {
                window.location.href = "{{ url('payment/paypal/') }}" + "/" +
                    "{{ $service_package->id }}" + "/" + "{{ $package_name }}";
            })


            $("#razorpay_btn").on("click", function() {
                $(".razorpay-payment-button").click();
            })

            $("#mollie_payment").on("click", function() {
                window.location.href = "{{ url('payment/mollie/') }}" + "/" +
                    "{{ $service_package->id }}" + "/" + "{{ $package_name }}";
            })

            $("#instamojoPayment").on("click", function() {
                window.location.href = "{{ url('payment/instamojo/') }}" + "/" +
                    "{{ $service_package->id }}" + "/" + "{{ $package_name }}";
            })

            $("#walletPayment").on("click", function() {
                window.location.href = "{{ url('payment/wallet/') }}" + "/" +
                    "{{ $service_package->id }}" + "/" + "{{ $package_name }}";
            })





        });
    </script>



    @if ($payment_setting->bank_status == 1)
        <script src="https://checkout.flutterwave.com/v3.js"></script>

        @php
            $payable_amount = $payable_amount * $flutterwave_currency->currency_rate;
            $payable_amount = round($payable_amount, 2);
        @endphp

        <script>
            "use strict";
            $(function() {
                $("#payWithFlutterwave").on("click", function() {

                    var isDemo = "{{ env('APP_MODE') }}"
                    if (isDemo == 'DEMO') {
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    FlutterwaveCheckout({
                        public_key: "{{ $payment_setting->flutterwave_public_key }}",
                        tx_ref: "{{ substr(rand(0, time()), 0, 10) }}",
                        amount: {{ $payable_amount }},
                        currency: "{{ $flutterwave_currency->currency_code }}",
                        country: "{{ $flutterwave_currency->country_code }}",
                        payment_options: " ",
                        customer: {
                            email: "{{ $user->email }}",
                            phone_number: "{{ $user->phone }}",
                            name: "{{ $user->name }}",
                        },
                        callback: function(data) {

                            var tnx_id = data.transaction_id;
                            var _token = "{{ csrf_token() }}";
                            $.ajax({
                                type: 'post',
                                data: {
                                    tnx_id,
                                    _token
                                },
                                url: "{{ url('payment/flutterwave/') }}" + "/" +
                                    "{{ $service_package->id }}" + "/" +
                                    "{{ $package_name }}",
                                success: function(response) {

                                    if (response.status == 'success') {
                                        toastr.success(response.message);
                                        window.location.href =
                                            "{{ route('buyer.orders') }}";
                                    } else {
                                        toastr.error(response.message);
                                        window.location.reload();
                                    }
                                },
                                error: function(err) {
                                    toastr.error(
                                        "{{ __('translate.Something went wrong, please try again') }}"
                                        );
                                    window.location.reload();
                                }
                            });
                        },
                        customizations: {
                            title: "{{ $payment_setting->flutterwave_title }}",
                            logo: "{{ custom_asset($payment_setting->flutterwave_logo) }}",
                        },
                    });

                })
            });
        </script>
    @endif


    {{-- start paystack payment --}}

    @if ($payment_setting->paystack_status == 1)
        <script src="https://js.paystack.co/v1/inline.js"></script>

        @php

            $public_key = $payment_setting->paystack_public_key;
            $currency = $paystack_currency->currency_code;
            $currency = strtoupper($currency);

            $ngn_amount = $payable_amount * $paystack_currency->currency_rate;
            $ngn_amount = $ngn_amount * 100;
            $ngn_amount = round($ngn_amount);

        @endphp

        <script>
            "use strict";
            $(function() {
                $("#paystackPayment").on("click", function() {

                    var isDemo = "{{ env('APP_MODE') }}"
                    if (isDemo == 'DEMO') {
                        toastr.error('This Is Demo Version. You Can Not Change Anything');
                        return;
                    }

                    var handler = PaystackPop.setup({
                        key: '{{ $public_key }}',
                        email: '{{ $user->email }}',
                        amount: '{{ $ngn_amount }}',
                        currency: "{{ $currency }}",
                        callback: function(response) {
                            let reference = response.reference;
                            let tnx_id = response.transaction;
                            let _token = "{{ csrf_token() }}";
                            $.ajax({
                                type: "get",
                                data: {
                                    reference,
                                    tnx_id,
                                    _token
                                },
                                url: "{{ url('payment/paystack') }}" + "/" +
                                    "{{ $service_package->id }}" + "/" +
                                    "{{ $package_name }}",
                                success: function(response) {
                                    if (response.status == 'success') {
                                        toastr.success(response.message);
                                        window.location.href =
                                            "{{ route('buyer.orders') }}";
                                    } else {
                                        toastr.error(response.message);
                                        window.location.reload();
                                    }
                                },
                                error: function(response) {
                                    toastr.error('Server Error');
                                    window.location.reload();
                                }
                            });
                        },
                        onClose: function() {
                            alert('window closed');
                        }
                    });
                    handler.openIframe();

                })
            });
        </script>
    @endif

    {{-- end paystack payment --}}


@endpush
