@extends('layout')

@section('title')
    <title>{{ $blog->seo_title }}</title>
    <meta name="title" content="{{ $blog->seo_title }}">
    <meta name="description" content="{{ $blog->seo_description }}">

    @php
        $tags = '';
        if ($blog->tags) {
            foreach (json_decode($blog->tags) as $key => $blog_tag) {
                $tags .= $blog_tag->value . ', ';
            }
        }
    @endphp

    <meta name="keyword" content="{{ $tags }}">
@endsection

@section('front-content')
    <!-- Main Start -->
    <main>

        <!-- Breadcrumb -->
        <section class="w-breadcrumb-area"
            style="background-image: url({{ custom_asset($general_setting->breadcrumb_image) }});">
            <div class="container">
                <div class="row">
                    <div class="col-auto">
                        <div class="position-relative z-2" data-aos="fade-up" data-aos-duration="1000"
                            data-aos-easing="linear">
                            <h2 class="section-title-light mb-2">{{ __('translate.Blog Details') }}</h2>
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb w-breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('translate.Home') }}</a>
                                    </li>
                                    <li class="breadcrumb-item active" aria-current="page">
                                        {{ __('translate.Blog Details') }}
                                    </li>
                                </ol>
                            </nav>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Breadcrumb End -->


        <!-- Blog Content -->
        <section class="py-110 bg-offWhite">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xl-8">
                        <h2 class="fw-bold text-dark-300 blog-details-title">
                            {{ $blog->title }}
                        </h2>
                        <div class="blog-details-meta d-flex flex-wrap gap-3 gap-md-5 my-4 align-items-center">
                            <p class="d-flex gap-3 align-items-center text-dark-200 fst-italic">
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="20" viewBox="0 0 17 20"
                                    fill="none">
                                    <path
                                        d="M0.5184 19.9966C0.108036 19.8303 -0.0123965 19.4927 0.000984899 19.028C0.0366687 17.9127 0.183864 16.8267 0.576386 15.7945C1.20977 14.1264 2.31151 12.9671 3.80131 12.2235C4.87182 11.6903 6.00924 11.4408 7.17343 11.3332C8.26625 11.2305 9.3546 11.25 10.443 11.4066C11.8391 11.6071 13.1683 12.0376 14.337 12.9426C15.6706 13.9748 16.4691 15.4032 16.7902 17.1398C16.9062 17.761 16.924 18.4018 16.9909 19.0378C17.04 19.4976 16.8928 19.84 16.478 20.0064C11.1566 19.9966 5.83975 19.9966 0.5184 19.9966ZM15.6037 18.529C15.6126 18.5095 15.626 18.4948 15.6216 18.485C15.6082 18.3285 15.5993 18.1719 15.5814 18.0203C15.4655 17.0811 15.2067 16.1956 14.7161 15.4081C14.0292 14.3074 13.0568 13.647 11.9238 13.2459C10.8221 12.8546 9.68914 12.7371 8.53833 12.7323C7.32955 12.7274 6.13414 12.8546 4.97888 13.2801C4.17599 13.5736 3.44893 14.0139 2.84231 14.6694C2.10187 15.4717 1.67812 16.4598 1.48186 17.5702C1.42834 17.8833 1.39265 18.2062 1.34805 18.5339C6.12968 18.529 10.8712 18.529 15.6037 18.529Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M12.9128 5.09648C12.8593 6.70099 12.2795 8.14407 11.035 9.23494C9.71022 10.3943 7.70747 10.5215 6.30242 9.48442C4.57176 8.20277 3.89822 6.37813 4.14801 4.13769C4.29967 2.79734 4.88845 1.70647 5.8876 0.909102C6.85106 0.14109 7.93941 -0.118175 9.10806 0.048146C10.3704 0.229142 11.3874 0.894427 12.1144 2.04889C12.672 2.92452 12.9039 3.91756 12.9128 5.09648ZM5.41479 4.83232C5.42817 5.9232 5.70026 6.80861 6.28012 7.57662C7.36847 9.01481 9.3177 9.12732 10.5176 7.79675C11.3874 6.83307 11.713 5.65415 11.5256 4.32847C11.1688 1.79452 8.76014 0.811266 6.96257 1.88746C5.88314 2.53318 5.45047 3.61916 5.41479 4.83232Z"
                                        fill="#22BE0D" />
                                </svg>
                                {{ $blog?->author?->name }}
                            </p>
                            <p class="d-flex gap-3 align-items-center text-dark-200 fst-italic">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"
                                    fill="none">
                                    <path
                                        d="M19.9882 3.62212C19.9882 5.86393 19.9882 8.10573 19.9882 10.3475C19.9344 10.2986 19.8855 10.2496 19.8318 10.2056C19.4259 9.84337 19.025 9.47137 18.6094 9.11894C18.4823 9.01126 18.4187 8.92315 18.4236 8.75184C18.4383 8.28683 18.4285 7.81694 18.4285 7.34704C12.7958 7.34704 7.18755 7.34704 1.56464 7.34704C1.56464 7.43025 1.56464 7.50367 1.56464 7.5722C1.56464 10.8811 1.56464 14.1899 1.56464 17.4988C1.56464 18.1351 1.85801 18.4337 2.49364 18.4337C4.513 18.4337 6.52747 18.4435 8.54683 18.4239C8.87931 18.419 9.10912 18.4875 9.24602 18.7959C9.27536 18.8595 9.32914 18.9134 9.37804 18.9672C9.70074 19.3098 10.0283 19.6574 10.351 20C7.59338 20 4.8357 20 2.07314 20C1.99002 19.9804 1.91179 19.9608 1.82867 19.9413C0.728534 19.6769 0.00488949 18.7567 0 17.6114C0 15.4919 0 13.3676 0 11.2433C0 8.80568 0 6.37298 0 3.93539C0 2.79001 0.723644 1.85022 1.82867 1.62017C2.22472 1.53696 2.64032 1.57122 3.05104 1.55164C3.12438 1.54674 3.19773 1.55164 3.29063 1.55164C3.29063 1.01322 3.29063 0.509055 3.29063 0C3.8138 0 4.32231 0 4.84548 0C4.84548 0.518845 4.84548 1.02301 4.84548 1.53696C8.28279 1.53696 11.7054 1.53696 15.1525 1.53696C15.1525 1.01811 15.1525 0.504161 15.1525 0C15.6855 0 16.194 0 16.7172 0C16.7172 0.518845 16.7172 1.0279 16.7172 1.55164C17.0545 1.55164 17.3772 1.54185 17.7048 1.55164C18.4578 1.58101 19.0641 1.89917 19.5286 2.49633C19.7829 2.82917 19.9002 3.22075 19.9882 3.62212ZM15.1525 3.12775C11.7005 3.12775 8.2779 3.12775 4.8357 3.12775C4.8357 3.6466 4.8357 4.15076 4.8357 4.66471C4.31253 4.66471 3.80402 4.66471 3.27107 4.66471C3.27107 4.14097 3.27107 3.63191 3.27107 3.11307C2.95814 3.11307 2.66477 3.10817 2.3714 3.11307C1.88734 3.12286 1.56464 3.44102 1.55975 3.9256C1.55486 4.40039 1.55975 4.87518 1.55975 5.34998C1.55975 5.48213 1.55975 5.61919 1.55975 5.75135C7.19244 5.75135 12.8056 5.75135 18.4236 5.75135C18.4236 5.10524 18.4334 4.47381 18.4187 3.84239C18.4089 3.47528 18.1351 3.15712 17.7684 3.12286C17.4212 3.09349 17.0692 3.11796 16.7025 3.11796C16.7025 3.6417 16.7025 4.15076 16.7025 4.65981C16.1744 4.65981 15.6708 4.65981 15.1525 4.65981C15.1525 4.15076 15.1525 3.6466 15.1525 3.12775Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M14.3357 19.9972C13.8272 19.8749 13.2943 19.8112 12.8102 19.6203C11.2065 18.984 10.1161 17.824 9.67116 16.1549C9.09909 14.0354 9.65649 12.1901 11.2994 10.7315C12.4924 9.6693 13.9201 9.26303 15.4994 9.51266C17.3965 9.81124 18.7509 10.8685 19.5381 12.6062C19.7533 13.0761 19.8217 13.6145 19.9586 14.1186C19.9782 14.1872 19.9831 14.2557 19.9978 14.3242C19.9978 14.5836 19.9978 14.8431 19.9978 15.1074C19.9293 15.45 19.8951 15.8024 19.7924 16.1353C19.3035 17.7897 18.262 18.9693 16.6582 19.6106C16.1693 19.8063 15.6314 19.87 15.118 19.9972C14.854 19.9972 14.5949 19.9972 14.3357 19.9972ZM14.722 18.4358C16.7609 18.4358 18.4331 16.7618 18.4331 14.7207C18.4282 12.6845 16.7707 11.0203 14.7367 11.0105C12.6978 11.0007 11.0207 12.6698 11.0158 14.7158C11.0109 16.7569 12.6831 18.4309 14.722 18.4358Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M2.97656 10.5301C2.97656 10.0113 2.97656 9.50713 2.97656 8.98828C3.49026 8.98828 3.99418 8.98828 4.51277 8.98828C4.51277 9.49244 4.51277 10.0064 4.51277 10.5301C4.00885 10.5301 3.50005 10.5301 2.97656 10.5301Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M7.64364 8.98828C7.64364 9.50713 7.64364 10.0113 7.64364 10.5252C7.12505 10.5252 6.61625 10.5252 6.09766 10.5252C6.09766 10.0113 6.09766 9.50713 6.09766 8.98828C6.60646 8.98828 7.11527 8.98828 7.64364 8.98828Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M10.7706 8.98828C10.7706 9.50713 10.7706 10.0113 10.7706 10.5252C10.2569 10.5252 9.75297 10.5252 9.23438 10.5252C9.23438 10.0211 9.23438 9.51202 9.23438 8.98828C9.73829 8.98828 10.2471 8.98828 10.7706 8.98828Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M2.97656 13.6502C2.97656 13.1363 2.97656 12.6272 2.97656 12.1133C3.49515 12.1133 4.00396 12.1133 4.52255 12.1133C4.52255 12.6272 4.52255 13.1314 4.52255 13.6502C4.01374 13.6502 3.50494 13.6502 2.97656 13.6502Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M6.09766 13.6551C6.09766 13.1363 6.09766 12.6321 6.09766 12.1133C6.61135 12.1133 7.11527 12.1133 7.63386 12.1133C7.63386 12.6174 7.63386 13.1314 7.63386 13.6551C7.12995 13.6551 6.62114 13.6551 6.09766 13.6551Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M2.97656 15.2383C3.49515 15.2383 3.99907 15.2383 4.51277 15.2383C4.51277 15.7522 4.51277 16.2564 4.51277 16.7752C4.00885 16.7752 3.50005 16.7752 2.97656 16.7752C2.97656 16.2711 2.97656 15.762 2.97656 15.2383Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M7.64364 15.25C7.64364 15.764 7.64364 16.2681 7.64364 16.787C7.12505 16.787 6.61625 16.787 6.09766 16.787C6.09766 16.2779 6.09766 15.7688 6.09766 15.25C6.60157 15.25 7.11038 15.25 7.64364 15.25Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M13.9219 12.1133C14.4402 12.1133 14.9438 12.1133 15.467 12.1133C15.467 12.7202 15.467 13.3174 15.467 13.9341C15.9119 13.9341 16.3422 13.9341 16.7871 13.9341C16.7871 14.4628 16.7871 14.9669 16.7871 15.4858C15.8434 15.4858 14.89 15.4858 13.9219 15.4858C13.9219 14.3698 13.9219 13.2489 13.9219 12.1133Z"
                                        fill="#22BE0D" />
                                </svg>
                                {{ $blog->created_at->format('d M Y') }}
                            </p>
                            <p class="d-flex gap-3 align-items-center text-dark-200 fst-italic">
                                <svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17"
                                    fill="none">
                                    <path
                                        d="M8.50485 16.9537C7.11942 16.9442 5.80965 16.6281 4.58026 15.9865C4.44313 15.9157 4.32965 15.9063 4.18307 15.9488C3.05771 16.2743 1.93234 16.5951 0.802251 16.9159C0.423977 17.0244 0.0977163 16.8688 0.02679 16.5243C0.00314794 16.4017 0.02679 16.2554 0.059889 16.128C0.376693 15.0005 0.698226 13.8776 1.02449 12.7547C1.05759 12.6321 1.04813 12.5377 0.986659 12.4245C-1.61397 7.54614 1.16161 1.47418 6.55674 0.223927C11.2662 -0.865913 15.9001 2.12997 16.8411 6.87148C17.73 11.3394 14.7984 15.7931 10.3442 16.7414C9.74369 16.8688 9.12427 16.9159 8.50958 17.0009C8.50958 16.9867 8.50485 16.9678 8.50485 16.9537ZM1.40276 15.5572C1.48314 15.5383 1.53043 15.5289 1.57298 15.5194C2.4241 15.2788 3.27521 15.0476 4.1216 14.7929C4.41476 14.7032 4.66064 14.741 4.92543 14.8872C6.51891 15.7742 8.21641 16.0431 9.99903 15.6751C14.0135 14.8448 16.5573 10.9289 15.692 6.92809C14.7795 2.71027 10.4009 0.181466 6.28722 1.48833C3.28467 2.44607 1.25618 5.12585 1.15688 8.31044C1.11433 9.65505 1.44059 10.9242 2.1073 12.0942C2.24442 12.3348 2.27279 12.5566 2.19241 12.8161C2.08365 13.1558 1.98908 13.5049 1.88979 13.8493C1.72902 14.406 1.57298 14.9627 1.40276 15.5572Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M8.47806 6.21871C7.36216 6.21871 6.24625 6.21871 5.13507 6.21871C4.70478 6.21871 4.42108 5.83184 4.57239 5.45441C4.66223 5.23267 4.83245 5.11 5.0736 5.09585C5.14926 5.09113 5.22491 5.09585 5.30529 5.09585C7.46618 5.09585 9.62234 5.09585 11.7832 5.09585C11.8589 5.09585 11.9393 5.09113 12.0102 5.11C12.2939 5.16662 12.4878 5.43554 12.4594 5.71861C12.431 6.00169 12.1946 6.22343 11.8967 6.22343C11.126 6.22815 10.3505 6.22343 9.57978 6.22343C9.21097 6.21871 8.84688 6.21871 8.47806 6.21871Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M8.49268 9.04374C7.37204 9.04374 6.25141 9.04374 5.13077 9.04374C4.70049 9.04374 4.42151 8.65216 4.57282 8.27C4.65793 8.05298 4.86125 7.91616 5.11186 7.91616C5.44285 7.91144 5.77384 7.91616 6.10483 7.91616C8.01511 7.91616 9.92539 7.91616 11.8357 7.91616C12.2849 7.91616 12.5686 8.29359 12.422 8.68046C12.3369 8.91164 12.1288 9.04374 11.8499 9.04374C10.734 9.04374 9.61332 9.04374 8.49268 9.04374Z"
                                        fill="#22BE0D" />
                                    <path
                                        d="M8.5004 10.7383C9.62104 10.7383 10.7417 10.7383 11.8623 10.7383C12.302 10.7383 12.5858 11.1393 12.4203 11.5215C12.3162 11.7621 12.1176 11.8706 11.8576 11.8706C10.8788 11.8706 9.90001 11.8706 8.92123 11.8706C7.66347 11.8706 6.41044 11.8706 5.15268 11.8706C4.70821 11.8706 4.42923 11.479 4.58054 11.0968C4.67038 10.8704 4.8737 10.743 5.15741 10.743C6.27331 10.7383 7.38449 10.7383 8.5004 10.7383Z"
                                        fill="#22BE0D" />
                                </svg>
                                {{ $blog->total_comment }} {{ __('translate.Comment') }}
                            </p>
                        </div>

                        <div class="blog_details legal-content">
                            <div class="content-details">
                                {!! clean($blog->description) !!}
                            </div>
                        </div>

                        <!-- Tags -->
                        <div class="blog-tags-wrapper mt-5">
                            <div class="row g-3 justify-content-between">
                                <div class="col-auto">
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex flex-column flex-md-row align-items-lg-center gap-3 gap-lg-4">
                                            <h4 class="text-dark-300 fw-semibold text-18">{{ __('translate.Tag') }}:</h4>
                                            <div class="d-flex flex-wrap align-items-center gap-3 gap-md-4">
                                                @if ($blog->tags)
                                                    @foreach (json_decode($blog->tags) as $blog_tag)
                                                        <a href="javascript:;" class="blog-tag">#{{ $blog_tag->value }}</a>
                                                    @endforeach
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <div class="d-flex align-items-center gap-4">
                                        <h4 class="text-dark-300 fw-semibold text-18">{{ __('translate.Share') }}:</h4>
                                        <div class="d-flex align-items-center gap-3 social-links">
                                            <a href="https://www.facebook.com/sharer/sharer.php?u={{ route('blog', $blog->slug) }}&t={{ $blog->title }}"
                                                target="_blank" rel="noopener noreferrer">
                                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M22 11C22 4.92486 17.0751 0 11 0C4.92486 0 0 4.92486 0 11C0 16.4903 4.02252 21.0412 9.28125 21.8664V14.1797H6.48828V11H9.28125V8.57656C9.28125 5.81969 10.9235 4.29688 13.4361 4.29688C14.6392 4.29688 15.8984 4.51172 15.8984 4.51172V7.21875H14.5114C13.145 7.21875 12.7188 8.06674 12.7188 8.9375V11H15.7695L15.2818 14.1797H12.7188V21.8664C17.9775 21.0412 22 16.4903 22 11Z"
                                                        fill="currentColor" />
                                                </svg>
                                            </a>
                                            <a href="https://twitter.com/share?text={{ $blog->title }}&url={{ route('blog', $blog->slug) }}"
                                                target="_blank" rel="noopener noreferrer"><svg width="22" height="22"
                                                    viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M11 0C4.92508 0 0 4.92508 0 11C0 17.0749 4.92508 22 11 22C17.0749 22 22 17.0749 22 11C22 4.92508 17.0749 0 11 0Z"
                                                        fill="currentColor" />
                                                    <path
                                                        d="M12.2038 10.0049L16.9128 4.53107H15.7969L11.7081 9.28389L8.44239 4.53107H4.67578L9.61416 11.7182L4.67578 17.4583H5.79172L10.1096 12.4391L13.5584 17.4583H17.325L12.2035 10.0049H12.2038ZM6.1938 5.37114H7.90781L15.7974 16.6564H14.0834L6.1938 5.37114Z"
                                                        fill="white" />
                                                </svg>
                                            </a>
                                            <a href="https://www.instagram.com/?url={{ route('blog', $blog->slug) }}"
                                                target="_blank" rel="noopener noreferrer">
                                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M10.9975 13.31C12.2733 13.31 13.3075 12.2758 13.3075 11C13.3075 9.72426 12.2733 8.69003 10.9975 8.69003C9.72172 8.69003 8.6875 9.72426 8.6875 11C8.6875 12.2758 9.72172 13.31 10.9975 13.31Z"
                                                        fill="currentColor" />
                                                    <path
                                                        d="M11 0C4.92488 0 0 4.92488 0 11C0 17.0751 4.92488 22 11 22C17.0751 22 22 17.0751 22 11C22 4.92488 17.0751 0 11 0ZM17.7962 13.7958C17.7434 14.8416 17.4495 15.8728 16.6874 16.6269C15.9178 17.3881 14.8817 17.6717 13.8258 17.7239H8.17423C7.11823 17.6717 6.08221 17.3882 5.31269 16.6269C4.55052 15.8728 4.25669 14.8416 4.20389 13.7958V8.20424C4.25669 7.15845 4.55057 6.12718 5.31269 5.3731C6.08221 4.6119 7.11836 4.32828 8.17423 4.27605H13.8258C14.8818 4.32828 15.9178 4.61177 16.6873 5.3731C17.4495 6.12718 17.7433 7.15845 17.7961 8.20424L17.7962 13.7958Z"
                                                        fill="currentColor" />
                                                    <path
                                                        d="M13.7557 5.55001C12.3791 5.51226 9.62387 5.51226 8.24728 5.55001C7.53092 5.56968 6.71881 5.74801 6.20841 6.29317C5.67803 6.85985 5.47761 7.54449 5.45729 8.3104C5.42156 9.65468 5.45729 13.6895 5.45729 13.6895C5.48056 14.4553 5.67803 15.14 6.20841 15.7067C6.71881 16.252 7.53092 16.4302 8.24728 16.4499C9.62387 16.4876 12.3791 16.4876 13.7557 16.4499C14.4721 16.4302 15.2842 16.2519 15.7946 15.7067C16.325 15.14 16.5254 14.4554 16.5457 13.6895V8.3104C16.5254 7.54449 16.325 6.85985 15.7946 6.29317C15.284 5.74784 14.4719 5.56968 13.7557 5.55001ZM11.0013 14.5804C10.2932 14.5804 9.60092 14.3704 9.01211 13.977C8.4233 13.5836 7.96438 13.0244 7.69338 12.3701C7.42238 11.7159 7.35147 10.996 7.48963 10.3014C7.62778 9.60687 7.96879 8.96889 8.46953 8.46814C8.97028 7.9674 9.60826 7.62639 10.3028 7.48824C10.9974 7.35008 11.7173 7.42099 12.3715 7.69199C13.0258 7.96299 13.585 8.42191 13.9784 9.01072C14.3718 9.59953 14.5818 10.2918 14.5818 10.9999C14.5818 11.9495 14.2046 12.8603 13.5331 13.5317C12.8616 14.2032 11.9509 14.5804 11.0013 14.5804ZM14.5971 8.15851C14.4554 8.15847 14.317 8.11645 14.1993 8.03774C14.0815 7.95903 13.9898 7.84718 13.9356 7.71633C13.8814 7.58547 13.8673 7.44149 13.8949 7.3026C13.9226 7.1637 13.9908 7.03612 14.0909 6.93599C14.1911 6.83586 14.3187 6.76767 14.4576 6.74005C14.5965 6.71244 14.7405 6.72663 14.8713 6.78083C15.0021 6.83504 15.114 6.92682 15.1927 7.04458C15.2713 7.16234 15.3133 7.30078 15.3133 7.44241C15.3133 7.53646 15.2948 7.6296 15.2588 7.71649C15.2228 7.80338 15.17 7.88233 15.1035 7.94883C15.037 8.01533 14.958 8.06807 14.8711 8.10405C14.7842 8.14003 14.6911 8.15853 14.5971 8.15851Z"
                                                        fill="currentColor" />
                                                </svg>
                                            </a>
                                            <a href="https://www.linkedin.com/shareArticle?mini=true&url={{ route('blog', $blog->slug) }}&title={{ $blog->title }}"
                                                target="_blank" rel="noopener noreferrer">
                                                <svg width="22" height="22" viewBox="0 0 22 22" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M11 0C4.9258 0 0 4.9258 0 11C0 17.0742 4.9258 22 11 22C17.0742 22 22 17.0742 22 11C22 4.9258 17.0742 0 11 0ZM7.80353 16.6289H5.12453V8.56908H7.80353V16.6289ZM6.46411 7.46851H6.44666C5.54767 7.46851 4.96625 6.84966 4.96625 6.07622C4.96625 5.28532 5.56546 4.68359 6.4819 4.68359C7.39835 4.68359 7.96231 5.28532 7.97977 6.07622C7.97977 6.84966 7.39835 7.46851 6.46411 7.46851ZM17.4634 16.6289H14.7848V12.3171C14.7848 11.2335 14.3969 10.4944 13.4276 10.4944C12.6875 10.4944 12.2468 10.993 12.0531 11.4742C11.9822 11.6464 11.965 11.8871 11.965 12.1279V16.6289H9.28612C9.28612 16.6289 9.3212 9.32523 9.28612 8.56908H11.965V9.71027C12.321 9.16107 12.9579 8.37991 14.3793 8.37991C16.1418 8.37991 17.4634 9.53185 17.4634 12.0074V16.6289Z"
                                                        fill="currentColor" />
                                                </svg>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Comments -->
                        <div class="pt-5">
                            <h3 class="fw-bold text-dark-300 text-18 mb-4">{{ $blog->total_comment }}
                                {{ __('translate.Comments') }}</h3>
                            <div class="d-flex flex-column gap-4">
                                <!-- Single Comments -->
                                @foreach ($blog_comments as $blog_comment)
                                    <div class="bg-white blog-single-comment">
                                        <!-- Comment -->
                                        <div class="d-flex flex-column flex-md-row gap-3 pb-3">
                                            <div>
                                                <img src="{{ custom_asset($general_setting->default_avatar) }}"
                                                    class="rounded-circle w-64" alt="" />
                                            </div>
                                            <div>
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <h4 class="text-18 fw-semibold text-dark-300">
                                                        {{ html_decode($blog_comment->name) }}
                                                    </h4>
                                                    <p class="fs-6 text-dark-200">
                                                        {{ $blog_comment->created_at->format('d M Y') }}</p>
                                                </div>
                                                <p class="py-2 text-dark-200 fs-6">
                                                    {{ html_decode($blog_comment->comment) }}
                                                </p>

                                            </div>
                                        </div>

                                    </div>
                                @endforeach
                                <!-- Single Comments -->

                            </div>
                        </div>
                        <!-- Comment Form -->
                        <div class="bg-white comment-form mt-4">
                            <h3 class="fw-bold text-dark-300 text-18 mb-4">
                                {{ __('translate.Write a Comment') }}
                            </h3>
                            <div>
                                <form method="POST" action="{{ route('store-blog-comment', $blog->id) }}">
                                    @csrf
                                    <div class="row g-4">
                                        <div class="col-md-6">
                                            <div class="comment-form-input">
                                                <label for="name"
                                                    class="fw-normal fs-6 text-dark-300 d-block mb-1">{{ __('translate.Name') }}</label>
                                                <input type="text" class="form-control shadow-none" id="name"
                                                    placeholder="{{ __('translate.Name') }}" name="name"
                                                    value="{{ old('name') }}" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="comment-form-input">
                                                <label for="email"
                                                    class="fw-normal fs-6 text-dark-300 d-block mb-1">{{ __('translate.Email') }}</label>
                                                <input type="email" class="form-control shadow-none" id="email"
                                                    name="email" value="{{ old('email') }}"
                                                    placeholder="{{ __('translate.Email') }}" />
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <div class="comment-form-input">
                                                <label for="desc"
                                                    class="fw-normal fs-6 text-dark-300 d-block mb-1">{{ __('translate.Comment') }}</label>
                                                <textarea type="text" class="form-control form-textarea shadow-none" id="desc"
                                                    placeholder="{{ __('translate.Comment') }}" name="comment">{{ old('comment') }}</textarea>
                                            </div>
                                        </div>

                                        @if ($general_setting->recaptcha_status == 1)
                                            <div class="contact-form-input col-lg-12 mt-4">
                                                <div class="g-recaptcha"
                                                    data-sitekey="{{ $general_setting->recaptcha_site_key }}"></div>
                                            </div>
                                        @endif

                                        <div class="col-auto">
                                            <button class="comment-form-btn">{{ __('translate.Submit Now') }}</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Blog Content End -->
    </main>
    <!-- Main End -->


@endsection

@push('js_section')
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endpush
