@extends('admin.master_layout')
@section('title')
    <title>{{ __('Restricted City') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('Restricted City') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Service') }} >> {{ __('Restricted City') }}</p>
@endsection

@section('body-content')
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="{{ route('admin.restricted.update', $restricted->id) }}" method="POST"
                                enctype="multipart/form-data">
                                @method('PUT')
                                @csrf

                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title">{{ __('Restricted Key') }}
                                                </h4>

                                                <a href="{{ route('admin.restricted.index') }}" class="crancy-btn "><i
                                                        class="fa fa-list"></i> {{ __('Key List') }}</a>
                                            </div>

                                            <div class="row mg-top-30">
                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('Restricted Key') }} *
                                                        </label>
                                                        <input class="crancy__item-input"
                                                            value="{{ $restricted->keyword_name }}" type="text"
                                                            name="keyword_name" id="keyword_name">
                                                    </div>
                                                </div>

                                            </div>

                                            <button class="crancy-btn mg-top-25"
                                                type="submit">{{ __('translate.Update') }}</button>

                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
@endsection



@push('js_section')
    <script>
        "use strict";

        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function() {
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };
    </script>
@endpush
