@extends('buyer.layout')
@section('title')
    <title>{{ __('translate.Buyer || Job Applications') }}</title>
@endsection
@section('front-content')
<main class="dashboard-main min-vh-100">
    <div class="d-flex flex-column gap-4">
      <!-- Header -->
      <div class="d-flex align-items-center justify-content-between">
        <div>
          <h3 class="text-24 fw-bold text-dark-300 mb-2">{{ __('translate.Job Applications') }}</h3>
          <ul class="d-flex align-items-center gap-2">
            <li class="text-dark-200 fs-6">{{ __('translate.Dashboard') }}</li>
            <li>
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="5"
                height="11"
                viewBox="0 0 5 11"
                fill="none"
              >
                <path
                  d="M1 10L4 5.5L1 1"
                  stroke="#5B5B5B"
                  stroke-width="1.2"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                />
              </svg>
            </li>
            <li class="text-lime-300 fs-6">{{ __('translate.Job Applications') }}</li>
          </ul>
        </div>
      </div>
      <!-- Content -->
      <div>
        <!-- My Job -->
        <div class="overflow-x-auto">
          <div class="w-100">
            <table class="w-100 dashboard-table applicant-table">
              <thead class="pb-3">
                <tr>
                  <th scope="col">{{ __('translate.SN') }}</th>
                  <th scope="col">{{ __('translate.Name') }}</th>
                  <th scope="col">{{ __('translate.Job Type') }}</th>
                  <th scope="col">{{ __('translate.Type') }}</th>
                  <th scope="col">{{ __('translate.Offer Amount') }}</th>
                  <th scope="col">{{ __('translate.Delivery Days') }}</th>
                  <th scope="col">{{ __('translate.Status') }}</th>
                  <th scope="col" class="text-end">{{ __('translate.Actions') }}</th>
                </tr>
              </thead>
              <tbody>
                @foreach ($job_requests as $index => $job_request)
                    <tr>
                    <td class="text-dark-200">{{ ++$index }}</td>
                    <td>
                        <div
                        class="d-flex gap-3 align-items-center project-name"
                        >
                        <div class="rounded-3">
                            @if ($job_request?->seller->image)
                            <img
                            src="{{ custom_asset($job_request?->seller->image) }}"
                            class="img-fluid rounded-3"
                            alt=""
                            />
                            @else
                            <img
                            src="{{ custom_asset($general_setting->default_avatar) }}"
                            class="img-fluid rounded-3"
                            alt=""
                            />
                            @endif

                        </div>
                        <div>
                            <p class="text-dark-200">{{ html_decode($job_request?->seller?->name) }}</p>
                        </div>

                        </div>
                    </td>
                    <td>
                        {{$job_request->job_post->job_type}}
                    </td>
                    <td>
                        @if($job_request->milestons != '[]')
                            {{ __('translate.Milestone') }} ( {{$job_request->milestons->count()}})
                        @else
                            {{ __('translate.By Project') }}
                        @endif
                    </td>
                    <td>
                        @if($job_request->milestons != '[]')
                            {{ currency($job_request->milestons->sum('amount')) }}
                        @else
                            {{ currency($job_request->project_price) }}
                        @endif
                    </td>
                    <td>
                        {{ html_decode($job_request->delivery_time) }}
                    </td>
                    <td>
                    @if($job_request->approved_status == 'cancel_pending')
                        <li>
                            <span class="status-badge fr-cancel">
                                @if($job_request->cancel_reason_seller)
                                {{ __('translate.Cancel By Seller') }}
                                @else
                                {{ __('translate.Cancel By Buyer') }}
                                @endif
                            </span>
                        </li>
                    @elseif($job_request->approved_status == 'cancel')
                        <li>
                            <span class="status-badge fr-cancel">
                                @if($job_request->cancel_reason_seller)
                                {{ __('translate.Cancel By Seller') }}
                                @else
                                {{ __('translate.Cancel By Buyer') }}
                                @endif
                            </span>
                        </li>
                    @else
                        <li>
                            @if ($job_request->status == 'approved')
                                <span class="status-badge in-progress fr-hire">{{ __('translate.Hired') }}</span>
                            @elseif ($job_request->status == 'pending')
                                <span class="status-badge pending">{{ __('translate.Pending') }}</span>
                            @else
                                <span class="status-badge fr-cancel">{{ __('translate.Rejected') }}</span>
                            @endif
                        </li>
                    @endif

                    </td>
                    <td>
                        <div class="d-flex justify-content-end gap-2">

                            <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#applicationDetail{{ $job_request->id }}" class="dashboard-action-btn fr-edit-btn">
                                <svg width="26" height="19" viewBox="0 0 26 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M23.3187 6.66195C24.6716 8.08537 24.6716 10.248 23.3187 11.6714C21.0369 14.0721 17.1181 17.3333 12.6667 17.3333C8.21523 17.3333 4.29641 14.0721 2.01466 11.6714C0.661781 10.248 0.661781 8.08537 2.01466 6.66195C4.29641 4.26122 8.21523 1 12.6667 1C17.1181 1 21.0369 4.26122 23.3187 6.66195Z" stroke="#5B5B5B" stroke-width="1.5"></path>
                                    <circle cx="12.668" cy="9.16699" r="3.5" stroke="#5B5B5B" stroke-width="1.5"></circle>
                                </svg>
                            </a>

                            @if ($job_request->status == 'pending')
                                <a data-bs-toggle="modal" data-bs-target="#applicationApproval{{ $job_request->id }}" href="javascript:;" class="w-btn-secondary-lg">
                                    {{ __('translate.Hire Now') }}
                                </a>
                            @endif

                            @if($job_request->status == 'approved')
                                @if($job_request->job_post->job_type == 'Hourly')
                                    <a href="{{route('buyer.time-traking', $job_request->id)}}" class="dashboard-action-btn fr-edit-btn">
                                        <svg width="22" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M12 22C6.48 22 2 17.52 2 12C2 6.48 6.48 2 12 2C17.52 2 22 6.48 22 12C22 17.52 17.52 22 12 22ZM12 4C7.58 4 4 7.58 4 12C4 16.42 7.58 20 12 20C16.42 20 20 16.42 20 12C20 7.58 16.42 4 12 4ZM13 13H17V11H13V7H11V13H13Z" fill="#5B5B5B"/>
                                        </svg>
                                    </a>
                                @endif
                            @endif
                            <a href="{{route('buyer.chat-job-post-applicants',$job_request->id)}}" class="dashboard-action-btn">
                                <span>
                                    <svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7 12H15M7 8H11M20.9664 9.21661C20.9886 9.47478 21 9.73606 21 10C21 14.9706 16.9706 19 12 19H5C2.79086 19 1 17.2091 1 15V10C1 5.02944 5.02944 1 10 1H12C12.2639 1 12.5252 1.01136 12.7834 1.03362M21 4C21 5.65685 19.6569 7 18 7C16.3431 7 15 5.65685 15 4C15 2.34315 16.3431 1 18 1C19.6569 1 21 2.34315 21 4Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"/>
                                    </svg>
                                </span>
                                <span>Chat</span>
                            </a>

                        </div>
                    </td>
                    {{--  <td class="text-end">
                        <div>
                        <div class="dropdown dropstart">
                            <button
                            class="dashboard-action-btn dropdown-toggle"
                            type="button"
                            data-bs-toggle="dropdown"
                            aria-expanded="false"
                            >
                            <svg
                                width="4"
                                height="20"
                                viewBox="0 0 4 20"
                                fill="none"
                                xmlns="http://www.w3.org/2000/svg"
                            >
                                <circle
                                cx="1.97917"
                                cy="1.97917"
                                r="1.97917"
                                fill="#5B5B5B"
                                />
                                <circle
                                cx="1.97917"
                                cy="9.89616"
                                r="1.97917"
                                fill="#5B5B5B"
                                />
                                <circle
                                cx="1.97917"
                                cy="17.8122"
                                r="1.97917"
                                fill="#5B5B5B"
                                />
                            </svg>
                            </button>
                            <ul class="dropdown-menu table-dropdown">

                            <li>
                                <a class="dropdown-item" href="javascript:;" data-bs-toggle="modal" data-bs-target="#applicationDetail{{ $job_request->id }}">{{ __('translate.See more') }}</a>
                            </li>

                            @if ($job_request->status == 'pending')
                            <li>
                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#applicationApproval{{ $job_request->id }}" href="javascript:;">{{ __('translate.Approve') }}</a>
                            </li>
                            @endif
                            </ul>
                        </div>
                        </div>
                    </td>  --}}
                    </tr>
                @endforeach
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </main>


    @foreach ($job_requests as $index => $job_request)
        <!-- Application detail Modal -->
        <div class="modal fade" id="applicationDetail{{ $job_request->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content ">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Application Details') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <table class="table table-bordered table-striped">
                            <tbody>
                                <tr>
                                    <td>{{ __('translate.Name') }}</td>
                                    <td>{{ html_decode($job_request?->seller?->name) }}</td>
                                </tr>
                                @if($job_request->milestons != '[]')
                                    <tr>
                                        <td> {{ __('translate.Number Of Milestone') }}</td>
                                        <td>{{$job_request->milestons->count()}}</td>
                                    </tr>
                                    <tr>
                                        <td> {{ __('translate.Offer Amount') }}</td>
                                        <td>{{ currency($job_request->milestons->sum('amount')) }}</td>
                                    </tr>
                                @else
                                    <tr>
                                        <td> {{ __('translate.Offer Amount') }}</td>
                                        <td>{{ currency($job_request->project_price) }}</td>
                                    </tr>
                                @endif
                                <tr>
                                    <td> {{ __('translate.Delivery Days') }}</td>
                                    <td>{{ html_decode($job_request->delivery_time) }}</td>
                                </tr>

                                <tr>
                                    <td>{{ __('translate.Apply Date') }}</td>
                                    <td>{{ $job_request->created_at->format('d M Y') }}</td>
                                </tr>
                                <tr>
                                    <td> {{ __('translate.Message') }}</td>
                                    <td>{!! clean(nl2br(html_decode($job_request->description))) !!}</td>
                                </tr>

                            </tbody>
                        </table>
                        @if($job_request->milestons != '[]')
                            <h5 class="modal-title pb-3" id="exampleModalLabel">{{ __('translate.Milestone Details') }}</h5>
                            <table class="table table-bordered table-striped ">
                                <tbody>
                                    <tr>
                                        <th>{{ __('translate.Description') }}</th>
                                        <th> {{ __('translate.Date') }}</th>
                                        <th> {{ __('translate.Amount') }}</th>
                                    </tr>
                                        @foreach ($job_request->milestons as $milestone)
                                            <tr>
                                                <td>{{ html_decode($milestone->description) }}</td>
                                                <td>{{ $milestone->created_at->format('d M Y') }}</td>
                                                <td>{{ currency($milestone->amount) }}</td>
                                            </tr>
                                        @endforeach
                                </tbody>
                            </table>
                        @endif
                    </div>

                </div>
            </div>
        </div>

        <!-- Job Approval Confirmation Modal -->
        <div class="modal fade" id="applicationApproval{{ $job_request->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Approval Confirmation') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ __('translate.Are you realy want to approve this item?') }}</p>
                    </div>
                    <div class="modal-footer">
                        <form action="{{ route('buyer.job-application-approval', $job_request->id) }}" method="POST" class="delet_modal_form">
                            @csrf
                            @method('PUT')

                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('translate.Close') }}</button>
                            <button type="submit" class="btn btn-primary">{{ __('translate.Yes, Approved') }}</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>

    @endforeach

@endsection
