<?php

namespace Modules\Listing\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ListingBasicRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        if ($this->isMethod('post')) {
            $rules = [
                'category_id'=>'required|exists:categories,id',
                'sub_category_id'=>'nullable',
                'title'=>'required',
                'slug'=>'required|unique:listings',
                'description'=>'required',
            ];
        }

        if ($this->isMethod('put')) {
            $rules = [
                'category_id'=>'required|exists:categories,id',
                'sub_category_id'=>'nullable',
                'title'=>'required',
                'description'=>'required',
                'translate_id'=>'required|exists:listing_translations,id',
            ];
        }

        return $rules;
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function messages(): array
    {
        return [
            'category_id.required' => trans('translate.Category is required'),
            'title.required' => trans('translate.Title is required'),
            'slug.required' => trans('translate.Slug is required'),
            'slug.unique' => trans('translate.Slug already exist'),
            'description.required' => trans('translate.Description is required'),

        ];
    }
}
