@extends('buyer.layout')
@section('title')
    <title>{{ __('translate.Buyer || Job Applications') }}</title>
@endsection
@section('front-content')
    <main class="dashboard-main min-vh-100">
        <div class="d-flex flex-column gap-4">
            <!-- Header -->
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h3 class="text-24 fw-bold text-dark-300 mb-2">{{ __('translate.Job Applications') }}</h3>
                    <ul class="d-flex align-items-center gap-2">
                        <li class="text-dark-200 fs-6">{{ __('translate.Dashboard') }}</li>
                        <li>
                            <svg xmlns="http://www.w3.org/2000/svg" width="5" height="11" viewBox="0 0 5 11"
                                fill="none">
                                <path d="M1 10L4 5.5L1 1" stroke="#5B5B5B" stroke-width="1.2" stroke-linecap="round"
                                    stroke-linejoin="round" />
                            </svg>
                        </li>
                        <li class="text-lime-300 fs-6">{{ __('translate.Job Applications') }}</li>
                    </ul>
                </div>
            </div>
            <!-- Content -->
            <div>
                <!-- My Job -->
                <div class="overflow-x-auto">
                    <div class="w-100">
                        <table class="w-100 dashboard-table applicant-table">
                            <thead class="pb-3">
                                <tr>
                                    <th scope="col">{{ __('translate.SN') }}</th>
                                    <th scope="col">{{ __('translate.Name') }}</th>
                                    <th scope="col">{{ __('translate.Status') }}</th>
                                    <th scope="col" class="text-end">{{ __('translate.Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($job_requests as $index => $job_request)
                                    <tr>
                                        <td class="text-dark-200">{{ ++$index }}</td>
                                        <td>
                                            <div class="d-flex gap-3 align-items-center project-name">
                                                <div class="rounded-3">
                                                    @if ($job_request?->seller->image)
                                                        <img src="{{ $job_request?->seller->image ? custom_asset($job_request?->seller->image) : custom_asset($general_setting->default_placeholder) }}"
                                                            class="img-fluid rounded-3" alt="" />
                                                    @else
                                                        <img src="{{ custom_asset($general_setting->default_avatar) }}"
                                                            class="img-fluid rounded-3" alt="" />
                                                    @endif

                                                </div>
                                                <div>
                                                    <p class="text-dark-200">
                                                        {{ html_decode($job_request?->seller?->name) }}</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @if ($job_request->status == 'approved')
                                                <span class="status-badge in-progress">{{ __('translate.Hired') }}</span>
                                            @elseif ($job_request->status == 'pending')
                                                <span class="status-badge pending">{{ __('translate.Pending') }}</span>
                                            @else
                                                <span class="status-badge canceled">{{ __('translate.Canceled') }}</span>
                                            @endif

                                        </td>
                                        <td class="text-end">

                                            <div class="d-flex justify-content-end gap-2">


                                                @if (checkModule('LiveChat'))
                                                <div>
                                                    <a href="{{ route('buyer.chat-job-post-applicants', $job_request->id) }}"
                                                        class="dashboard-action-btn">
                                                        <span>
                                                            <span>
                                                                <svg width="22" height="20"
                                                                    viewBox="0 0 22 20" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path
                                                                        d="M7 12H15M7 8H11M20.9664 9.21661C20.9886 9.47478 21 9.73606 21 10C21 14.9706 16.9706 19 12 19H5C2.79086 19 1 17.2091 1 15V10C1 5.02944 5.02944 1 10 1H12C12.2639 1 12.5252 1.01136 12.7834 1.03362M21 4C21 5.65685 19.6569 7 18 7C16.3431 7 15 5.65685 15 4C15 2.34315 16.3431 1 18 1C19.6569 1 21 2.34315 21 4Z"
                                                                        stroke="#5B5B5B" stroke-width="1.5"
                                                                        stroke-linecap="round"></path>
                                                                </svg>
                                                            </span>
                                                        </span>
                                                    </a>
                                                </div>
                                                @endif


                                                <button data-bs-toggle="modal"
                                                    data-bs-target="#applicationDetail{{ $job_request->id }}"
                                                    class="dashboard-action-btn">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="48"
                                                        height="48" viewBox="0 0 48 48" fill="none">
                                                        <circle cx="24" cy="24" r="24"
                                                            fill="#EDEBE7" />
                                                        <path
                                                            d="M34.3187 21.6619C35.6716 23.0854 35.6716 25.248 34.3187 26.6714C32.0369 29.0721 28.1181 32.3333 23.6667 32.3333C19.2152 32.3333 15.2964 29.0721 13.0147 26.6714C11.6618 25.248 11.6618 23.0854 13.0147 21.6619C15.2964 19.2612 19.2152 16 23.6667 16C28.1181 16 32.0369 19.2612 34.3187 21.6619Z"
                                                            stroke="#5B5B5B" stroke-width="1.5" />
                                                        <circle cx="23.668" cy="24.167" r="3.5"
                                                            stroke="#5B5B5B" stroke-width="1.5" />
                                                    </svg>
                                                </button>

                                            </div>



                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </main>


    @foreach ($job_requests as $index => $job_request)
        <!-- Application detail Modal -->
        <div class="modal fade" id="applicationDetail{{ $job_request->id }}" tabindex="-1"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content ">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Application Details') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <table class="table table-bordered table-striped">
                            <tbody>
                                <tr>
                                    <td>{{ __('translate.Name') }}</td>
                                    <td>{{ html_decode($job_request?->seller?->name) }}</td>
                                </tr>


                                <tr>
                                    <td>{{ __('translate.Apply Date') }}</td>
                                    <td>{{ $job_request->created_at->format('Y-m-d') }}</td>
                                </tr>
                                <tr>
                                    <td> {{ __('translate.Message') }}</td>
                                    <td>{!! clean(nl2br(html_decode($job_request->description))) !!}</td>
                                </tr>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        <!-- Job Approval Confirmation Modal -->
        <div class="modal fade" id="applicationApproval{{ $job_request->id }}" tabindex="-1"
            aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Approval Confirmation') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>{{ __('translate.Are you realy want to approve this item?') }}</p>
                    </div>
                    <div class="modal-footer">
                        <form action="{{ route('buyer.job-application-approval', $job_request->id) }}" method="POST"
                            class="delet_modal_form">
                            @csrf
                            @method('PUT')

                            <button type="button" class="btn btn-secondary"
                                data-bs-dismiss="modal">{{ __('translate.Close') }}</button>
                            <button type="submit" class="btn btn-primary">{{ __('translate.Yes, Approved') }}</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endsection
