<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_post_messages', function (Blueprint $table) {
            $table->id();
            $table->integer('buyer_id')->nullable();
            $table->integer('seller_id')->nullable();
            $table->text('message')->nullable();
            $table->integer('buyer_read_msg')->nullable();
            $table->integer('seller_read_msg')->nullable();
            $table->string('send_by')->nullable();
            $table->integer('job_request_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('job_post_messages');
    }
};
