<?php

namespace Modules\GlobalSetting\App\Http\Controllers;

use App\Models\User;
use App\Models\Admin;
use App\Models\Order;
use App\Models\Review;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

use Modules\City\Entities\City;
use Modules\FAQ\App\Models\Faq;
use Modules\Blog\App\Models\Blog;
use App\Http\Controllers\Controller;
use Cache, Image, File, Str, Artisan;
use Illuminate\Http\RedirectResponse;
use Modules\JobPost\Entities\JobPost;
use Modules\Listing\Entities\Listing;
use Modules\Category\Entities\Category;
use Modules\Page\App\Models\CustomPage;
use Modules\Blog\App\Models\BlogComment;
use Modules\JobPost\Entities\JobRequest;
use Modules\Blog\App\Models\BlogCategory;
use Modules\Currency\App\Models\Currency;
use Modules\Language\App\Models\Language;
use Modules\Wishlist\App\Models\Wishlist;
use Modules\City\Entities\CityTranslation;
use Modules\FAQ\App\Models\FaqTranslation;
use Modules\Page\App\Models\PrivacyPolicy;
use Modules\Blog\App\Models\BlogTranslation;
use Modules\Listing\Entities\ListingGallery;
use Modules\Newsletter\App\Models\Newsletter;
use Modules\Page\App\Models\TermAndCondition;
use Modules\Listing\App\Models\ListingPackage;
use Modules\Page\App\Models\AboutUsTranslation;
use Modules\Testimonial\App\Models\Testimonial;
use Modules\JobPost\Entities\JobPostTranslation;
use Modules\Listing\Entities\ListingTranslation;
use Modules\Page\App\Models\HomepageTranslation;
use Modules\Page\App\Models\ContactUsTranslation;
use Modules\Category\Entities\CategoryTranslation;
use Modules\Page\App\Models\CustomPageTranslation;
use Modules\GlobalSetting\App\Models\GlobalSetting;
use Modules\Blog\App\Models\BlogCategoryTranslation;
use Modules\ContactMessage\App\Models\ContactMessage;
use Modules\PaymentGateway\App\Models\PaymentGateway;
use Modules\PaymentWithdraw\App\Models\SellerWithdraw;
use Modules\PaymentWithdraw\App\Models\WithdrawMethod;
use Modules\Testimonial\App\Models\TestimonialTrasnlation;
use Modules\GlobalSetting\App\Http\Requests\TawkChatRequest;
use Modules\GlobalSetting\App\Http\Requests\SocialLoginRequest;
use Modules\GlobalSetting\App\Http\Requests\CookieConsentRequest;
use Modules\GlobalSetting\App\Http\Requests\FacebookPixelRequest;
use Modules\GlobalSetting\App\Http\Requests\GeneralSettingRequest;
use Modules\GlobalSetting\App\Http\Requests\GoogleAnalyticRequest;
use Modules\GlobalSetting\App\Http\Requests\GoogleRecaptchaRequest;

class GlobalSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function general_setting()
    {
        return view('globalsetting::index');
    }

    public function update_general_setting(GeneralSettingRequest $request)
    {

        if ($request->commission_type == 'subscription') {
            if (!checkModule('Subscription')) {
                $notify_message = trans('translate.Please enable subscription module first');
                $notify_message = array('message' => $notify_message, 'alert-type' => 'error');
                return redirect()->back()->with($notify_message);
            }
        }

        GlobalSetting::where('key', 'selected_theme')->update(['value' => $request->selected_theme]);
        GlobalSetting::where('key', 'app_name')->update(['value' => $request->app_name]);
        GlobalSetting::where('key', 'contact_message_mail')->update(['value' => $request->contact_message_mail]);
        GlobalSetting::where('key', 'timezone')->update(['value' => $request->timezone]);
        GlobalSetting::where('key', 'commission_type')->update(['value' => $request->commission_type]);
        GlobalSetting::where('key', 'commission_per_sale')->update(['value' => $request->commission_per_sale]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function update_logo_favicon(Request $request)
    {
        $logo_setting = GlobalSetting::where('key', 'logo')->first();

        if ($request->logo) {
            $file_path = uploadPublicFile($request->logo, 'uploads/custom-images', $logo_setting->value);
            $logo_setting->value = $file_path;
            $logo_setting->save();
        }

        $footer_logo_setting = GlobalSetting::where('key', 'footer_logo')->first();

        if ($request->footer_logo) {
            $file_path = uploadPublicFile($request->footer_logo, 'uploads/custom-images', $footer_logo_setting->value);
            $footer_logo_setting->value = $file_path;
            $footer_logo_setting->save();
        }

        $logo_setting = GlobalSetting::where('key', 'favicon')->first();

        if ($request->favicon) {
            $file_path = uploadPublicFile($request->favicon, 'uploads/custom-images', $logo_setting->value);
            $logo_setting->value = $file_path;
            $logo_setting->save();
        }


        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function update_google_captcha(GoogleRecaptchaRequest $request)
    {

        GlobalSetting::where('key', 'recaptcha_site_key')->update(['value' => $request->site_key]);
        GlobalSetting::where('key', 'recaptcha_secret_key')->update(['value' => $request->secret_key]);
        GlobalSetting::where('key', 'recaptcha_status')->update(['value' => $request->status ? 1 : 0]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function update_tawk_chat(TawkChatRequest $request)
    {

        GlobalSetting::where('key', 'tawk_chat_link')->update(['value' => $request->chat_link]);
        GlobalSetting::where('key', 'tawk_status')->update(['value' => $request->status ? 1 : 0]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function update_google_analytic(GoogleAnalyticRequest $request)
    {

        GlobalSetting::where('key', 'google_analytic_id')->update(['value' => $request->analytic_id]);
        GlobalSetting::where('key', 'google_analytic_status')->update(['value' => $request->status ? 1 : 0]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function update_facebook_pixel(FacebookPixelRequest $request)
    {

        GlobalSetting::where('key', 'pixel_app_id')->update(['value' => $request->app_id]);
        GlobalSetting::where('key', 'pixel_status')->update(['value' => $request->status ? 1 : 0]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function database_clear()
    {

        Blog::truncate();

        BlogTranslation::truncate();
        BlogCategory::truncate();
        BlogCategoryTranslation::truncate();
        BlogComment::truncate();
        Category::truncate();
        CategoryTranslation::truncate();
        City::truncate();
        CityTranslation::truncate();
        ContactMessage::truncate();
        CustomPage::truncate();
        CustomPageTranslation::truncate();
        Faq::truncate();
        FaqTranslation::truncate();

        JobPost::truncate();
        JobPostTranslation::truncate();
        JobPostTranslation::truncate();
        JobRequest::truncate();

        Listing::truncate();
        ListingGallery::truncate();
        ListingTranslation::truncate();
        ListingPackage::truncate();
        Review::truncate();
        Newsletter::truncate();

        Order::truncate();
        SellerWithdraw::truncate();
        Testimonial::truncate();
        TestimonialTrasnlation::truncate();
        User::truncate();
        Wishlist::truncate();
        WithdrawMethod::truncate();

        AboutUsTranslation::where('lang_code', '!=', 'en')->delete();
        ContactUsTranslation::where('lang_code', '!=', 'en')->delete();
        HomepageTranslation::where('lang_code', '!=', 'en')->delete();
        PrivacyPolicy::where('lang_code', '!=', 'en')->delete();
        TermAndCondition::where('lang_code', '!=', 'en')->delete();

        Currency::where('id', '!=', 1)->delete();
        Language::where('id', '!=', 1)->delete();

        $admins = Admin::where('id', '!=', 1)->get();
        foreach ($admins as $admin) {
            $admin_image = $admin->image;
            $admin->delete();
            if ($admin_image) {
                if (File::exists(public_path() . '/' . $admin_image)) unlink(public_path() . '/' . $admin_image);
            }
        }


        $folderPath = public_path('uploads/custom-images');
        $response = File::deleteDirectory($folderPath);

        $path = public_path('uploads/custom-images');
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        PaymentGateway::where('key', 'stripe_currency_id')->update(['value' => 1]);
        PaymentGateway::where('key', 'paypal_currency_id')->update(['value' => 1]);
        PaymentGateway::where('key', 'razorpay_currency_id')->update(['value' => 1]);
        PaymentGateway::where('key', 'flutterwave_currency_id')->update(['value' => 1]);
        PaymentGateway::where('key', 'mollie_currency_id')->update(['value' => 1]);
        PaymentGateway::where('key', 'paystack_currency_id')->update(['value' => 1]);
        PaymentGateway::where('key', 'instamojo_currency_id')->update(['value' => 1]);


        $notify_message = trans('translate.Database clear successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function cookie_consent()
    {

        return view('globalsetting::cookie_consent');
    }


    public function cookie_consent_update(CookieConsentRequest $request)
    {

        GlobalSetting::where('key', 'cookie_consent_message')->update(['value' => $request->message]);
        GlobalSetting::where('key', 'cookie_consent_status')->update(['value' => $request->status ? 1 : 0]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function error_image()
    {

        return view('globalsetting::error_image');
    }


    public function error_image_update(Request $request)
    {

        $setting = GlobalSetting::where('key', 'error_image')->first();

        if ($request->error_image) {
            $file_path = uploadPublicFile($request->error_image, 'uploads/website-images', $setting->value);
            $setting->value = $file_path;
            $setting->save();
        }

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function login_image()
    {

        return view('globalsetting::login_image');
    }


    public function login_image_update(Request $request)
    {

        $setting = GlobalSetting::where('key', 'login_page_bg')->first();

        if ($request->login_page_bg) {
            $file_path = uploadPublicFile($request->login_page_bg, 'uploads/website-images', $setting->value);
            $setting->value = $file_path;
            $setting->save();
        }

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function admin_login_image()
    {

        return view('globalsetting::admin_login_image');
    }


    public function admin_login_image_update(Request $request)
    {

        $setting = GlobalSetting::where('key', 'admin_login')->first();

        if ($request->admin_login) {
            $file_path = uploadPublicFile($request->admin_login, 'uploads/website-images', $setting->value);
            $setting->value = $file_path;
            $setting->save();
        }

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function breadcrumb()
    {

        return view('globalsetting::breadcrumb');
    }


    public function breadcrumb_update(Request $request)
    {

        $setting = GlobalSetting::where('key', 'breadcrumb_image')->first();

        if ($request->breadcrumb_image) {
            $file_path = uploadPublicFile($request->breadcrumb_image, 'uploads/website-images', $setting->value);
            $setting->value = $file_path;
            $setting->save();
        }

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function social_login()
    {

        return view('globalsetting::social_login');
    }

    public function social_login_update(SocialLoginRequest $request)
    {

        GlobalSetting::where('key', 'facebook_client_id')->update(['value' => $request->facebook_client_id]);
        GlobalSetting::where('key', 'facebook_secret_id')->update(['value' => $request->facebook_secret_id]);
        GlobalSetting::where('key', 'facebook_redirect_url')->update(['value' => $request->facebook_redirect_url]);
        GlobalSetting::where('key', 'is_facebook')->update(['value' => $request->is_facebook ? 1 : 0]);

        GlobalSetting::where('key', 'gmail_client_id')->update(['value' => $request->gmail_client_id]);
        GlobalSetting::where('key', 'gmail_secret_id')->update(['value' => $request->gmail_secret_id]);
        GlobalSetting::where('key', 'gmail_redirect_url')->update(['value' => $request->gmail_redirect_url]);
        GlobalSetting::where('key', 'is_gmail')->update(['value' => $request->is_gmail ? 1 : 0]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function default_avatar()
    {

        return view('globalsetting::default_avatar');
    }


    public function default_avatar_update(Request $request)
    {

        $setting = GlobalSetting::where('key', 'default_avatar')->first();

        if ($request->default_avatar) {
            $file_path = uploadPublicFile($request->default_avatar, 'uploads/website-images', $setting->value);
            $setting->value = $file_path;
            $setting->save();
        }

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function default_placeholder()
    {

        return view('globalsetting::default_placeholder');
    }


    public function default_placeholder_update(Request $request)
    {

        $setting = GlobalSetting::where('key', 'default_placeholder')->first();

        if ($request->default_placeholder) {
            $file_path = uploadPublicFile($request->default_placeholder, 'uploads/website-images', $setting->value);
            $setting->value = $file_path;
            $setting->save();
        }

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function maintenance_mode()
    {
        return view('globalsetting::maintenance_mode');
    }


    public function maintenance_mode_update(Request $request)
    {

        $setting = GlobalSetting::where('key', 'maintenance_image')->first();

        if ($request->maintenance_image) {
            $file_path = uploadPublicFile($request->maintenance_image, 'uploads/website-images', $setting->value);
            $setting->value = $file_path;
            $setting->save();
        }

        GlobalSetting::where('key', 'maintenance_text')->update(['value' => $request->maintenance_text]);
        GlobalSetting::where('key', 'maintenance_status')->update(['value' => $request->maintenance_status ? 1 : 0]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function cache_clear()
    {

        Artisan::call('optimize:clear');

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function set_cache_setting()
    {
        $setting_data = GlobalSetting::get();

        $setting = array();

        foreach ($setting_data as $data_item) {
            $setting[$data_item->key] = $data_item->value;
        }

        $setting = (object) $setting;


        Cache::put('setting', $setting);
    }


    public function splash_screen()
    {

        return view('globalsetting::splash_screen');
    }

    public function splash_screen_update(Request $request)
    {

        $splash_screen1 = GlobalSetting::where('key', 'splash_screen1')->first();
        $splash_screen2 = GlobalSetting::where('key', 'splash_screen2')->first();
        $splash_screen3 = GlobalSetting::where('key', 'splash_screen3')->first();

        if ($request->splash_screen1) {
            $file_path = uploadPublicFile($request->splash_screen1, 'uploads/website-images', $splash_screen1->value);
            $splash_screen1->value = $file_path;
            $splash_screen1->save();
        }

        if ($request->splash_screen2) {
            $file_path = uploadPublicFile($request->splash_screen2, 'uploads/website-images', $splash_screen2->value);
            $splash_screen2->value = $file_path;
            $splash_screen2->save();
        }

        if ($request->splash_screen3) {
            $file_path = uploadPublicFile($request->splash_screen3, 'uploads/website-images', $splash_screen3->value);
            $splash_screen3->value = $file_path;
            $splash_screen3->save();
        }




        GlobalSetting::where('key', 'splash_screen3_title')->update(['value' => $request->splash_screen3_title]);
        GlobalSetting::where('key', 'splash_screen2_title')->update(['value' => $request->splash_screen2_title]);
        GlobalSetting::where('key', 'splash_screen1_title')->update(['value' => $request->splash_screen1_title]);

        $this->set_cache_setting();

        $notify_message = trans('translate.Updated successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }
}
