<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{__('Flutterwave Payment')}}</title>
    <link rel="icon" type="image/png" href="{{ asset($setting->favicon) }}">

    <script src="{{ asset('global/js/jquery-3.7.1.min.js') }}"></script>
    <script src="https://checkout.flutterwave.com/v3.js"></script>

</head>
<body>
    <p style="text-align: center">Please wait. Your payment is processing....</p>
    <p style="text-align: center">Do not press browser back or forward button while you are in payment page</p>

    {{-- start flutterwave payment --}}
    <script src="https://checkout.flutterwave.com/v3.js"></script>

    @php
        $payable_amount = $payable_amount * $flutterwave_currency->currency_rate;
        $payable_amount = round($payable_amount, 2);
    @endphp

    <script>
        flutterwavePayment();
        function flutterwavePayment() {
            FlutterwaveCheckout({
                public_key: "{{ $payment_setting->flutterwave_public_key }}",
                tx_ref: "{{ substr(rand(0,time()),0,10) }}",
                amount: {{ $payable_amount }},
                currency: "{{ $flutterwave_currency->currency_code }}",
                country: "{{ $flutterwave_currency->country_code }}",
                payment_options: " ",
                customer: {
                email: "{{ $user->email }}",
                phone_number: "{{ $user->phone }}",
                name: "{{ $user->name }}",
                },
                callback: function (data) {

                    var tnx_id = data.transaction_id;
                    var _token = "{{ csrf_token() }}";
                    $.ajax({
                        type: 'post',
                        data : {tnx_id,_token},
                        url: "{{ url('payment/flutterwave-webview-payment/') }}" + "/" + "{{ $service_package->id }}" + "/" + "{{ $package_name }}",
                        success: function (response) {
                            console.log(response)
                            if(response.status == 'success'){
                                window.location.href = "{{ route('webview-success-payment') }}";
                            }else{
                                window.location.href = "{{ route('webview-faild-payment') }}";
                            }
                        },
                        error: function(err) {
                            console.log(response)
                            window.location.href = "{{ route('webview-faild-payment') }}";
                        }
                    });
                },
                customizations: {
                title: "{{ $payment_setting->flutterwave_title }}",
                logo: "{{ asset($payment_setting->flutterwave_logo) }}",
                },
            });
        }
    </script>
</body>
</html>
