@extends('buyer.layout')
@section('title')
    <title>{{ __('translate.Buyer || Add Balance') }}</title>
@endsection
@section('front-content')
<main class="dashboard-main min-vh-100">
    <div class="d-flex flex-column gap-4">
      <!-- Header -->
      <div class="d-flex align-items-center justify-content-between">
        <div>
          <h3 class="text-24 fw-bold text-dark-300 mb-2">
            {{ __('translate.Add Balance') }}
          </h3>
          <ul class="d-flex align-items-center gap-2">
            <li class="text-dark-200 fs-6">{{ __('translate.Dashboard') }}</li>
            <li>
              <svg
                xmlns="http://www.w3.org/2000/svg"
                width="5"
                height="11"
                viewBox="0 0 5 11"
                fill="none"
              >
                <path
                  d="M1 10L4 5.5L1 1"
                  stroke="#5B5B5B"
                  stroke-width="1.2"
                  stroke-linecap="round"
                  stroke-linejoin="round"
                />
              </svg>
            </li>
            <li class="text-lime-300 fs-6">{{ __('translate.Add Balance') }}</li>
          </ul>
        </div>
      </div>
      <!-- Content -->
      <div>
        <div class="row justify-content-center">
          <div class="col-xl-8">
            <form class="stripe-modal-form require-validation " role="form" action="{{ route('buyer.wallet-payment.bank-store') }}" method="POST" >
                @csrf

                <div class="mb-3">
                    {!! clean(nl2br($payment_setting->bank_account_info)) !!}
                </div>


                <div class="d-flex flex-column gap-4">

                    <div class="proposal-input-container">
                        <label for="time" class="proposal-form-label" >{{ __('translate.Transaction information') }}*</label >
                        <textarea placeholder="{{ ('Transaction information') }}" class="form-textarea shadow-none" name="tnx_info"></textarea>
                    </div>

                    <div class="d-flex gap-4 align-items-center justify-content-end" >
                        <button type="button" class="w-btn-gray-sm" data-bs-dismiss="modal">
                            {{ __('translate.Cancel') }}
                        </button>
                        <button type="submit" class="w-btn-secondary-sm">
                            {{ __('translate.Submit Now') }}
                        </button>
                    </div>
                </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </main>

@endsection

