<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\LiveChat\App\Http\Controllers\API\Buyer\LiveChatController;
use Modules\LiveChat\App\Http\Controllers\API\Seller\LiveChatController as SellerLiveChatController;

/*
    |--------------------------------------------------------------------------
    | API Routes
    |--------------------------------------------------------------------------
    |
    | Here is where you can register API routes for your application. These
    | routes are loaded by the RouteServiceProvider within a group which
    | is assigned the "api" middleware group. Enjoy building your API!
    |
*/

Route::middleware(['auth:sanctum'])->prefix('v1')->name('api.')->group(function () {
    Route::get('livechat', fn (Request $request) => $request->user())->name('livechat');
});


Route::group(['as' => 'buyer.', 'prefix' => 'buyer', 'middleware' => [ 'HtmlSpecialchars', 'MaintenanceMode', 'auth:api']], function () {

    Route::get('livechat', [LiveChatController::class, 'index'])->name('livechat');
    Route::get('get-message-body/{buyer_id}', [LiveChatController::class, 'get_message_body'])->name('get-message-body');
    Route::get('get-message-list/{buyer_id}', [LiveChatController::class, 'get_message_list'])->name('get-message-list');
    Route::post('store-message', [LiveChatController::class, 'store'])->name('store-message');
    Route::post('store-message-from-service', [LiveChatController::class, 'store_from_service'])->name('store-message-from-service');

});


Route::group(['as' => 'seller.', 'prefix' => 'seller', 'middleware' => [ 'HtmlSpecialchars', 'MaintenanceMode', 'auth:api']], function () {

    Route::get('livechat', [SellerLiveChatController::class, 'index'])->name('livechat');
    Route::get('get-message-body/{buyer_id}', [SellerLiveChatController::class, 'get_message_body'])->name('get-message-body');
    Route::get('get-message-list/{buyer_id}', [SellerLiveChatController::class, 'get_message_list'])->name('get-message-list');
    Route::post('store-message', [SellerLiveChatController::class, 'store'])->name('store-message');

});
