<?php

namespace Modules\JobPost\Http\Controllers\API\Seller;

use App\Models\User;
use App\Rules\Captcha;

use Auth, Image, File, Str;
use Illuminate\Http\Request;
use Modules\City\Entities\City;
use Illuminate\Routing\Controller;

use Modules\JobPost\Entities\JobPost;
use Modules\Category\Entities\Category;
use Modules\JobPost\Entities\JobRequest;

use Modules\Language\App\Models\Language;

use Illuminate\Contracts\Support\Renderable;
use Modules\JobPost\Entities\JobPostTranslation;
use Modules\JobPost\Http\Requests\JobPostRequest;

class JobPostController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $user = Auth::guard('api')->user();

        $job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->latest()->get();

        $hired_job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->where('status', 'approved')->latest()->get();

        $pending_job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->where('status', 'pending')->latest()->get();

        $reject_job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->where('status', 'rejected')->latest()->get();

        return response()->json([
            'job_requests' => $job_requests,
            'hired_job_requests' => $hired_job_requests,
            'pending_job_requests' => $pending_job_requests,
            'reject_job_requests' => $reject_job_requests,
        ]);
    }

    public function show(Request $request, $job_reqeust_id){
        $user = Auth::guard('api')->user();

        $job_request = JobRequest::with('job_post')->where('seller_id', $user->id)->where('id', $job_reqeust_id)->first();

        if(!$job_request){
            return response()->json([
                'message' => trans('Not Found')
            ], 403);
        }

        return response()->json([
            'job_request' => $job_request
        ]);

    }


    public function apply_job(Request $request, $id){

        $rules = [
            'description'=>'required'
        ];

        $customMessages = [
            'description.required' => trans('translate.Message is required'),
        ];

        $request->validate($rules,$customMessages);

        $job_post = JobPost::find($id);

        if(!$job_post){
            return response()->json([
                'message' => trans('Not Found')
            ], 403);
        }

        $auth_user = Auth::guard('api')->user();

        if($auth_user->is_seller == 0){
            $notify_message = trans('translate.To apply the job, you have to logged in as a seller');
            return response()->json([
                'message' => $notify_message
            ], 403);
        }

        $is_exist = JobRequest::where(['seller_id' => $auth_user->id, 'job_post_id' => $id])->count();
        if($is_exist > 0){
            $notify_message = trans('translate.Application already submited');
            return response()->json([
                'message' => $notify_message
            ], 403);
        }

        $approval_check = JobRequest::where('job_post_id', $request->listing_id)->where('status', 'approved')->count();

        if($approval_check > 0){
            $notify_message = trans('translate.Job already has assigned, so you can not apply');
            return response()->json([
                'message' => $notify_message
            ], 403);
        }



        $job_request = new JobRequest();
        $job_request->seller_id = $auth_user->id;
        $job_request->user_id = $job_post->user_id;
        $job_request->job_post_id = $id;
        $job_request->description = $request->description;
        $job_request->save();

        $notify_message = trans('translate.Your application has submited successfully, please wait for agent approval');
        return response()->json([
            'message' => $notify_message
        ]);

    }


}
