@extends('admin.master_layout')
@section('title')
    <title>{{ __('translate.Splash Screen') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('translate.Splash Screen') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Section') }} >> {{ __('translate.Splash Screen') }}</p>
@endsection

@section('body-content')

   

    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-md-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="{{ route('admin.splash-screen-update') }}" method="POST" enctype="multipart/form-data">
                                @csrf

                                @method('PUT')

                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="row">
                                                <div class="col-md-6 mg-top-form-20">
                                                    
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <div class="crancy__item-form--group w-100 h-100">
                                                                    <label class="crancy__item-label">{{ __('translate.Screen one') }} </label>
                                                                    <div class="crancy-product-card__upload crancy-product-card__upload--border">
                                                                        <input type="file" class="btn-check" name="splash_screen1" id="input-img1" autocomplete="off" onchange="previewImage(event)">
                                                                        <label class="crancy-image-video-upload__label" for="input-img1">
                                                                            <img id="view_img" src="{{ asset($general_setting->splash_screen1 ?? '') }}">
                                                                            <h4 class="crancy-image-video-upload__title">{{ __('translate.Click here to') }} <span class="crancy-primary-color">{{ __('translate.Choose File') }}</span> {{ __('translate.and upload') }} </h4>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Screen one title') }} * </label>
                                                        <input class="crancy__item-input" type="text" name="splash_screen1_title" id="splash_screen1_title" value="{{ $general_setting->splash_screen1_title ?? '' }}">
                                                    </div>

                                                    
                                                </div>

                                                <div class="col-md-6 mg-top-form-20">
                                                    
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <div class="crancy__item-form--group w-100 h-100">
                                                                    <label class="crancy__item-label">{{ __('translate.Screen two') }} </label>
                                                                    <div class="crancy-product-card__upload crancy-product-card__upload--border">
                                                                        <input type="file" class="btn-check" name="splash_screen2" id="input-img2" autocomplete="off" onchange="previewImage2(event)">
                                                                        <label class="crancy-image-video-upload__label" for="input-img2">
                                                                            <img id="view_img2" src="{{ asset($general_setting->splash_screen2 ?? '') }}">
                                                                            <h4 class="crancy-image-video-upload__title">{{ __('translate.Click here to') }} <span class="crancy-primary-color">{{ __('translate.Choose File') }}</span> {{ __('translate.and upload') }} </h4>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                   

                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Screen two title') }} * </label>
                                                        <input class="crancy__item-input" type="text" name="splash_screen2_title" id="splash_screen2_title" value="{{ $general_setting->splash_screen2_title ?? '' }}">
                                                    </div>

                                                </div>

                                                <div class="col-md-6 mg-top-form-20">
                                                   
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <div class="crancy__item-form--group w-100 h-100">
                                                                    <label class="crancy__item-label">{{ __('translate.Screen three') }} </label>
                                                                    <div class="crancy-product-card__upload crancy-product-card__upload--border">
                                                                        <input type="file" class="btn-check" name="splash_screen3" id="input-img3" autocomplete="off" onchange="previewImage3(event)">
                                                                        <label class="crancy-image-video-upload__label" for="input-img3">
                                                                            <img id="view_img3" src="{{ asset($general_setting->splash_screen3 ?? '') }}">
                                                                            <h4 class="crancy-image-video-upload__title">{{ __('translate.Click here to') }} <span class="crancy-primary-color">{{ __('translate.Choose File') }}</span> {{ __('translate.and upload') }} </h4>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                              

                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Screen three title') }} * </label>
                                                        <input class="crancy__item-input" type="text" name="splash_screen3_title" id="splash_screen3_title" value="{{ $general_setting->splash_screen3_title ?? '' }}">
                                                    </div>

                                                 
                                                </div>

                                             
                                            </div>

                                            <button class="crancy-btn mg-top-25" type="submit">{{ __('translate.Update') }}</button>

                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>

                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->

@endsection

@push('js_section')

    <script>
        "use strict";

        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };

        function previewImage2(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('view_img2');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };

        function previewImage3(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('view_img3');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };

        function previewImage4(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('view_img4');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };

        function videoPreviewImage(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('video_image');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };






    </script>
@endpush
