<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Blade;

class AdminPermissionServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        // Register @can directive for admin permissions
        Blade::directive('can', function ($expression) {
            return "<?php if(auth('admin')->check() && auth('admin')->user()->hasPermission($expression)): ?>";
        });

        // Register @cannot directive for admin permissions
        Blade::directive('cannot', function ($expression) {
            return "<?php if(!auth('admin')->check() || !auth('admin')->user()->hasPermission($expression)): ?>";
        });

        // Register @canany directive for multiple admin permissions
        Blade::directive('canany', function ($expression) {
            return "<?php if(auth('admin')->check() && auth('admin')->user()->hasAnyPermission($expression)): ?>";
        });

        // Register @canall directive for all admin permissions
        Blade::directive('canall', function ($expression) {
            return "<?php if(auth('admin')->check() && auth('admin')->user()->hasAllPermissions($expression)): ?>";
        });

        // Register @hasrole directive for admin roles
        Blade::directive('hasrole', function ($expression) {
            return "<?php if(auth('admin')->check() && auth('admin')->user()->hasRole($expression)): ?>";
        });

        // Register @hasanyrole directive for multiple admin roles
        Blade::directive('hasanyrole', function ($expression) {
            return "<?php if(auth('admin')->check() && auth('admin')->user()->hasAnyRole($expression)): ?>";
        });

        // Register @isadmin directive to check if user is admin
        Blade::directive('isadmin', function () {
            return "<?php if(auth('admin')->check()): ?>";
        });

        // Register @issuperadmin directive to check if user is super admin
        Blade::directive('issuperadmin', function () {
            return "<?php if(auth('admin')->check() && auth('admin')->user()->admin_type === 'super_admin'): ?>";
        });

        // Register @endcan directive
        Blade::directive('endcan', function () {
            return "<?php endif; ?>";
        });

        // Register @endcannot directive
        Blade::directive('endcannot', function () {
            return "<?php endif; ?>";
        });

        // Register @endcanany directive
        Blade::directive('endcanany', function () {
            return "<?php endif; ?>";
        });

        // Register @endcanall directive
        Blade::directive('endcanall', function () {
            return "<?php endif; ?>";
        });

        // Register @endhasrole directive
        Blade::directive('endhasrole', function () {
            return "<?php endif; ?>";
        });

        // Register @endhasanyrole directive
        Blade::directive('endhasanyrole', function () {
            return "<?php endif; ?>";
        });

        // Register @endisadmin directive
        Blade::directive('endisadmin', function () {
            return "<?php endif; ?>";
        });

        // Register @endissuperadmin directive
        Blade::directive('endissuperadmin', function () {
            return "<?php endif; ?>";
        });
    }
}
