@extends('admin.master_layout')
@section('title')
    <title>{{ __('translate.Create Admin') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('translate.Create Admin') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Admin Management') }} >> {{ __('translate.Create Admin') }}</p>
@endsection

@section('body-content')
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="{{ route('admin.adminteam.store') }}" method="POST">
                                @csrf

                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title">{{ __('translate.Create Admin') }}</h4>

                                                <a href="{{ route('admin.adminteam.index') }}" class="crancy-btn "><i
                                                        class="fa fa-list"></i> {{ __('translate.Admin List') }}</a>
                                            </div>


                                            <div class="row mg-top-30">

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Name') }} * </label>
                                                        <input class="crancy__item-input" type="text" name="name"
                                                            id="name" value="{{ old('name') }}">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Email') }} *
                                                        </label>
                                                        <input class="crancy__item-input" type="text" name="email"
                                                            id="email" value="{{ old('email') }}">
                                                    </div>
                                                </div>


                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Password') }} *
                                                        </label>
                                                        <input class="crancy__item-input" type="password" name="password"
                                                            id="password" value="{{ old('password') }}">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Roles') }} *
                                                        </label>
                                                        <select class="crancy__item-input select2" name="role_id[]"
                                                            id="role_id" multiple>
                                                            <option value="">{{ __('translate.Select') }} {{ __('translate.Roles') }}</option>
                                                            @foreach ($roles as $role)
                                                                <option value="{{ $role->id }}">
                                                                    {{ $role->display_name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>



                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Status') }} </label>
                                                        <div
                                                            class="crancy-ptabs__notify-switch  crancy-ptabs__notify-switch--two">
                                                            <label class="crancy__item-switch">
                                                                <input name="status" type="checkbox" checked>
                                                                <span
                                                                    class="crancy__item-switch--slide crancy__item-switch--round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>




                                            @can('admin_create')
                                            <button class="crancy-btn mg-top-25"
                                                type="submit">{{ __('translate.Create Admin') }}</button>
                                            @endcan

                                        </div>
                                        <!-- End Product Card -->
                                    </div>





                                </div>



                            </form>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
@endsection

@push('style_section')
    <link rel="stylesheet" href="{{ asset('global/select2/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('global/select2/custom.css') }}">
@endpush


@push('js_section')
    <script src="{{ asset('global/select2/select2.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#role_id').select2();
        });
    </script>
@endpush
