# Workzone Laravel - Admin Permission System

This document describes the comprehensive permission system implemented for the Workzone Laravel project based on the admin sidebar structure.

## Overview

The permission system is organized into logical modules that correspond to the admin sidebar menu structure. Each module contains specific permissions that control access to various admin functions.

## Permission Modules

### 1. Dashboard Management (`dashboard`)
- **dashboard_view**: View admin dashboard

### 2. Order Management (`order`)
- **order_view**: View all orders
- **order_active_view**: View active orders
- **order_awaiting_view**: View awaiting orders
- **order_rejected_view**: View rejected orders
- **order_cancel_view**: View cancelled orders
- **order_complete_view**: View completed orders
- **order_pending_payment_view**: View pending payment orders

### 3. Service Management (`service`)
- **category_view**: View service categories
- **sub_category_view**: View service sub categories
- **service_create**: Create new services
- **service_view**: View all services
- **service_awaiting_view**: View awaiting services
- **service_featured_view**: View featured services
- **review_view**: View service reviews

### 4. Job Post Management (`jobpost`)
- **city_view**: View cities
- **jobpost_view**: View all job posts
- **jobpost_awaiting_view**: View awaiting job posts

### 5. Withdraw Management (`withdraw`)
- **withdraw_method_view**: View withdraw methods
- **withdraw_list_view**: View withdraw list

### 6. Seller Management (`seller`)
- **seller_list_view**: View seller list
- **seller_pending_view**: View pending sellers

### 7. Buyer Management (`buyer`)
- **buyer_list_view**: View buyer list
- **buyer_pending_view**: View pending buyers

### 8. Contact Message Management (`contact`)
- **contact_message_view**: View contact messages

### 9. Service Reports Management (`reports`)
- **service_reports_view**: View service reports

### 10. CMS & Blogs Management (`cms`)
- **blog_category_create**: Create blog categories
- **blog_category_view**: View blog categories
- **blog_create**: Create new blogs
- **blog_view**: View all blogs
- **comment_view**: View blog comments

### 11. Pages Management (`pages`)
- **about_us_view**: View about us page
- **contact_us_view**: View contact us page
- **terms_conditions_view**: View terms and conditions
- **privacy_policy_view**: View privacy policy
- **faq_view**: View FAQ page
- **custom_page_view**: View custom pages

### 12. Section Management (`section`)
- **intro_section_view**: View intro section
- **intro2_section_view**: View intro section 2
- **working_step_view**: View working step section
- **our_feature_view**: View our feature section
- **join_seller_view**: View join seller section
- **explore_section_view**: View explore section
- **footer_view**: View footer information
- **testimonial_view**: View testimonials
- **splash_screen_view**: View splash screen settings
- **slider_view**: View slider section

### 13. Settings & Configuration (`settings`)
- **general_setting_view**: View general settings
- **multi_currency_view**: View multi currency settings
- **language_view**: View language settings
- **theme_language_view**: View theme language settings
- **email_setting_view**: View email configuration
- **email_template_view**: View email templates
- **cookie_consent_view**: View cookie consent settings
- **error_image_view**: View error page settings
- **login_image_view**: View login page settings
- **admin_login_image_view**: View admin login page settings
- **breadcrumb_view**: View breadcrumb image settings
- **social_login_view**: View social login settings
- **default_avatar_view**: View default avatar settings
- **default_placeholder_view**: View default placeholder settings
- **maintenance_mode_view**: View maintenance mode settings
- **seo_setting_view**: View SEO settings
- **payment_gateway_view**: View payment gateway settings

### 14. Others (`others`)
- **newsletter_view**: View newsletter settings
- **newsletter_email_view**: View newsletter email settings
- **cache_clear_view**: Clear application cache

### 15. Admin Team Management (`admin_team`)
- **admin_role_view**: View admin roles
- **admin_role_create**: Create new admin roles
- **admin_role_edit**: Edit admin roles
- **admin_role_delete**: Delete admin roles
- **admin_list_view**: View admin list
- **admin_create**: Admin Create
- **admin_edit**: Admin Edit
- **admin_delete**: Admin Delete

## Admin Roles

The system includes predefined roles with specific permission sets:

### 1. Super Administrator (`super_admin`)
- **Description**: Full system access and control
- **Permissions**: All permissions
- **Access**: Can manage all aspects of the system including other admins, roles, and permissions

### 2. Administrator (`admin`)
- **Description**: General administrator with access to most system functions
- **Permissions**: All permissions except admin team management
- **Access**: Can manage all system functions except creating/editing admin users and roles

### 3. Content Manager (`content_manager`)
- **Description**: Manages content including blogs, pages, and frontend sections
- **Permissions**: CMS, Pages, and Section management permissions
- **Access**: Can manage content, blogs, static pages, and frontend sections

### 4. Service Manager (`service_manager`)
- **Description**: Manages services, categories, and service-related operations
- **Permissions**: Service and Reports management permissions
- **Access**: Can manage services, categories, reviews, and view service reports

### 5. Order Manager (`order_manager`)
- **Description**: Manages orders and order-related operations
- **Permissions**: Order and Withdraw management permissions
- **Access**: Can manage orders, view order statuses, and handle withdrawals

### 6. User Manager (`user_manager`)
- **Description**: Manages sellers, buyers, and user-related operations
- **Permissions**: Seller, Buyer, and Contact management permissions
- **Access**: Can manage sellers, buyers, and view contact messages

### 7. Viewer (`viewer`)
- **Description**: Read-only access to view data and reports
- **Permissions**: View-only permissions for most modules
- **Access**: Can view data but cannot create, edit, or delete anything

## Usage

### Running the Seeders

To populate the database with permissions and roles:

```bash
# Run all AdminTeam seeders
php artisan db:seed --class="Modules\AdminTeam\Database\Seeders\AdminTeamDatabaseSeeder"

# Or run individual seeders
php artisan db:seed --class="Modules\AdminTeam\Database\Seeders\AdminPermissionListSeeder"
php artisan db:seed --class="Modules\AdminTeam\Database\Seeders\AdminRoleSeeder"
```

### Checking Permissions in Blade Templates

```php
@can('dashboard_view')
    <!-- Dashboard content -->
@endcan

@canany(['service_view', 'service_create'])
    <!-- Service management content -->
@endcanany
```

### Checking Permissions in Controllers

```php
if (auth()->user()->can('admin_create')) {
    // Allow admin creation
}

if (auth()->user()->hasAnyPermission(['service_view', 'service_create'])) {
    // Allow service operations
}
```

## Database Structure

### admin_permission_lists Table
- `name`: Unique permission identifier
- `display_name`: Human-readable permission name
- `module`: Module category
- `description`: Permission description
- `parent_id`: Parent permission group ID
- `is_group`: Whether this is a permission group
- `status`: Permission status (active/inactive)

### admin_roles Table
- `name`: Unique role identifier
- `display_name`: Human-readable role name
- `description`: Role description
- `status`: Role status (active/inactive)
- `is_system_role`: Whether this is a system role

### admin_role_permission Table (Pivot)
- `admin_role_id`: Role ID
- `admin_permission_list_id`: Permission ID

## Customization

To add new permissions:

1. Add the permission to the `AdminPermissionListSeeder`
2. Update the sidebar blade template to use the new permission
3. Assign the permission to appropriate roles
4. Run the seeder to update the database

To create new roles:

1. Add the role to the `AdminRoleSeeder`
2. Define the permission assignments in the `assignPermissionsToRoles()` method
3. Run the seeder to create the new role

## Security Notes

- Super Administrator role should be assigned carefully
- System roles (`is_system_role = true`) cannot be deleted
- Always use permission checks in both controllers and views
- Regular permission audits are recommended
- Consider implementing permission inheritance for complex scenarios

## Maintenance

- Regularly review and update permissions based on new features
- Remove unused permissions to keep the system clean
- Monitor role assignments and ensure they align with organizational needs
- Keep permission descriptions up-to-date for better documentation
