<?php

namespace Modules\AdminTeam\App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\AdminTeam\Database\factories\AdminRoleFactory;

class AdminRole extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'display_name',
        'description',
        'status',
        'is_system_role',
    ];

    /**
     * Get the permissions for this role.
     */
    public function permissions()
    {
        return $this->belongsToMany(
            AdminPermissionList::class,
            'admin_role_permissions',
            'admin_role_id',
            'admin_permission_id'
        );
    }

    /**
     * Get the admins assigned to this role.
     */
    public function admins()
    {
        return $this->belongsToMany(
            \App\Models\Admin::class,
            'admin_role_assignments',
            'admin_role_id',
            'admin_id'
        );
    }

}
