<?php

namespace Modules\AdminTeam\App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\AdminTeam\Database\factories\AdminPermissionListFactory;

class AdminPermissionList extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $fillable = [
        'name',
        'display_name',
        'module',
        'description',
        'parent_id',
        'is_group',
        'status',
    ];

    /**
     * Get the parent permission group.
     */
    public function parent()
    {
        return $this->belongsTo(AdminPermissionList::class, 'parent_id');
    }

    /**
     * Get the child permissions.
     */
    public function children()
    {
        return $this->hasMany(AdminPermissionList::class, 'parent_id');
    }

    /**
     * Get the roles that have this permission.
     */
    public function roles()
    {
        return $this->belongsToMany(
            AdminRole::class,
            'admin_role_permissions',
            'admin_permission_id',
            'admin_role_id'
        );
    }

}
