<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\HomeController;
use App\Http\Controllers\API\PaymentController;
use App\Http\Controllers\API\Auth\LoginController;


use App\Http\Controllers\API\Auth\RegisterController;
use App\Http\Controllers\API\Buyer\ProfileController as BuyerProfileController;

use App\Http\Controllers\API\Seller\ProfileController as SellerProfileController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/



Route::group(['middleware' => [ 'HtmlSpecialchars', 'MaintenanceMode', 'CurrencyLangaugeForAPI']], function () {

    Route::get('/website-setup', [HomeController::class, 'website_setup'])->name('website-setup');
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('/all-categories', [HomeController::class, 'all_categories'])->name('all-categories');
    Route::get('/about-us', [HomeController::class, 'about_us'])->name('about-us');
    Route::get('/contact-us', [HomeController::class, 'contact_us'])->name('contact-us');
    Route::get('/faq', [HomeController::class, 'faq'])->name('faq');

    Route::get('/services', [HomeController::class, 'services'])->name('services');
    Route::get('/service-filter-elements', [HomeController::class, 'service_filter_elements'])->name('service-filter-elements');
    Route::get('/service/{slug}', [HomeController::class, 'service'])->name('service');

    Route::get('/freelancers', [HomeController::class, 'freelancers'])->name('freelancers');
    Route::get('/freelancers-filter-elements', [HomeController::class, 'freelancers_filter_elements'])->name('freelancers-filter-elements');
    Route::get('/freelancer/{username}', [HomeController::class, 'freelancer'])->name('freelancer');

    Route::get('/job-posts', [HomeController::class, 'job_posts'])->name('job-posts');
    Route::get('/job-posts-filter-elements', [HomeController::class, 'job_posts_filter_elements'])->name('job-posts-filter-elements');
    Route::get('/job-post/{slug}', [HomeController::class, 'job_post'])->name('job-post');

    Route::get('/privacy-policy', [HomeController::class, 'privacy_policy'])->name('privacy-policy');
    Route::get('/terms-conditions', [HomeController::class, 'terms_conditions'])->name('terms-conditions');

    Route::get('/download-submission-file/{file_name}', [HomeController::class, 'download_submission_file'])->name('download-submission-file');
    
    Route::get('/slider', [HomeController::class, 'slider'])->name('slider');


    // Login route
    Route::post('/store-login', [LoginController::class, 'store_login'])->name('store-login');

    Route::post('/store-register', [RegisterController::class, 'store_register'])->name('store-register');
    Route::post('/seller/store-register', [RegisterController::class, 'seller_store_register'])->name('seller-store-register');
    Route::post('/resend-register', [RegisterController::class, 'resend_register_code'])->name('resend-register');
    Route::post('/user-verification', [RegisterController::class, 'register_verification'])->name('user-verification');

    Route::post('/send-forget-password', [LoginController::class, 'send_custom_forget_pass'])->name('send-forget-password');
    Route::post('/verify-forget-password-otp', [LoginController::class, 'verify_custom_reset_password'])->name('verify-forget-password-otp');
    Route::post('/store-reset-password', [LoginController::class, 'store_reset_password'])->name('store-reset-password');

    Route::post('/refresh-token', [LoginController::class, 'refresh_token'])->name('refresh-token');
    Route::get('/user-logout', [LoginController::class, 'user_logout'])->name('user.logout');


    // Login route end


    Route::group(['as' => 'payment.', 'prefix' => 'payment', 'middleware' => ['auth:api']], function(){
        Route::get('/pay/{service_package_id}/{package_name}', [PaymentController::class, 'index'])->name('pay');
        Route::post('/stripe/{service_package_id}/{package_name}', [PaymentController::class, 'stirpe_payment'])->name('stripe');
        Route::post('/bank/{service_package_id}/{package_name}', [PaymentController::class, 'bank_payment'])->name('bank');
        Route::post('/wallet/{service_package_id}/{package_name}', [PaymentController::class, 'wallet_payment'])->name('wallet');
        Route::post('/razorpay/{service_package_id}/{package_name}', [PaymentController::class, 'razorpay_payment'])->name('razorpay');


        Route::get('/paypal/{service_package_id}/{package_name}', [PaymentController::class, 'paypal_payment'])->name('paypal');
        Route::get('/paypal-success-payment', [PaymentController::class, 'paypal_success_payment'])->name('paypal-success-payment');
        Route::get('/paypal-faild-payment', [PaymentController::class, 'paypal_faild_payment'])->name('paypal-faild-payment');

        Route::post('/razorpay/{service_package_id}/{package_name}', [PaymentController::class, 'razorpay_payment'])->name('razorpay');

        Route::post('/flutterwave/{service_package_id}/{package_name}', [PaymentController::class, 'flutterwave_payment'])->name('flutterwave');

        Route::get('/mollie/{service_package_id}/{package_name}', [PaymentController::class, 'mollie_payment'])->name('mollie');
        Route::get('/mollie-callback', [PaymentController::class, 'mollie_callback'])->name('mollie-callback');

        Route::post('/paystack/{service_package_id}/{package_name}', [PaymentController::class, 'paystack_payment'])->name('paystack');

        Route::get('/instamojo/{service_package_id}/{package_name}', [PaymentController::class, 'instamojo_payment'])->name('instamojo');
        Route::get('/instamojo-callback', [PaymentController::class, 'instamojo_callback'])->name('instamojo-callback');

    });


    Route::group(['as' => 'buyer.', 'prefix' => 'buyer'], function(){

        Route::group(['middleware' => 'auth:api'],function () {

            Route::get('/dashboard', [BuyerProfileController::class, 'dashboard'])->name('dashboard');

            Route::get('/edit-profile', [BuyerProfileController::class, 'edit_profile'])->name('edit-profile');
            Route::put('/update-profile', [BuyerProfileController::class, 'update_profile'])->name('update-profile');
            Route::put('/update-avatar', [BuyerProfileController::class, 'update_avatar'])->name('update-avatar');

            Route::put('/update-password', [BuyerProfileController::class, 'update_password'])->name('update-password');

            Route::delete('/account-delete', [BuyerProfileController::class, 'account_delete'])->name('account-delete');

            Route::get('/orders', [BuyerProfileController::class, 'orders'])->name('orders');
            Route::get('/order/{order_id}', [BuyerProfileController::class, 'order_show'])->name('order');

            Route::post('/order-complete/{id}', [BuyerProfileController::class, 'order_complete'])->name('order-complete');
            Route::post('/order-cancel/{id}', [BuyerProfileController::class, 'order_cancel'])->name('order-cancel');

            Route::post('/store-review/{order_id}', [BuyerProfileController::class, 'store_review'])->name('store-review');

        });





    });


    Route::group(['as' => 'seller.', 'prefix' => 'seller'], function(){

        Route::group(['middleware' => 'auth:api'],function () {

            Route::get('/dashboard', [SellerProfileController::class, 'dashboard'])->name('dashboard');

            Route::get('/edit-profile', [SellerProfileController::class, 'edit_profile'])->name('edit-profile');
            Route::put('/update-profile', [SellerProfileController::class, 'update_profile'])->name('update-profile');
            Route::put('/update-avatar', [BuyerProfileController::class, 'update_avatar'])->name('update-avatar');

            Route::put('/update-password', [SellerProfileController::class, 'update_password'])->name('update-password');


            Route::delete('/account-delete', [SellerProfileController::class, 'account_delete'])->name('account-delete');

            Route::get('/orders', [SellerProfileController::class, 'orders'])->name('orders');
            Route::get('/order/{order_id}', [SellerProfileController::class, 'order_show'])->name('order');

            Route::post('/order-approved/{id}', [SellerProfileController::class, 'order_approved'])->name('order-approved');
            Route::post('/order-rejected/{id}', [SellerProfileController::class, 'order_rejected'])->name('order-rejected');
            Route::post('/order-cancel/{id}', [SellerProfileController::class, 'order_cancel'])->name('order-cancel');
            Route::post('/order-submission/{id}', [SellerProfileController::class, 'order_submission'])->name('order-submission');

            Route::post('/online-status', [SellerProfileController::class, 'updateStatus'])->name('online-status');


        });





    });

});
