<?php

use Illuminate\Http\Request;
use Modules\JobPost\Http\Controllers\API\Buyer\JobPostController as BuyerJobPostController;
use Modules\JobPost\Http\Controllers\API\Seller\JobPostController as SellerJobPostController;


Route::group(['middleware' => ['auth:api', 'HtmlSpecialchars', 'CurrencyLangaugeForAPI']], function () {

    Route::group(['as'=> 'buyer.', 'prefix' => 'buyer'],function (){

        Route::resource('jobpost', BuyerJobPostController::class);

        Route::post('/jobpost-thumbnail', [BuyerJobPostController::class,  'jobpost_thumbnail'])->name('jobpost-thumbnail');

        Route::get('/job-post-applicants/{id}', [BuyerJobPostController::class,  'job_post_applicants'])->name('job-post-applicants');
        Route::put('/job-application-approval/{id}', [BuyerJobPostController::class,  'job_application_approval'])->name('job-application-approval');

    });
});



Route::group(['middleware' => ['auth:api', 'HtmlSpecialchars', 'MaintenanceMode', 'CurrencyLangaugeForAPI']], function () {

    Route::group(['as'=> 'seller.', 'prefix' => 'seller'],function (){

        Route::get('/my-applicants', [SellerJobPostController::class,  'index'])->name('my-applicants');
        Route::get('/my-applicant/{id}', [SellerJobPostController::class,  'show'])->name('my-applicant');
        Route::post('/apply-job/{id}', [SellerJobPostController::class,  'apply_job'])->name('apply-job');

    });
});

