<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Edit Service')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Edit Service')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Manage Service')); ?> >> <?php echo e(__('translate.Edit Service')); ?></p>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-content'); ?>

<!-- crancy Dashboard -->
<section class="crancy-adashboard crancy-show">
    <div class="container container__bscreen">
        <div class="row">
            <div class="col-12">
                <div class="crancy-body">
                    <!-- Dashboard Inner -->
                    <div class="crancy-dsinner">
                        <div class="row">
                            <div class="col-12 mg-top-30">
                                <!-- Product Card -->
                                <div class="crancy-product-card translation_main_box">

                                    <div class="crancy-customer-filter">
                                        <div class="crancy-customer-filter__single crancy-customer-filter__single--csearch">
                                            <div class="crancy-header__form crancy-header__form--customer">
                                                <h4 class="crancy-product-card__title"><?php echo e(__('translate.Switch to language translation')); ?></h4>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="translation_box">
                                        <ul >
                                            <?php $__currentLoopData = $language_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><a href="<?php echo e(route('admin.listings.edit', ['listing' => $listing->id, 'lang_code' => $language->lang_code] )); ?>">
                                                <?php if(request()->get('lang_code') == $language->lang_code): ?>
                                                    <i class="fas fa-eye"></i>
                                                <?php else: ?>
                                                    <i class="fas fa-edit"></i>
                                                <?php endif; ?>

                                                <?php echo e($language->lang_name); ?></a></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>

                                        <div class="alert alert-secondary" role="alert">

                                            <?php
                                                $edited_language = $language_list->where('lang_code', request()->get('lang_code'))->first();
                                            ?>

                                        <p><?php echo e(__('translate.Your editing mode')); ?> : <b><?php echo e($edited_language->lang_name); ?></b></p>
                                        </div>
                                    </div>

                                </div>
                                <!-- End Product Card -->
                            </div>
                        </div>
                    </div>
                    <!-- End Dashboard Inner -->
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End crancy Dashboard -->

    <form action="<?php echo e(route('admin.listings.update', $listing->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <input type="hidden" name="lang_code" value="<?php echo e($listing_translate->lang_code); ?>">
        <input type="hidden" name="translate_id" value="<?php echo e($listing_translate->id); ?>">

    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <div class="row">
                                <div class="col-12">
                                    <!-- Product Card -->
                                    <div class="crancy-product-card">
                                        <div class="create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title"><?php echo e(__('translate.Basic Information')); ?></h4>
                                        </div>

                                        <div class="row">

                                            <?php if(admin_lang() == request()->get('lang_code')): ?>
                                            <div class="col-12 mg-top-form-20">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="crancy__item-form--group w-100 h-100">
                                                            <label class="crancy__item-label"><?php echo e(__('translate.Thumbnail Image')); ?> </label>
                                                            <div class="crancy-product-card__upload crancy-product-card__upload--border">
                                                                <input type="file" class="btn-check" name="thumb_image" id="input-img1" autocomplete="off" onchange="previewImage(event)">
                                                                <label class="crancy-image-video-upload__label" for="input-img1">
                                                                    <img id="view_img" src="<?php echo e(asset($listing->thumb_image)); ?>">
                                                                    <h4 class="crancy-image-video-upload__title"><?php echo e(__('translate.Click here to')); ?> <span class="crancy-primary-color"><?php echo e(__('translate.Choose File')); ?></span> <?php echo e(__('translate.and upload')); ?> </h4>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>

                                            <div class="col-md-12">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Seller')); ?> * </label>
                                                    <select class="form-select crancy__item-input " name="seller_id">
                                                        <option value=""><?php echo e(__('translate.Select Seller')); ?></option>
                                                        <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option  <?php echo e($agent->id == $listing->seller_id ? 'selected' : ''); ?> value="<?php echo e($agent->id); ?>"><?php echo e($agent->name); ?> - <?php echo e($agent->email); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <?php endif; ?>

                                            <div class="<?php echo e(admin_lang() == request()->get('lang_code') ? 'col-md-6' : 'col-12'); ?>">

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Title')); ?> * </label>
                                                    <input class="crancy__item-input" type="text" name="title" id="title" value="<?php echo e(html_decode($listing_translate->title)); ?>">
                                                </div>
                                            </div>


                                            <?php if(admin_lang() == request()->get('lang_code')): ?>
                                            <div class="col-md-6">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Slug')); ?> * </label>
                                                    <input class="crancy__item-input" type="text" name="slug" id="slug" value="<?php echo e(html_decode($listing->slug)); ?>">
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Category')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="category_id" id="category-select">
                                                        <option value=""><?php echo e(__('translate.Select Category')); ?></option>
                                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option  <?php echo e($category->id == $listing->category_id ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->translate->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Subcategory')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="sub_category_id" id="subcategory-select">
                                                        <option value=""><?php echo e(__('translate.Select Subcategory')); ?></option>
                                                    </select>
                                                </div>
                                            </div>

                                            <?php endif; ?>

                                            <div class="col-12">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Description')); ?> * </label>

                                                    <textarea class="crancy__item-input crancy__item-textarea summernote"  name="description" id="description"><?php echo html_decode($listing_translate->description); ?></textarea>

                                                </div>
                                            </div>

                                        </div>

                                        <?php if(admin_lang() != request()->get('lang_code')): ?>
                                        <button class="crancy-btn mg-top-25" type="submit"><?php echo e(__('translate.Update Data')); ?></button>
                                        <?php endif; ?>

                                    </div>
                                    <!-- End Product Card -->
                                </div>
                            </div>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->


    <?php if(admin_lang() == request()->get('lang_code')): ?>
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <div class="row">
                                <div class="col-12">
                                    <!-- Product Card -->
                                    <div class="crancy-product-card">
                                        <div class="create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title"><?php echo e(__('translate.Pricing Package')); ?></h4>
                                        </div>

                                        <div class="row">

                                            <div class="col-md-4">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Package Name')); ?> * </label>
                                                    <input class="crancy__item-input" type="text" name="basic_name" id="basic_name" value="<?php echo e(__(('Basic'))); ?>" readonly>
                                                </div>


                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Description')); ?> *</label>
                                                    <textarea class="crancy__item-input crancy__item-textarea seo_description_box"  name="basic_description" id="basic_description" placeholder="<?php echo e(__('translate.Description Here')); ?>"><?php echo e($listing_package->basic_description); ?></textarea>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Delivery Time')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_delivery_date">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=5; $i++): ?>
                                                        <option <?php echo e($listing_package->basic_delivery_date == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?> <?php echo e(__('translate.Days')); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Revision')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_revision">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=5; $i++): ?>
                                                        <option <?php echo e($listing_package->basic_revision == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Functional Website')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_fn_website">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->basic_fn_website == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->basic_fn_website == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Number of Page')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_page">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=10; $i++): ?>
                                                        <option <?php echo e($listing_package->basic_page == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Responsive')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_responsive">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->basic_responsive == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->basic_responsive == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Source Code')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_source_code">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->basic_source_code == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->basic_source_code == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>


                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Content Upload')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_content_upload">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->basic_content_upload == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->basic_content_upload == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Speed Optimized')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="basic_speed_optimized">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->basic_speed_optimized == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->basic_speed_optimized == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Price')); ?> </label>
                                                    <input class="crancy__item-input" type="text" name="basic_price" value="<?php echo e($listing_package->basic_price); ?>">
                                                </div>
                                            </div>


                                            <div class="col-md-4">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Package Name')); ?> * </label>
                                                    <input class="crancy__item-input" type="text" name="standard_name" id="standard_name" value="<?php echo e(__(('Standard'))); ?>" readonly>
                                                </div>


                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Description')); ?> *</label>
                                                    <textarea class="crancy__item-input crancy__item-textarea seo_description_box"  name="standard_description" id="standard_description" placeholder="<?php echo e(__('translate.Description Here')); ?>"><?php echo e($listing_package->standard_description); ?></textarea>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Delivery Time')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_delivery_date">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=5; $i++): ?>
                                                        <option <?php echo e($listing_package->standard_delivery_date == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?> <?php echo e(__('translate.Days')); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Revision')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_revision">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=5; $i++): ?>
                                                        <option <?php echo e($listing_package->standard_revision == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Functional Website')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_fn_website">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->standard_fn_website == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->standard_fn_website == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Number of Page')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_page">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=10; $i++): ?>
                                                        <option <?php echo e($listing_package->standard_page == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Responsive')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_responsive">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->standard_responsive == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->standard_responsive == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Source Code')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_source_code">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->standard_source_code == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->standard_source_code == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>


                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Content Upload')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_content_upload">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->standard_content_upload == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->standard_content_upload == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Speed Optimized')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="standard_speed_optimized">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->standard_speed_optimized == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->standard_speed_optimized == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Price')); ?> </label>
                                                    <input class="crancy__item-input" type="text" name="standard_price" value="<?php echo e($listing_package->standard_price); ?>">
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Package Name')); ?> * </label>
                                                    <input class="crancy__item-input" type="text" name="premium_name" id="premium_name" value="<?php echo e(__(('Premium'))); ?>" readonly>
                                                </div>


                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Description')); ?> *</label>
                                                    <textarea class="crancy__item-input crancy__item-textarea seo_description_box"  name="premium_description" id="premium_description" placeholder="<?php echo e(__('translate.Description Here')); ?>"><?php echo e($listing_package->premium_description); ?></textarea>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Delivery Time')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_delivery_date">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=5; $i++): ?>
                                                        <option <?php echo e($listing_package->premium_delivery_date == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?> <?php echo e(__('translate.Days')); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Revision')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_revision">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=5; $i++): ?>
                                                        <option <?php echo e($listing_package->premium_revision == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Functional Website')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_fn_website">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->premium_fn_website == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->premium_fn_website == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Number of Page')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_page">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <?php for($i = 1; $i<=10; $i++): ?>
                                                        <option <?php echo e($listing_package->premium_page == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                                        <?php endfor; ?>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Responsive')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_responsive">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->premium_responsive == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->premium_responsive == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Source Code')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_source_code">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->premium_source_code == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->premium_source_code == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>


                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Content Upload')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_content_upload">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->premium_content_upload == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->premium_content_upload == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label">
                                                        <?php echo e(__('translate.Speed Optimized')); ?> * </label>
                                                    <select class="form-select crancy__item-input" name="premium_speed_optimized">
                                                        <option value=""><?php echo e(__('translate.Select')); ?></option>
                                                        <option <?php echo e($listing_package->premium_speed_optimized == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                                                        <option <?php echo e($listing_package->premium_speed_optimized == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>
                                                    </select>
                                                </div>

                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Price')); ?> </label>
                                                    <input class="crancy__item-input" type="text" name="premium_price" value="<?php echo e($listing_package->premium_price); ?>">
                                                </div>
                                            </div>


                                        </div>

                                    </div>
                                    <!-- End Product Card -->
                                </div>
                            </div>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
    <?php endif; ?>

    <?php if(admin_lang() == request()->get('lang_code')): ?>
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <div class="row">
                                <div class="col-12">
                                    <!-- Product Card -->
                                    <div class="crancy-product-card">
                                        <div class="create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title"><?php echo e(__('translate.SEO Information')); ?></h4>
                                        </div>

                                        <div class="row">

                                            <div class="col-12">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.Tags')); ?> </label>
                                                    <input class="crancy__item-input tags" type="text" name="tags" value="<?php echo e(html_decode($listing->tags)); ?>">
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.SEO title')); ?> </label>
                                                    <input class="crancy__item-input" type="text" name="seo_title" id="seo_title" value="<?php echo e(html_decode($listing->seo_title)); ?>">
                                                </div>
                                            </div>

                                            <div class="col-12">
                                                <div class="crancy__item-form--group mg-top-form-20">
                                                    <label class="crancy__item-label"><?php echo e(__('translate.SEO Description')); ?> </label>
                                                    <textarea class="crancy__item-input crancy__item-textarea seo_description_box"  name="seo_description" id="seo_description"><?php echo e(html_decode($listing->seo_description)); ?></textarea>
                                                </div>
                                            </div>

                                        </div>

                                        <button class="crancy-btn mg-top-25" type="submit"><?php echo e(__('translate.Update Data')); ?></button>

                                        <?php if($listing->approved_by_admin == 'pending'): ?>
                                            <button class="crancy-btn mg-top-25 approval_button" type="button" data-bs-toggle="modal" data-bs-target="#approvalModal"><?php echo e(__('translate.Make Approval')); ?></button>
                                        <?php endif; ?>

                                        <?php if($listing->is_featured == 'disable'): ?>
                                            <button class="crancy-btn mg-top-25 approval_featured" type="button" data-bs-toggle="modal" data-bs-target="#featureModal"><?php echo e(__('translate.Make Featured')); ?></button>
                                        <?php else: ?>
                                            <button class="crancy-btn mg-top-25 delete_danger_btn" type="button" data-bs-toggle="modal" data-bs-target="#removeFeatureModal"><?php echo e(__('translate.Remove Featured')); ?></button>
                                        <?php endif; ?>

                                    </div>
                                    <!-- End Product Card -->
                                </div>
                            </div>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
    <?php endif; ?>


    </form>


    <!-- Approved Confirmation Modal -->
    <div class="modal fade" id="approvalModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.Approval Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to approved this item?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="<?php echo e(route('admin.listings-approval', $listing->id)); ?>" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Approved')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Featured Confirmation Modal -->
    <div class="modal fade" id="featureModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.Featured Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to featured this item?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="<?php echo e(route('admin.listings-featured', $listing->id)); ?>" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Featured')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Featured Remove Confirmation Modal -->
    <div class="modal fade" id="removeFeatureModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.Featured Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to removed featured this item?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="<?php echo e(route('admin.listings-featured-removed', $listing->id)); ?>" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Removed')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>








<?php $__env->stopSection(); ?>


<?php $__env->startPush('style_section'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('global/tagify/tagify.css')); ?>">
    <style>
        .tox .tox-promotion,
        .tox-statusbar__branding{
            display: none !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js_section'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var categorySelect = document.getElementById('category-select');
            var subcategorySelect = document.getElementById('subcategory-select');

            // Populate the subcategory dropdown if editing a listing
            var selectedCategoryId = categorySelect.value;
            var selectedSubCategoryId = '<?php echo e($listing->sub_category_id); ?>'; // Get the selected subcategory ID from the listing

            if (selectedCategoryId) {
                // Make an AJAX request to fetch subcategories
                fetch("<?php echo e(url('/admin/listing/get-subcategories')); ?>/" + selectedCategoryId)
                    .then(response => response.json())
                    .then(data => {
                        // Populate the subcategory dropdown
                        data.forEach(function(subcategory) {
                            var option = document.createElement('option');
                            option.value = subcategory.id;

                            // Handle missing translation gracefully
                            var subcategoryName = subcategory.translate ? subcategory.translate.name : 'No Name Available';
                            option.textContent = subcategoryName;

                            // Check if this subcategory is the selected one
                            if (subcategory.id == selectedSubCategoryId) {
                                option.selected = true;
                            }

                            subcategorySelect.appendChild(option);
                        });
                    })
                    .catch(error => console.error('Error fetching subcategories:', error));
            }

            // Load subcategories on category change
            categorySelect.addEventListener('change', function() {
                var categoryId = this.value;

                // Clear the subcategory dropdown
                subcategorySelect.innerHTML = '<option value=""><?php echo e(__('translate.Select Subcategory')); ?></option>';

                if (categoryId) {
                    // Make an AJAX request to fetch subcategories
                    fetch("<?php echo e(url('/admin/listing/get-subcategories')); ?>/" + categoryId)
                        .then(response => response.json())
                        .then(data => {
                            // Populate the subcategory dropdown
                            data.forEach(function(subcategory) {
                                var option = document.createElement('option');
                                option.value = subcategory.id;

                                // Handle missing translation gracefully
                                var subcategoryName = subcategory.translate ? subcategory.translate.name : 'No Name Available';
                                option.textContent = subcategoryName;

                                subcategorySelect.appendChild(option);
                            });
                        })
                        .catch(error => console.error('Error fetching subcategories:', error));
                }
            });
        });


    </script>

    <script src="<?php echo e(asset('global/tinymce/js/tinymce/tinymce.min.js')); ?>"></script>


    <script src="<?php echo e(asset('global/tagify/tagify.js')); ?>"></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function () {
                $("#title").on("keyup",function(e){
                    let inputValue = $(this).val();
                    let slug = inputValue.toLowerCase().replace(/[^\w ]+/g,'').replace(/ +/g,'-');
                    $("#slug").val(slug);
                })

                tinymce.init({
                    selector: '.summernote',
                    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
                    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
                    tinycomments_mode: 'embedded',
                    tinycomments_author: 'Author name',
                    mergetags_list: [
                        { value: 'First.Name', title: 'First Name' },
                        { value: 'Email', title: 'Email' },
                    ]
                });

                $('.tags').tagify();

            });
        })(jQuery);

        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };

    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\workzone_laravel\Modules/Listing\Resources/views/edit.blade.php ENDPATH**/ ?>