<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Seller || Create Service')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('front-content'); ?>
<main class="dashboard-main min-vh-100">
    <div class="d-flex flex-column gap-4 pb-110">
      <!-- Header -->
      <div>
        <h3 class="text-24 fw-bold text-dark-300 mb-2"><?php echo e(__('translate.Create Service')); ?></h3>
        <ul class="d-flex align-items-center gap-2">
          <li class="text-dark-200 fs-6"><?php echo e(__('translate.Dashboard')); ?></li>
          <li>
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="5"
              height="11"
              viewBox="0 0 5 11"
              fill="none"
            >
              <path
                d="M1 10L4 5.5L1 1"
                stroke="#5B5B5B"
                stroke-width="1.2"
                stroke-linecap="round"
                stroke-linejoin="round"
              />
            </svg>
          </li>
          <li class="text-lime-300 fs-6"><?php echo e(__('translate.Create Service')); ?></li>
        </ul>
      </div>
      <!-- Content -->
      <div>
        <div class="row justify-content-center">
          <div class="col-xl-8">
            <form method="POST" enctype="multipart/form-data" action="<?php echo e(route('seller.listing.store')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="seller_id" value="<?php echo e(Auth::guard('web')->user()->id); ?>">
              <div class="d-flex flex-column gap-4">
                <!-- Project Info -->
                <div class="gig-info-card">
                  <!-- Header -->
                  <div class="gig-info-header">
                    <h4 class="text-18 fw-semibold text-dark-300">
                      <?php echo e(__('translate.Basic Info')); ?>

                    </h4>
                  </div>
                  <div class="gig-info-body bg-white">
                    <div class="row g-4">
                      <div class="col-12">
                        <div class="form-container">
                          <label for="title" class="form-label"
                            ><?php echo e(__('translate.Title')); ?>*</label
                          >
                          <input
                            type="text"
                            class="form-control shadow-none"
                            placeholder="<?php echo e(__('translate.Title')); ?>"
                            name="title"
                            value="<?php echo e(old('title')); ?>"
                            id="title"
                          />
                        </div>
                      </div>

                      <div class="col-12">
                        <div class="form-container">
                          <label for="slug" class="form-label"
                            ><?php echo e(__('translate.Slug')); ?>*</label
                          >
                          <input
                            type="text"
                            class="form-control shadow-none"
                            placeholder="<?php echo e(__('translate.Slug')); ?>"
                            name="slug"
                            value="<?php echo e(old('slug')); ?>"
                            id="slug"
                          />
                        </div>
                      </div>


                      <div class="col-12">
                        <div class="form-container">
                          <label for="category" class="form-label"
                            ><?php echo e(__('translate.Category')); ?>*</label>
                          <select
                            id="category-select"
                            autocomplete="off"
                            class="form-select shadow-none"
                            name="category_id">
                            <option value=""><?php echo e(__('translate.Select Category')); ?></option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option  <?php echo e($category->id == old('category_id') ? 'selected' : ''); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->translate->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </select>
                        </div>
                      </div>

                      <div class="col-12">
                        <div class="form-container">
                          <label for="category" class="form-label"
                            ><?php echo e(__('translate.Subcategory')); ?>*</label>
                          <select
                           id="subcategory-select"
                            autocomplete="off"
                            class="form-select shadow-none"
                            name="sub_category_id">
                            <option value=""><?php echo e(__('translate.Select Subcategory')); ?></option>
                          </select>
                        </div>
                      </div>

                      <div class="col-12">
                        <label for="description" class="form-label"
                          ><?php echo e(__('translate.Description')); ?>*</label
                        >

                        <textarea class="crancy__item-input crancy__item-textarea summernote"  name="description" id="description"><?php echo e(old('description')); ?></textarea>

                      </div>
                    </div>
                  </div>
                </div>

                <!-- Pricing Package -->
                <div class="gig-info-card">
                  <!-- Header -->
                  <div class="gig-info-header">
                    <h4 class="text-18 fw-semibold text-dark-300">
                      <?php echo e(__('translate.Pricing Package')); ?>

                    </h4>
                  </div>
                  <div class="gig-info-body bg-white">
                    <div class="row g-0 price-pack-wrapper">
                      <div class="col-md-4">
                        <div class="gig-pricing-pack border-end">
                          <div class="p-2 ps-3 border-bottom">
                            <span class="pricing-pack-name"><?php echo e(__('translate.Basic')); ?></span>
                          </div>
                          <div class="pack-description border-bottom">
                            <textarea
                              class="border-0 px-3 w-100 shadow-none form-control"
                              placeholder="<?php echo e(__('translate.Description Here')); ?>"
                              rows="3"
                              name="basic_description"
                            ><?php echo e(old('basic_description')); ?></textarea>
                          </div>
                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_delivery_date"
                            >
                              <option value="">
                                <?php echo e(__('translate.Select Delivery Time')); ?>

                              </option>
                              <?php for($i = 1; $i<=5; $i++): ?>
                              <option <?php echo e(old('basic_delivery_date') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>
                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_revision"
                            >
                              <option value=""><?php echo e(__('translate.Revision')); ?></option>
                              <?php for($i = 1; $i<=5; $i++): ?>
                              <option <?php echo e(old('basic_revision') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_fn_website"
                            >
                              <option value=""><?php echo e(__('translate.Functional Website')); ?></option>
                              <option <?php echo e(old('basic_fn_website') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('basic_fn_website') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_page"
                            >
                              <option value=""><?php echo e(__('translate.Number of Page')); ?></option>
                              <?php for($i = 1; $i<=10; $i++): ?>
                              <option <?php echo e(old('basic_page') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_responsive"
                            >
                              <option value=""><?php echo e(__('translate.Responsive')); ?></option>
                              <option <?php echo e(old('basic_responsive') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('basic_responsive') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_source_code"
                            >
                              <option value=""><?php echo e(__('translate.Source Code')); ?></option>
                              <option <?php echo e(old('basic_source_code') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('basic_source_code') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_content_upload"
                            >
                              <option value=""><?php echo e(__('translate.Content Upload')); ?></option>
                              <option <?php echo e(old('basic_content_upload') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('basic_content_upload') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="basic_speed_optimized"
                            >
                              <option value=""><?php echo e(__('translate.Speed Optimized')); ?></option>
                              <option <?php echo e(old('basic_speed_optimized') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('basic_speed_optimized') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="pack-description">
                            <input
                              class="border-0 px-3 w-100 shadow-none form-control"
                              placeholder="<?php echo e(__('translate.Price Here')); ?>"
                              rows="1"
                              name="basic_price"
                              value="<?php echo e(old('basic_price')); ?>"
                            />
                          </div>
                        </div>
                      </div>

                      <div class="col-md-4">
                        <div class="gig-pricing-pack border-end">
                          <div class="p-2 ps-3 border-bottom">
                            <span class="pricing-pack-name"
                              ><?php echo e(__('translate.Standard')); ?></span
                            >
                          </div>

                          <div class="pack-description border-bottom">
                            <textarea
                              class="border-0 px-3 w-100 shadow-none form-control"
                              placeholder="<?php echo e(__('translate.Description Here')); ?>"
                              rows="3"
                              name="standard_description"
                            ><?php echo e(old('standard_description')); ?></textarea>
                          </div>
                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_delivery_date"
                            >
                              <option value="">
                                <?php echo e(__('translate.Select Delivery Time')); ?>

                              </option>
                              <?php for($i = 1; $i<=5; $i++): ?>
                              <option <?php echo e(old('standard_delivery_date') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>
                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_revision"
                            >
                              <option value=""><?php echo e(__('translate.Revision')); ?></option>
                              <?php for($i = 1; $i<=5; $i++): ?>
                              <option <?php echo e(old('standard_revision') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_fn_website"
                            >
                              <option value=""><?php echo e(__('translate.Functional Website')); ?></option>
                              <option <?php echo e(old('standard_fn_website') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('standard_fn_website') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_page"
                            >
                              <option value=""><?php echo e(__('translate.Number of Page')); ?></option>
                              <?php for($i = 1; $i<=10; $i++): ?>
                              <option <?php echo e(old('standard_page') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_responsive"
                            >
                              <option value=""><?php echo e(__('translate.Responsive')); ?></option>
                              <option <?php echo e(old('standard_responsive') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('standard_responsive') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_source_code"
                            >
                              <option value=""><?php echo e(__('translate.Source Code')); ?></option>
                              <option <?php echo e(old('standard_source_code') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('standard_source_code') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_content_upload"
                            >
                              <option value=""><?php echo e(__('translate.Content Upload')); ?></option>
                              <option <?php echo e(old('standard_content_upload') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('standard_content_upload') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="standard_speed_optimized"
                            >
                              <option value=""><?php echo e(__('translate.Speed Optimized')); ?></option>
                              <option <?php echo e(old('standard_speed_optimized') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('standard_speed_optimized') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="pack-description">
                            <input
                              class="border-0 px-3 w-100 shadow-none form-control"
                              placeholder="<?php echo e(__('translate.Price Here')); ?>"
                              rows="1"
                              name="standard_price"
                              value="<?php echo e(old('standard_price')); ?>"
                            />
                          </div>


                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="gig-pricing-pack">
                          <div class="p-2 ps-3 border-bottom">
                            <span class="pricing-pack-name"><?php echo e(__('translate.Premium')); ?></span>
                          </div>


                          <div class="pack-description border-bottom">
                            <textarea
                              class="border-0 px-3 w-100 shadow-none form-control"
                              placeholder="<?php echo e(__('translate.Description Here')); ?>"
                              rows="3"
                              name="premium_description"
                            ><?php echo e(old('premium_description')); ?></textarea>
                          </div>
                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_delivery_date"
                            >
                              <option value="">
                                <?php echo e(__('translate.Select Delivery Time')); ?>

                              </option>
                              <?php for($i = 1; $i<=5; $i++): ?>
                              <option <?php echo e(old('premium_delivery_date') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>
                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_revision"
                            >
                              <option value=""><?php echo e(__('translate.Revision')); ?></option>
                              <?php for($i = 1; $i<=5; $i++): ?>
                              <option <?php echo e(old('premium_revision') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_fn_website"
                            >
                              <option value=""><?php echo e(__('translate.Functional Website')); ?></option>
                              <option <?php echo e(old('premium_fn_website') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('premium_fn_website') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_page"
                            >
                              <option value=""><?php echo e(__('translate.Number of Page')); ?></option>
                              <?php for($i = 1; $i<=10; $i++): ?>
                              <option <?php echo e(old('premium_page') == $i ? 'selected' : ''); ?> value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                              <?php endfor; ?>
                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_responsive"
                            >
                              <option value=""><?php echo e(__('translate.Responsive')); ?></option>
                              <option <?php echo e(old('premium_responsive') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('premium_responsive') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_source_code"
                            >
                              <option value=""><?php echo e(__('translate.Source Code')); ?></option>
                              <option <?php echo e(old('premium_source_code') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('premium_source_code') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_content_upload"
                            >
                              <option value=""><?php echo e(__('translate.Content Upload')); ?></option>
                              <option <?php echo e(old('premium_content_upload') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('premium_content_upload') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="p-2 ps-3 border-bottom">
                            <select
                              id=""
                              class="form-select p-0 border-0 shadow-none"
                              name="premium_speed_optimized"
                            >
                              <option value=""><?php echo e(__('translate.Speed Optimized')); ?></option>
                              <option <?php echo e(old('premium_speed_optimized') == 'yes' ? 'selected' : ''); ?> value="yes"><?php echo e(__('translate.Yes')); ?></option>
                              <option <?php echo e(old('premium_speed_optimized') == 'no' ? 'selected' : ''); ?> value="no"><?php echo e(__('translate.No')); ?></option>

                            </select>
                          </div>

                          <div class="pack-description">
                            <input
                              class="border-0 px-3 w-100 shadow-none form-control"
                              placeholder="<?php echo e(__('translate.Price Here')); ?>"
                              rows="1"
                              name="premium_price"
                              value="<?php echo e(old('premium_price')); ?>"
                            />
                          </div>


                        </div>
                      </div>
                    </div>
                  </div>
                </div>

                <!-- Upload Gig Img -->
                <div class="gig-info-card">
                  <!-- Header -->
                  <div class="gig-info-header">
                    <h4 class="text-18 fw-semibold text-dark-300">
                      <?php echo e(__('translate.Upload Thumbnail')); ?>

                    </h4>
                  </div>
                  <div class="gig-info-body bg-white">
                    <p class="text-dark-200 mb-2"><?php echo e(__('translate.Thumbnail Image')); ?> *</p>
                    <div class="d-flex flex-wrap gap-3">
                      <div>
                        <label
                          for="gig-img"
                          class="border text-center gig-file-upload"
                        >
                          <img
                          id="view_img"
                             class="gig-img-icon"
                            src="<?php echo e(asset($general_setting->placeholder_image)); ?>"
                            alt=""
                          />
                          <p class="text-dark-200"><?php echo e(__('translate.Choose File')); ?></p>
                          <input
                            class="d-none"
                            type="file"
                            name="thumb_image"
                            id="gig-img"
                            onchange="previewImage(event)"
                          />
                        </label>
                      </div>

                    </div>
                  </div>
                </div>


                <!-- Project Info -->
                <div class="gig-info-card">
                    <!-- Header -->
                    <div class="gig-info-header">
                      <h4 class="text-18 fw-semibold text-dark-300">
                        <?php echo e(__('translate.SEO Information')); ?>

                      </h4>
                    </div>
                    <div class="gig-info-body bg-white">
                      <div class="row g-4">

                        <div class="col-12">
                            <div class="form-container">
                              <label for="tags" class="form-label"
                                ><?php echo e(__('translate.Tags')); ?></label
                              >
                              <input
                                type="text"
                                class="form-control shadow-none tags"
                                placeholder="<?php echo e(__('translate.Tags')); ?>"
                                name="tags"
                                value="<?php echo e(old('tags')); ?>"
                                id="tags"
                              />
                            </div>
                          </div>


                        <div class="col-12">
                          <div class="form-container">
                            <label for="seo_title" class="form-label"
                              ><?php echo e(__('translate.SEO Title')); ?></label
                            >
                            <input
                              type="text"
                              class="form-control shadow-none"
                              placeholder="<?php echo e(__('translate.SEO Title')); ?>"
                              name="seo_title"
                              value="<?php echo e(old('seo_title')); ?>"
                              id="seo_title"
                            />
                          </div>
                        </div>

                        <div class="col-12">
                          <div class="form-container">
                            <label for="seo_description" class="form-label"
                              ><?php echo e(__('translate.SEO Description')); ?></label
                            >
                            <textarea rows="5" class="form-control shadow-none" name="seo_description" id="" cols="30" rows="10" placeholder="<?php echo e(__('translate.SEO Description')); ?>"><?php echo e(old('seo_description')); ?></textarea>
                          </div>
                        </div>



                      </div>
                    </div>
                  </div>


                <!-- Submit Btn -->
                <div>
                  <button class="w-btn-secondary-lg">
                    <?php echo e(__('translate.Publish Now')); ?>

                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="14"
                      height="10"
                      viewBox="0 0 14 10"
                      fill="none"
                    >
                      <path
                        d="M9 9L13 5M13 5L9 1M13 5L1 5"
                        stroke="white"
                        stroke-width="1.5"
                        stroke-linecap="round"
                        stroke-linejoin="round"
                      />
                    </svg>
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </main>
<?php $__env->stopSection(); ?>





<?php $__env->startPush('style_section'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('global/tagify/tagify.css')); ?>">
    <style>
        .tox .tox-promotion,
        .tox-statusbar__branding{
            display: none !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js_section'); ?>
    <script>
        document.getElementById('category-select').addEventListener('change', function() {
            var categoryId = this.value;
            var subcategorySelect = document.getElementById('subcategory-select');

            // Clear the subcategory dropdown
            subcategorySelect.innerHTML = '<option value=""><?php echo e(__('translate.Select Subcategory')); ?></option>';

            if (categoryId) {
                // Make an AJAX request to fetch subcategories
                fetch("<?php echo e(url('/seller/get-subcategories')); ?>/" + categoryId)
                    .then(response => response.json())
                    .then(data => {
                        // Populate the subcategory dropdown
                        data.forEach(function(subcategory) {
                            var option = document.createElement('option');
                            option.value = subcategory.id;

                            // Handle missing translation gracefully
                            var subcategoryName = subcategory.translate ? subcategory.translate.name : 'No Name Available';
                            option.textContent = subcategoryName;

                            subcategorySelect.appendChild(option);
                        });
                    })
                    .catch(error => console.error('Error fetching subcategories:', error));
            }
        });

    </script>

    <script src="<?php echo e(asset('global/tinymce/js/tinymce/tinymce.min.js')); ?>"></script>

    <script src="<?php echo e(asset('global/tagify/tagify.js')); ?>"></script>

    <script>
        (function($) {
            "use strict"
            $(document).ready(function () {
                $("#title").on("keyup",function(e){
                    let inputValue = $(this).val();
                    let slug = inputValue.toLowerCase().replace(/[^\w ]+/g,'').replace(/ +/g,'-');
                    $("#slug").val(slug);
                })

                $('.tags').tagify();

                tinymce.init({
                    selector: '.summernote',
                    plugins: 'anchor autolink charmap codesample emoticons image link lists media searchreplace table visualblocks wordcount',
                    toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
                    tinycomments_mode: 'embedded',
                    tinycomments_author: 'Author name',
                    mergetags_list: [
                        { value: 'First.Name', title: 'First Name' },
                        { value: 'Email', title: 'Email' },
                    ]
                });

            });
        })(jQuery);

        function previewImage(event) {
            var reader = new FileReader();
            reader.onload = function(){
                var output = document.getElementById('view_img');
                output.src = reader.result;
            }

            reader.readAsDataURL(event.target.files[0]);
        };

    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('seller.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Projects\workzone_laravel\Modules/Listing\Resources/views/seller/create.blade.php ENDPATH**/ ?>