@extends('buyer.layout')
@section('title')
    <title>{{ __('translate.Buyer || Account Delete') }}</title>
@endsection
@section('front-content')
<main class="dashboard-main min-vh-100">
    <div class="d-flex flex-column gap-4">
      <!-- Header -->
      <div>
        <h3 class="text-24 fw-bold text-dark-300 mb-2">{{ __('translate.Account Delete') }}</h3>
        <ul class="d-flex align-items-center gap-2">
          <li class="text-dark-200 fs-6">{{ __('translate.Dashboard') }}</li>
          <li>
            <svg
              xmlns="http://www.w3.org/2000/svg"
              width="5"
              height="11"
              viewBox="0 0 5 11"
              fill="none"
            >
              <path
                d="M1 10L4 5.5L1 1"
                stroke="#5B5B5B"
                stroke-width="1.2"
                stroke-linecap="round"
                stroke-linejoin="round"
              />
            </svg>
          </li>
          <li class="text-lime-300 fs-6">{{ __('translate.Account Delete') }}</li>
        </ul>
      </div>
      <!-- Content -->
      <div class="bg-white p-4 p-md-5 rounded-4">
        <div class="row justify-content-center">
          <div class="col-lg-6 mb-4">
            <div>
              <div class="mb-4">
                <h4 class="text-24 fw-bold text-danger mb-3">
                  {{ __('translate.Permanently delete your account?') }}
                </h4>
                <div class="alert alert-danger mb-3">
                  <strong>{{ __('translate.Warning') }}</strong>
                </div>
                <p class="text-dark-200 fs-6 mb-2">
                  {{ __('translate.Once you delete your account, all your data—including orders, services, messages, reviews, and any other information associated exclusively with your account—will be permanently removed and cannot be recovered.') }}
                </p>
                <ul class="list-unstyled mb-3">
                  <li>
                    <strong>{{ __('translate.User Name') }}:</strong>
                    {{ Auth::user()->name ?? '-' }}
                  </li>
                  <li>
                    <strong>{{ __('translate.Email') }}:</strong>
                    {{ Auth::user()->email ?? '-' }}
                  </li>
                </ul>
                <p class="text-dark-200 fs-6">
                  {{ __('translate.Type your email and current password to confirm account deletion.') }}
                </p>
              </div>
              <form method="POST" action="{{ route('buyer.confirm-account-delete') }}" id="delete_account">
                @csrf
                @method('DELETE')
                <div class="d-flex flex-column gap-4">
                  <div class="form-container">
                    <label for="confirm_email" class="form-label">
                      {{ __('translate.Email') }}
                    </label>
                    <div class="position-relative d-flex align-items-center">
                      <input
                        type="email"
                        class="form-control shadow-none"
                        id="confirm_email"
                        name="email"
                        placeholder="{{ __('translate.Enter your email') }}"
                        required
                      />
                    </div>
                  </div>

                  <div class="form-container">
                    <label for="cpass" class="form-label"
                      >{{ __('translate.Password') }}</label
                    >
                    <div
                      class="position-relative d-flex align-items-center"
                    >
                      <input
                        type="password"
                        class="form-control shadow-none"
                        placeholder="*******"
                        name="current_password"
                      />

                    </div>
                  </div>

                  <div class="d-flex gap-3 align-items-center">
                    <button class="w-btn-secondary-lg btn btn-danger" type="submit">
                      {{ __('translate.Delete Account') }}
                    </button>
                    <button type="reset" class="btn btn-link text-danger text-decoration-underline" id="delete_cancel">
                      {{ __('translate.Cancel') }}
                    </button>
                  </div>
                </div>
              </form>
            </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </main>

@endsection


