<?php

use Illuminate\Support\Facades\Route;
use Modules\Wallet\App\Http\Controllers\WalletController;
use Modules\Wallet\App\Http\Controllers\api\WalletController as ApiWalletController;
use Modules\Wallet\App\Http\Controllers\PaymentController;
use Modules\Wallet\App\Http\Controllers\api\PaymentController as ApiPaymentController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

    Route::group(['as' => 'wallet-api-payment.', 'prefix' => 'wallet-api-payment'], function () {
        Route::resource('wallet', ApiWalletController::class)->names('wallet');
        Route::get('/stripe', [ApiPaymentController::class, 'stripe_payment'])->name('stripe');
        Route::post('/stripe-store', [ApiPaymentController::class, 'stripe_payment_store'])->name('stripe-store');
        
        Route::post('/bank', [ApiPaymentController::class, 'bank_payment'])->name('bank');

        Route::get('/paypal-webview', [ApiPaymentController::class, 'paypal_webview'])->name('paypal-webview');
        Route::get('/paypal-webview-success', [ApiPaymentController::class, 'paypal_webview_success'])->name('paypal-webview-success');    
        Route::get('/paypal-webview-faild', [ApiPaymentController::class, 'paypal_webview_faild'])->name('paypal-webview-faild');   
        
        Route::get('/mollie', [ApiPaymentController::class, 'mollie_payment'])->name('mollie');
        Route::get('/mollie-callback', [ApiPaymentController::class, 'mollie_callback'])->name('mollie-callback');

        Route::get('/razorpay-webview', [ApiPaymentController::class, 'razorpay_webview'])->name('razorpay-webview');
        Route::get('/razorpay-webview-success/{wallet_amount}', [ApiPaymentController::class, 'razorpay_webview_success'])->name('razorpay-webview-success');

        Route::get('/flutterwave', [ApiPaymentController::class, 'flutterwave_payment'])->name('flutterwave');
        Route::post('/flutterwave-payment-store/{payable_amount}', [ApiPaymentController::class, 'flutterwave_payment_store'])->name('flutterwave-payment-store');

        Route::get('/paystack', [ApiPaymentController::class, 'paystack_payment'])->name('paystack');
        Route::get('/paystack-store/{payable_amount}', [ApiPaymentController::class, 'paystack_payment_store'])->name('paystack-store');

        Route::get('/instamojo', [ApiPaymentController::class, 'instamojo_payment'])->name('instamojo');
        Route::get('/instamojo-callback', [ApiPaymentController::class, 'instamojo_callback'])->name('instamojo-callback');

    });


Route::group(['as' => 'buyer.', 'prefix' => 'buyer', 'middleware' => ['auth:web', 'HtmlSpecialchars', 'MaintenanceMode']], function () {
    Route::resource('wallet', WalletController::class)->names('wallet');

    Route::group(['as' => 'wallet-payment.', 'prefix' => 'wallet-payment'], function () {

        Route::get('/stripe', [PaymentController::class, 'stripe_payment'])->name('stripe');
        Route::post('/stripe-store', [PaymentController::class, 'stripe_payment_store'])->name('stripe-store');

        Route::get('/bank', [PaymentController::class, 'bank_payment'])->name('bank');
        Route::post('/bank-store', [PaymentController::class, 'bank_payment_store'])->name('bank-store');

        Route::get('/paypal', [PaymentController::class, 'paypal_payment'])->name('paypal');
        Route::get('/paypal-success-payment', [PaymentController::class, 'paypal_success_payment'])->name('paypal-success-payment');
        Route::get('/paypal-faild-payment', [PaymentController::class, 'paypal_faild_payment'])->name('paypal-faild-payment');
        
        Route::get('/mollie', [PaymentController::class, 'mollie_payment'])->name('mollie');
        Route::get('/mollie-callback', [PaymentController::class, 'mollie_callback'])->name('mollie-callback');

        Route::get('/razorpay', [PaymentController::class, 'razorpay_payment'])->name('razorpay');
        Route::post('/razorpay-store', [PaymentController::class, 'razorpay_payment_store'])->name('razorpay-store');

        Route::get('/flutterwave', [PaymentController::class, 'flutterwave_payment'])->name('flutterwave');
        Route::get('/flutterwave-payment-store/{payable_amount}', [PaymentController::class, 'flutterwave_payment_store'])->name('flutterwave-payment-store');

        Route::get('/paystack', [PaymentController::class, 'paystack_payment'])->name('paystack');
        Route::get('/paystack-store/{payable_amount}', [PaymentController::class, 'paystack_payment_store'])->name('paystack-store');

        Route::get('/instamojo/{plan_id}', [PaymentController::class, 'instamojo_payment'])->name('instamojo');
        Route::get('/instamojo-callback', [PaymentController::class, 'instamojo_callback'])->name('instamojo-callback');
    });


});
