@extends('admin.master_layout')
@section('title')
    <title>{{ __('Buyer || Message Job Post Applicants') }}</title>
@endsection
@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('User Message') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Dashboard') }} >> {{ __('User Message') }}</p>
    <style>
        .bg-light {
            background-color: #999999 !important;
        }

        .bg-primary {
            background-color: #007bff !important;
        }

        .rounded {
            border-radius: 15px;
        }
    </style>
@endsection

@section('body-content')
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">

                            <div class="crancy-table crancy-table--v3 mg-top-30">
                                <!-- crancy Table -->
                                <div class="container-fluid">
                                    <div id="crancy-table__main_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                        <div class="row">
                                            <div class="col-10 offset-1">
                                                <p class="text-danger">{{ __('Restricted key count') }}:
                                                    {{ $restrictedCount }}</p>

                                                <div class="d-flex justify-content-between align-items-center mb-3">
                                                    <span class="fw-bold">{{ __('Conversation') }}:
                                                        {{ $buyer->name ?? 'Buyer' }} -
                                                        {{ $seller->name ?? 'Seller' }}</span>
                                                    <span class="text-muted"><a href="{{ route('admin.message') }}">
                                                            <i class="fas fa-arrow-left"></i>
                                                            {{ __('Back to list') }} </a></span>
                                                </div>
                                                <div id="messageContainer" class="mt-4 border rounded shadow-sm"
                                                    style="height: 500px; overflow-y: auto; padding: 15px;">
                                                    @forelse($messages as $msg)
                                                        @php
                                                            $isSeller = $msg->send_by === 'seller';
                                                            $alignClass = $isSeller
                                                                ? 'justify-content-start'
                                                                : 'justify-content-end';
                                                            $bubbleClass = $isSeller
                                                                ? 'fs-seller-message'
                                                                : 'fs-admin-message';
                                                            $senderLabel = $isSeller ? $seller->name : $buyer->name;
                                                            $isRestricted = false;
                                                            foreach ($restricted_key_word as $word) {
                                                                if (stripos($msg->message, $word) !== false) {
                                                                    $isRestricted = true;
                                                                    break;
                                                                }
                                                            }

                                                            if ($isRestricted) {
                                                                $bubbleClass = 'bg-danger text-white';
                                                            }
                                                        @endphp

                                                        <div class="d-flex {{ $alignClass }} mb-2">
                                                            <div class="p-3 rounded {{ $bubbleClass }}"
                                                                style="max-width: 60%;">
                                                                <div class="fw-bold mb-1">{{ $senderLabel }}</div>
                                                                <div>{!! $msg->message ?? '' !!}</div>
                                                                <div>
                                                                    @foreach (json_decode($msg->documents) as $document)
                                                                        <a href="{{ route('admin.message-download-file', $document->id) }}"
                                                                            target="_blank" class="upload_photo">
                                                                            <i class="fas fa-link"></i>
                                                                            {{ __('click to download') }}
                                                                        </a>
                                                                    @endforeach
                                                                </div>
                                                                <div class="small mt-1 ">
                                                                    {{ $msg->created_at->format('d M Y, h:i A') }}</div>
                                                            </div>
                                                        </div>
                                                    @empty
                                                        <div class="text-muted">{{ __('No messages found.') }}</div>
                                                    @endforelse
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
@endsection

@push('js_section')
    <script>
        "use strict"

        function itemDeleteConfrimation(id) {
            $("#item_delect_confirmation").attr("action", '{{ url('admin/delete-contact-message/') }}' + "/" + id)
        }
    </script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const container = document.getElementById("messageContainer");
            if (container) {
                container.scrollTop = container.scrollHeight;
            }
        });
    </script>
@endpush
