<?php

use Illuminate\Http\Request;
use Modules\Listing\Http\Controllers\API\Seller\ListingController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::group(['middleware' => ['auth:api', 'HtmlSpecialchars', 'MaintenanceMode', 'CurrencyLangaugeForAPI']], function () {

    Route::group(['as'=> 'seller.', 'prefix' => 'seller'],function (){
        Route::get('/get-subcategories/{categoryId}', [ListingController::class, 'getSubcategories']);
        Route::resource('listing', ListingController::class);

        Route::post('/store-listing-package/{id}', [ListingController::class, 'store_listing_package'])->name('store-listing-package');

        Route::post('/listing-seo/{id}', [ListingController::class, 'listing_seo'])->name('listing-seo');

        Route::post('/listing-publish/{id}', [ListingController::class, 'listing_publish'])->name('listing-publish');

        Route::post('listing-status/{id}', [ListingController::class, 'listing_status'])->name('listing-status');
        Route::post('upload-image/{id}', [ListingController::class, 'upload_listing_gallery'])->name('upload-gallery');
        Route::delete('delete-gallery/{id}', [ListingController::class, 'delete_listing_gallery'])->name('delete-gallery');

    });
});


