<?php

use Illuminate\Http\Request;
use Modules\JobPost\Http\Controllers\API\Buyer\JobPostController as BuyerJobPostController;
use Modules\JobPost\Http\Controllers\API\Seller\JobPostController as SellerJobPostController;


Route::group(['middleware' => ['auth:api', 'HtmlSpecialchars', 'CurrencyLangaugeForAPI']], function () {

    Route::group(['as' => 'buyer.', 'prefix' => 'buyer'], function () {

        Route::resource('jobpost', BuyerJobPostController::class);

        Route::post('/jobpost-thumbnail', [BuyerJobPostController::class,  'jobpost_thumbnail'])->name('jobpost-thumbnail');

        Route::get('/job-post-applicants/{id}', [BuyerJobPostController::class,  'job_post_applicants'])->name('job-post-applicants');
        Route::put('/job-application-approval/{id}', [BuyerJobPostController::class,  'job_application_approval'])->name('job-application-approval');




        Route::get('/message-box-by-jobpost/{id}', [BuyerJobPostController::class,  'message_box_by_jobpost'])->name('message-box-by-jobpost');
        Route::get('/message-list-by-jobpost/{id}', [BuyerJobPostController::class,  'message_list_by_jobpost'])->name('message-list-by-jobpost');
        Route::post('/jobpost-message-store/{id}', [BuyerJobPostController::class,  'jobpost_message_store'])->name('jobpost-message-store');

        Route::put('/job-application-order-approved/{id}', [BuyerJobPostController::class,  'job_application_order_approved'])->name('job-application-order-approved');
        Route::put('/job-application-order-cancel/{id}', [BuyerJobPostController::class,  'job_application_order_cancel'])->name('job-application-order-cancel');
    });
});



Route::group(['middleware' => ['auth:api', 'HtmlSpecialchars', 'MaintenanceMode', 'CurrencyLangaugeForAPI']], function () {

    Route::group(['as' => 'seller.', 'prefix' => 'seller'], function () {

        Route::get('/my-applicants', [SellerJobPostController::class,  'index'])->name('my-applicants');
        Route::get('/my-applicant/{id}', [SellerJobPostController::class,  'show'])->name('my-applicant');
        Route::post('/apply-job/{id}', [SellerJobPostController::class,  'apply_job'])->name('apply-job');

        Route::get('/message-box-by-jobpost/{id}', [SellerJobPostController::class,  'message_box_by_jobpost'])->name('message-box-by-jobpost');
        Route::get('/message-list-by-jobpost/{id}', [SellerJobPostController::class,  'message_list_by_jobpost'])->name('message-list-by-jobpost');
        Route::post('/jobpost-message-store/{id}', [SellerJobPostController::class,  'jobpost_message_store'])->name('jobpost-message-store');



        Route::post('/job-post-order-submission/{id}', [SellerJobPostController::class, 'job_post_order_submission'])->name('job-post-order-submission');
    });
});
