<?php

namespace Modules\JobPost\Http\Controllers\Seller;

use App\Models\JobRequestFile;
use App\Models\User;
use App\Rules\Captcha;

use Auth, Image, File, Str;
use Illuminate\Http\Request;
use Modules\City\Entities\City;
use Illuminate\Routing\Controller;

use Modules\JobPost\Entities\JobPost;
use Modules\Category\Entities\Category;
use Modules\JobPost\Entities\JobRequest;

use Modules\Language\App\Models\Language;

use Illuminate\Contracts\Support\Renderable;
use Modules\JobPost\App\Models\JobPostMessage;
use Modules\JobPost\App\Models\JobPostMessagesDocument;
use Modules\JobPost\Entities\JobPostTranslation;
use Modules\JobPost\Http\Requests\JobPostRequest;
use Modules\Refund\App\Models\RefundRequest;

class JobPostController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $user = Auth::guard('web')->user();

        $job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->latest()->paginate(10);

        $hired_job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->where('status', 'approved')->latest()->paginate(10);

        $pending_job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->where('status', 'pending')->latest()->paginate(10);

        $reject_job_requests = JobRequest::with('job_post')->where('seller_id', $user->id)->where('status', 'rejected')->latest()->paginate(10);

        return view('jobpost::seller.index', [
            'job_requests' => $job_requests,
            'hired_job_requests' => $hired_job_requests,
            'pending_job_requests' => $pending_job_requests,
            'reject_job_requests' => $reject_job_requests
        ]);
    }


    public function chat_job_post_applicants($id)
    {

        if (!checkModule('LiveChat')) {
            $notify_message = trans('translate.Live Chat module is not enabled, please contact with admin');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'error');
            return redirect()->back()->with($notify_message);
        }

        $seller = Auth::guard('web')->user();

        $job_request = JobRequest::where('seller_id', $seller->id)->findOrFail($id);

        $last_message = JobPostMessage::with('documents')->where('job_request_id', $job_request->id)->where('seller_id', $seller->id)->where('send_by', 'buyer')->latest()->first();

        $messages = JobPostMessage::with('buyer', 'documents')->where('job_request_id', $job_request->id)->where(['seller_id' => $seller->id, 'buyer_id' => $job_request->user_id])->get();

        $job_post_submition_files = JobRequestFile::where('status', 1)->where('job_request_id', $job_request->id)->first();

        return view('livechat::job_application.seller.chat', [
            'seller' => $seller,
            'last_message' => $last_message,
            'messages' => $messages,
            'job_request' => $job_request,
            'job_post_submition_files' => $job_post_submition_files
        ]);
    }

    public function chact_msg_store(Request $request)
    {
        $seller = Auth::guard('web')->user();

        $job_request = JobRequest::findOrFail($request->request_id);

        $message = new JobPostMessage();
        $message->buyer_id = $request->buyer_id;
        $message->seller_id = $seller->id;
        $message->message = $request->message;
        $message->seller_read_msg = 1;
        $message->buyer_read_msg = 0;
        $message->send_by = 'seller';
        $message->job_request_id = $job_request->id;
        $message->save();

        if ($request->hasFile('documents')) {
            foreach ($request->documents as $index => $request_file) {

                $file_path = uploadPrivateFile($request_file, 'uploads/custom-images');

                $document = new JobPostMessagesDocument();
                $document->message_id = $message->id;
                $document->buyer_id =  $request->buyer_id;
                $document->file_type =  $request->file_type;
                $document->seller_id =   $seller->id;
                $document->file_name = $file_path;
                $document->save();
            }
        }

        $last_message = JobPostMessage::with('documents')->where('job_request_id', $job_request->id)->where('seller_id', $seller->id)->where('send_by', 'seller')->latest()->first();

        $messages =  JobPostMessage::with('documents')->where('job_request_id', $job_request->id)->where(['seller_id' => $seller->id, 'buyer_id' => $request->buyer_id])->get();

        $job_post_submition_files = JobRequestFile::where('status', 1)->where('job_request_id', $job_request->id)->first();

        return redirect()->route('seller.chat-job-post-applicants', ['id' => $job_request->id])->with([
            'seller' => $seller,
            'last_message' => $last_message,
            'messages' => $messages,
            'job_request' => $job_request,
            'job_post_submition_files' => $job_post_submition_files
        ]);
    }

    public function job_application_order_cancel(Request $request, $id)
    {
        if (!checkModule('Wallet') || !checkModule('Refund')) {
            $notify_message = trans('translate.Wallet and Refund module is not enabled, please contact with admin');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'error');
            return redirect()->back()->with($notify_message);
        }

        $job_request = JobRequest::findOrFail($id);

        $is_exist = RefundRequest::where('refund_type', 'job')->where('job_request_id', $id)->first();
        if ($is_exist) {
            $notify_message = trans('translate.Refund request already send to admin');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'error');
            return redirect()->back()->with($notify_message);
        }
        $job = JobPost::findOrFail($job_request->job_post_id);

        $refund = new RefundRequest();
        $refund->buyer_id = $job_request->user_id;
        $refund->seller_id = $job_request->seller_id;
        $refund->refund_type = 'job';
        $refund->job_request_id = $id;
        $refund->refund_amount = $job->regular_price;
        $refund->note2 = $request->cancel_reason_seller;
        $refund->save();

        $job_request->approved_status = 'cancel_pending';
        $job_request->status = 'cancel';
        $job_request->cancel_reason_seller = $request->cancel_reason_seller;
        $job_request->save();

        $notify_message = trans('translate.Order Cancel Request Send Successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }



    public function apply_job(Request $request, $id)
    {

        $rules = [
            'description' => 'required',
            'g-recaptcha-response' => new Captcha()
        ];

        $customMessages = [
            'description.required' => trans('translate.Message is required'),
        ];

        $request->validate($rules, $customMessages);

        // return $id;

        $auth_user = Auth::guard('web')->user();

        if ($auth_user->is_seller == 0) {
            $notify_message = trans('translate.To apply the job, you have to logged in as a seller');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'error');
            return redirect()->back()->with($notify_message);
        }

        $is_exist = JobRequest::where(['seller_id' => $auth_user->id, 'job_post_id' => $id])->count();
        if ($is_exist > 0) {
            $notify_message = trans('translate.Application already submited');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'error');
            return redirect()->back()->with($notify_message);
        }

        // return $id;

        $approval_check = JobRequest::where('job_post_id', $id)->where('status', 'approved')->count();

        if ($approval_check > 0) {
            $notify_message = trans('translate.Job already has assigned, so you can not apply');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'error');
            return redirect()->back()->with($notify_message);
        }

        $job_post = JobPost::findOrFail($id);

        $job_request = new JobRequest();
        $job_request->seller_id = $auth_user->id;
        $job_request->user_id = $job_post->user_id;
        $job_request->job_post_id = $id;
        $job_request->description = $request->description;
        $job_request->save();

        $notify_message = trans('translate.Your application has submited successfully, please wait for agent approval');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }
}
