<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('job_requests', function (Blueprint $table) {
            $table->string('approved_status')->after('status')->nullable();
            $table->text('cancel_reason_seller')->after('status')->nullable();
            $table->text('cancel_reason_buyer')->after('status')->nullable();
            $table->string('cancel_requset')->after('status')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('job_requests', function (Blueprint $table) {
            $table->dropColumn('approved_status');
            $table->dropColumn('cancel_reason_seller');
            $table->dropColumn('cancel_reason_buyer');
            $table->dropColumn('cancel_requset');
        });
    }
};
