<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{__('Razorpay Payment')}}</title>
    <link rel="icon" href="{{ asset($setting->favicon) }}">

    <script src="{{ asset('global/js/jquery-3.7.1.min.js') }}"></script>

</head>
<body>
    <p style="text-align: center">Please wait. Your payment is processing....</p>
    <p style="text-align: center">Do not press browser back or forward button while you are in payment page</p>

    <form action="{{ route('wallet-api-payment.razorpay-webview-success', ['wallet_amount' => $payable_amount]) }}" style="display: none">
        @csrf
        @php
            $payable_amount = $payable_amount * $razorpay_currency->currency_rate;
            $payable_amount = round($payable_amount, 2);
        @endphp
        <script src="https://checkout.razorpay.com/v1/checkout.js"
            data-key="{{ $payment_setting->razorpay_key }}"
            data-currency="{{ $razorpay_currency->currency_code }}"
            data-amount= "{{ $payable_amount * 100 }}"
            data-buttontext="{{ __('translate.Pay') }}"
            data-name="{{ $payment_setting->razorpay_name }}"
            data-description="{{ $payment_setting->razorpay_description }}"
            data-image="{{ asset($payment_setting->razorpay_image) }}"
            data-prefill.name=""
            data-prefill.email=""
            data-theme.color="{{ $payment_setting->razorpay_theme_color }}">
        </script>
    </form>



    <script>
        $(".razorpay-payment-button").click();
    </script>
</body>
</html>
