<?php

namespace Modules\Slider\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Slider\Entities\Slider;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Illuminate\Http\RedirectResponse;
use Intervention\Image\Facades\Image;
use App\Models\Admin;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('slider_view')) {
            abort(403, 'Forbidden: missing permission slider_view');
        }

        $sliders = Slider::get();

        return view('slider::index', [
            'sliders' => $sliders
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('slider_create')) {
            abort(403, 'Forbidden: missing permission slider_create');
        }
        return view('slider::create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('slider_create')) {
            abort(403, 'Forbidden: missing permission slider_create');
        }
        $item = new Slider();
        $item->title = $request->title;
        $item->status = $request->status ? 'active' : 'inactive';


        if ($request->slider_image) {
            $file_path = uploadPublicFile($request->slider_image, 'uploads/custom-images');
            $item->image = $file_path;
            $item->save();
        }

        $notification = trans('translate.Created Successfully');
        $notification = array('messege' => $notification, 'alert-type' => 'success');
        return redirect()->route('admin.slider.index')->with($notification);
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('slider_edit')) {
            abort(403, 'Forbidden: missing permission slider_edit');
        }
        $slider = Slider::find($id);

        return view('slider::edit', [
            'slider' => $slider
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('slider_update')) {
            abort(403, 'Forbidden: missing permission slider_update');
        }
        $item = Slider::find($id);

        $item->title = $request->title;
        $item->status = $request->status ? 'active' : 'inactive';

        if ($request->slider_image) {
            $file_path = uploadPublicFile($request->slider_image, 'uploads/custom-images', $item->image);
            $item->image = $file_path;
            $item->save();
        }

        $item->save();

        $notification = trans('translate.Updated Successfully');
        $notification = array('messege' => $notification, 'alert-type' => 'success');
        return redirect()->route('admin.slider.index')->with($notification);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('slider_delete')) {
            abort(403, 'Forbidden: missing permission slider_delete');
        }
        $item = Slider::find($id);
        $old_image = $item->image;
        $item->delete();
        if ($old_image) {
            deleteFile($old_image);
        }

        $notification = trans('translate.Delete Successfully');
        $notification = array('messege' => $notification, 'alert-type' => 'success');
        return redirect()->back()->with($notification);
    }
}
