@extends('admin.master_layout')

@section('title')
    <title>{{ __('admin.Assign Seller Level') }}</title>
@endsection

@section('admin-content')

<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>{{ __('admin.Assign Seller Level') }}</h1>
        </div>

        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        
                        <div class="card-body">
                            <form action="{{ route('admin.assign-sellerlevel') }}">
              
                                <input type="hidden" name="is_search" value="yes">

                                <!-- Select Level Dropdown -->
                                <div class="form-group">
                                    <label for="level">{{ __('admin.Select Level') }}</label>
                                    <select name="level_id" class="form-control">
                                        <option value="">{{ __('Select') }}</option>
                                        @foreach($levels as $level)
                                            <option {{  request()->get('level_id') == $level->id ? 'selected' : '' }} value="{{ $level->id }}">{{ $level->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary">{{ __('admin.Search Eligible Sellers') }}</button>

                                    @if (request()->has('is_search') && request()->has('level_id') && request()->get('level_id') != null )
                                    <a href="{{ route('admin.store-assign-sellerlevel',  request()->get('level_id')) }}" class="btn btn-success">{{ __('admin.Assign to All') }}</a>
                                    @endif
                                    
                                </div>

                            </form>
                            @if (request()->has('is_search') && request()->has('level_id') && request()->get('level_id') != null )
                                <!-- Sellers List -->
                                <h5>{{ __('admin.Eligible Sellers') }}</h5>

                                <table class="table" id="dataTable">
                                    <thead>
                                        <tr>
                                            <th>{{ __('admin.Seller') }}</th>
                                            <th>{{ __('admin.Total Orders') }}</th>
                                            <th>{{ __('admin.Total Order Amount') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($sellers as $seller)
                                            <tr>
                                                <td>{{ $seller->name }}</td>
                                                <td>{{ $seller->total_orders }}</td>
                                                <td>{{ currency($seller->total_order_amount) }}</td>
                                               
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            @endif
                    
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection
