<?php

namespace Modules\SellerLevel\Database\Seeders;

use Illuminate\Database\Seeder;
use Modules\SellerLevel\Entities\SellerLevel;

class SellerLevelInfoDatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $sellerLevels = [
            [
                'image' => 'uploads/website-images/new-seller.png',
                'name' => 'New Seller',
                'min_orders' => 0,
                'commission' => 25,
                'basic_price' => 500,
                'min_order_amount' => 0,
                'is_new_seller' => 'yes'
            ],
            [
                'image' => 'uploads/website-images/level-one.png',
                'name' => 'Level 1',
                'min_orders' => 3,
                'commission' => 20,
                'basic_price' => 1000,
                'min_order_amount' => 1500,
                'is_new_seller' => 'no'
            ],
            [
                'image' => 'uploads/website-images/level-two.png',
                'name' => 'Level 2',
                'min_orders' => 5,
                'commission' => 15,
                'basic_price' => 1500,
                'min_order_amount' => 2000,
                'is_new_seller' => 'no'
            ],
            [
                'image' => 'uploads/website-images/level-three.png',
                'name' => 'Level 3',
                'min_orders' => 7,
                'commission' => 10,
                'basic_price' => 2000,
                'min_order_amount' => 3500,
                'is_new_seller' => 'no'
            ],
            [
                'image' => 'uploads/website-images/level-four.png',
                'name' => 'Cre8ers Choice',
                'min_orders' => 10,
                'commission' => 5,
                'basic_price' => 2500,
                'min_order_amount' => 4500,
                'is_new_seller' => 'no'
            ],
            [
                'image' => 'uploads/website-images/top-seller.png',
                'name' => 'Top Rated',
                'min_orders' => 15,
                'commission' => 1,
                'basic_price' => 5000,
                'min_order_amount' => 15000,
                'is_new_seller' => 'no'
            ],
        ];

        foreach ($sellerLevels as $level) {
            SellerLevel::create([
                'icon' => $level['image'],
                'name' => $level['name'],
                'min_orders' => $level['min_orders'],
                'commission' => $level['commission'],
                'basic_price' => $level['basic_price'],
                'min_order_amount' => $level['min_order_amount'],
                'is_new_seller' => $level['is_new_seller'],
            ]);
        }
    }
}
