<?php

namespace Modules\SellerLevel\Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Modules\SellerLevel\Entities\SellerLevel;
use Modules\SellerLevel\Entities\SellerLevelHistory;
use App\Models\Order;

class SellerLevelAssignDatabaseSedder extends Seeder
{
    /**
     * Run the database seeds.
     */
   public function run(): void
    {
        $json_module_data = file_get_contents(base_path('modules_statuses.json'));
        $module_status = json_decode($json_module_data);

        if (property_exists($module_status, 'SellerLevel') && $module_status->SellerLevel === true) {

            $assignment_method = env('SELLER_LEVEL_ASSIGNMENT_METHOD', 'registration_date');

            $sellers = User::where('is_seller', 1)->get();

            foreach ($sellers as $seller) {

                $eligible_sellers = collect();

                $lastAssignment = SellerLevelHistory::where('seller_id', $seller->id)
                        ->orderBy('assigned_at', 'desc')
                        ->first();

                if ($assignment_method === 'level_assignment' && $lastAssignment) {
                    $startDate = $lastAssignment->assigned_at;
                } else {
                    $startDate = $seller->created_at;
                }

                $seller->total_orders = Order::where('seller_id', $seller->id)
                    ->where('order_status', 'complete_by_buyer')
                    ->where('created_at', '>=', $startDate)
                    ->count();

                $seller->total_order_amount = Order::where('seller_id', $seller->id)
                    ->where('order_status', 'complete_by_buyer')
                    ->where('created_at', '>=', $startDate)
                    ->sum('total_amount');

                $level = SellerLevel::where('min_orders', '<=', $seller->total_orders)->where('min_order_amount', '<=', $seller->total_order_amount)->orderBy('id', 'desc')->first();

                if($level){
                    if ($lastAssignment && $lastAssignment->seller_level_id != $level->id) {
                        if ($seller->total_orders >= $level->min_orders && $seller->total_order_amount >= $level->min_order_amount) {
                            SellerLevelHistory::create([
                                'seller_id' => $seller->id,
                                'seller_level_id' => $level->id,
                                'level' => $level->name,
                                'assigned_at' => now(),
                                'orders_at_assignment' => $seller->total_orders,
                                'order_amount_at_assignment' => $seller->total_order_amount,
                            ]);

                            User::where('id', $seller->id)->update(['current_level_id' => $level->id, 'level_assigned_at' => now()]);

                        }
                    }
                }
            }
        }
    }
}
