<?php

namespace Modules\PaymentWithdraw\App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Modules\PaymentWithdraw\App\Models\SellerWithdraw;
use App\Models\Admin;

class PaymentWithdrawController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('withdraw_list_view')) {
            abort(403, 'Forbidden: missing permission withdraw_list_view');
        }

        $withdraw_list = SellerWithdraw::latest()->get();

        return view('paymentwithdraw::index', [
            'withdraw_list' => $withdraw_list
        ]);
    }

    /**
     * Show the specified resource.
     */
    public function show($id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('withdraw_view')) {
            abort(403, 'Forbidden: missing permission withdraw_view');
        }

        $withdraw = SellerWithdraw::findOrFail($id);

        return view('paymentwithdraw::show', [
            'withdraw' => $withdraw
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function withdraw_approval($id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('withdraw_approve')) {
            abort(403, 'Forbidden: missing permission withdraw_approve');
        }

        $withdraw = SellerWithdraw::findOrFail($id);
        $withdraw->status = 'approved';
        $withdraw->save();


        $notify_message= trans('translate.Withdraw approved successful');
        $notify_message=array('message'=>$notify_message,'alert-type'=>'success');
        return redirect()->back()->with($notify_message);
    }

    public function withdraw_rejected($id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('withdraw_reject')) {
            abort(403, 'Forbidden: missing permission withdraw_reject');
        }

        $withdraw = SellerWithdraw::findOrFail($id);
        $withdraw->status = 'rejected';
        $withdraw->save();

        $notify_message= trans('translate.Withdraw rejected successful');
        $notify_message=array('message'=>$notify_message,'alert-type'=>'success');
        return redirect()->back()->with($notify_message);
    }




    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('withdraw_delete')) {
            abort(403, 'Forbidden: missing permission withdraw_delete');
        }

        $withdraw = SellerWithdraw::findOrFail($id);
        $withdraw->delete();


        $notify_message= trans('translate.Withdraw deleted successful');
        $notify_message=array('message'=>$notify_message,'alert-type'=>'success');
        return redirect()->route('admin.withdraw-list.index')->with($notify_message);
    }
}
