<?php

namespace Modules\Page\App\Http\Controllers;

use Image, File, Str;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Modules\Page\App\Models\Homepage;
use Modules\Page\App\Http\Requests\IntroRequest;
use Modules\Page\App\Models\HomepageTranslation;
use Modules\Page\App\Http\Requests\IntroRequest2;
use Modules\Page\App\Http\Requests\ExploreRequest;
use Modules\Page\App\Http\Requests\JoinSellerRequest;
use Modules\Page\App\Http\Requests\OurFeatureRequest;
use Modules\Page\App\Http\Requests\WorkingStepRequest;
use App\Models\Admin;

class HomepageController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function intro_section(Request $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('intro_section_view')) {
            abort(403, 'Forbidden: missing permission intro_section_view');
        }

        $homepage = Homepage::first();
        $translate = HomepageTranslation::where(['homepage_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.intro', ['homepage' => $homepage, 'translate' => $translate]);
    }


    public function update_intro_section(IntroRequest $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('intro_section_update')) {
            abort(403, 'Forbidden: missing permission intro_section_update');
        }

        $translate = HomepageTranslation::where(['id' => $request->translate_id, 'lang_code' => $request->lang_code])->first();
        $translate->intro_title = $request->intro_title;
        $translate->total_rating = $request->total_rating;
        $translate->total_customer = $request->total_customer;
        $translate->save();

        $homepage = Homepage::first();



        if ($request->intro_banner_one) {
            $file_path = uploadPublicFile($request->intro_banner_one, 'uploads/custom-images', $homepage->intro_banner_one);
            $homepage->intro_banner_one = $file_path;
            $homepage->save();
        }

        if ($request->customer_image) {
            $file_path = uploadPublicFile($request->customer_image, 'uploads/custom-images', $homepage->customer_image);
            $homepage->customer_image = $file_path;
            $homepage->save();
        }



        $notify_message = trans('translate.Update successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function intro2_section(Request $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('intro2_section_view')) {
            abort(403, 'Forbidden: missing permission intro2_section_view');
        }

        $homepage = Homepage::first();
        $translate = HomepageTranslation::where(['homepage_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.intro2', ['homepage' => $homepage, 'translate' => $translate]);
    }

    public function update_intro2_section(IntroRequest2 $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('intro2_section_update')) {
            abort(403, 'Forbidden: missing permission intro2_section_update');
        }

        $translate = HomepageTranslation::where(['id' => $request->translate_id, 'lang_code' => $request->lang_code])->first();
        $translate->home2_intro_title = $request->home2_intro_title;
        $translate->home2_intro_description = $request->home2_intro_description;
        $translate->save();

        $homepage = Homepage::first();

        if ($request->lang_code == admin_lang()) {
            $homepage->home2_intro_tags = $request->home2_intro_tags;
            $homepage->save();
        }

        if ($request->home2_intro_bg) {
            $file_path = uploadPublicFile($request->home2_intro_bg, 'uploads/custom-images', $homepage->home2_intro_bg);
            $homepage->home2_intro_bg = $file_path;
            $homepage->save();
        }

        if ($request->home2_intro_forground) {
            $file_path = uploadPublicFile($request->home2_intro_forground, 'uploads/custom-images', $homepage->home2_intro_forground);
            $homepage->home2_intro_forground = $file_path;
            $homepage->save();
        }



        $notify_message = trans('translate.Update successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function working_step(Request $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('working_step_view')) {
            abort(403, 'Forbidden: missing permission working_step_view');
        }

        $homepage = Homepage::first();
        $translate = HomepageTranslation::where(['homepage_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.working_step', ['homepage' => $homepage, 'translate' => $translate]);
    }

    public function update_working_step(WorkingStepRequest $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('working_step_update')) {
            abort(403, 'Forbidden: missing permission working_step_update');
        }

        $translate = HomepageTranslation::where(['id' => $request->translate_id, 'lang_code' => $request->lang_code])->first();
        $translate->working_step_title1 = $request->working_step_title1;
        $translate->working_step_title2 = $request->working_step_title2;
        $translate->working_step_title3 = $request->working_step_title3;
        $translate->working_step_title4 = $request->working_step_title4;
        $translate->working_step_des1 = $request->working_step_des1;
        $translate->working_step_des2 = $request->working_step_des2;
        $translate->working_step_des3 = $request->working_step_des3;
        $translate->save();

        $homepage = Homepage::first();



        if ($request->working_step_icon1) {
            $file_path = uploadPublicFile($request->working_step_icon1, 'uploads/custom-images', $homepage->working_step_icon1);
            $homepage->working_step_icon1 = $file_path;
            $homepage->save();
        }

        if ($request->working_step_icon2) {
            $file_path = uploadPublicFile($request->working_step_icon2, 'uploads/custom-images', $homepage->working_step_icon2);
            $homepage->working_step_icon2 = $file_path;
            $homepage->save();
        }

        if ($request->working_step_icon3) {
            $file_path = uploadPublicFile($request->working_step_icon3, 'uploads/custom-images', $homepage->working_step_icon3);
            $homepage->working_step_icon3 = $file_path;
            $homepage->save();
        }

        if ($request->working_step_icon4) {
            $file_path = uploadPublicFile($request->working_step_icon4, 'uploads/custom-images', $homepage->working_step_icon4);
            $homepage->working_step_icon4 = $file_path;
            $homepage->save();
        }

        $notify_message = trans('translate.Update successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function our_feature(Request $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('our_feature_view')) {
            abort(403, 'Forbidden: missing permission our_feature_view');
        }

        $homepage = Homepage::first();
        $translate = HomepageTranslation::where(['homepage_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.our_feature', ['homepage' => $homepage, 'translate' => $translate]);
    }

    public function update_our_feature(OurFeatureRequest $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('our_feature_update')) {
            abort(403, 'Forbidden: missing permission our_feature_update');
        }

        $homepage = Homepage::first();

        $translate = HomepageTranslation::where(['homepage_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();
        $translate->feature_title1 = $request->feature_title1;
        $translate->feature_title2 = $request->feature_title2;
        $translate->feature_title3 = $request->feature_title3;
        $translate->feature_title4 = $request->feature_title4;
        $translate->feature_title5 = $request->feature_title5;
        $translate->save();

        if ($request->feature_icon1) {
            $file_path = uploadPublicFile($request->feature_icon1, 'uploads/custom-images', $homepage->feature_icon1);
            $homepage->feature_icon1 = $file_path;
            $homepage->save();
        }

        if ($request->feature_icon2) {
            $file_path = uploadPublicFile($request->feature_icon2, 'uploads/custom-images', $homepage->feature_icon2);
            $homepage->feature_icon2 = $file_path;
            $homepage->save();
        }


        if ($request->feature_icon3) {
            $file_path = uploadPublicFile($request->feature_icon3, 'uploads/custom-images', $homepage->feature_icon3);
            $homepage->feature_icon3 = $file_path;
            $homepage->save();
        }

        if ($request->feature_icon4) {
            $file_path = uploadPublicFile($request->feature_icon4, 'uploads/custom-images', $homepage->feature_icon4);
            $homepage->feature_icon4 = $file_path;
            $homepage->save();
        }


        if ($request->feature_icon5) {
            $file_path = uploadPublicFile($request->feature_icon5, 'uploads/custom-images', $homepage->feature_icon5);
            $homepage->feature_icon5 = $file_path;
            $homepage->save();
        }


        $notify_message = trans('translate.Update successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }




    public function join_seller(Request $request){
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('join_seller_view')) {
            abort(403, 'Forbidden: missing permission join_seller_view');
        }

        $homepage = Homepage::first();
        $translate = HomepageTranslation::where(['homepage_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.join_seller', ['homepage' => $homepage, 'translate' => $translate]);
    }

    public function update_join_seller(JoinSellerRequest $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('join_seller_update')) {
            abort(403, 'Forbidden: missing permission join_seller_update');
        }

        $translate = HomepageTranslation::where(['id' => $request->translate_id, 'lang_code' => $request->lang_code])->first();
        $translate->join_seller_title = $request->join_seller_title;
        $translate->join_seller_des = $request->join_seller_des;
        $translate->save();

        $homepage = Homepage::first();

        if ($request->join_seller_image) {
            $file_path = uploadPublicFile($request->join_seller_image, 'uploads/custom-images', $homepage->join_seller_image);
            $homepage->join_seller_image = $file_path;
            $homepage->save();
        }

        $notify_message = trans('translate.Update successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }

    public function explore_section(Request $request){
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('explore_section_view')) {
            abort(403, 'Forbidden: missing permission explore_section_view');
        }

        $homepage = Homepage::first();
        $translate = HomepageTranslation::where(['homepage_id' => $homepage->id, 'lang_code' => $request->lang_code])->first();

        return view('page::section.explore', ['homepage' => $homepage, 'translate' => $translate]);
    }

    public function update_explore_section(ExploreRequest $request)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('explore_section_update')) {
            abort(403, 'Forbidden: missing permission explore_section_update');
        }

        $translate = HomepageTranslation::where(['id' => $request->translate_id, 'lang_code' => $request->lang_code])->first();
        $translate->explore_short_title = $request->explore_short_title;
        $translate->explore_title = $request->explore_title;
        $translate->explore_description = $request->explore_description;
        $translate->save();

        if ($request->lang_code == admin_lang()) {
            $homepage = Homepage::first();
            $homepage->explore_total_customer = $request->explore_total_customer;
            $homepage->explore_total_service = $request->explore_total_service;
            $homepage->explore_total_job = $request->explore_total_job;
            $homepage->save();
        }

        if ($request->explore_image) {
            $file_path = uploadPublicFile($request->explore_image, 'uploads/custom-images', $homepage->explore_image);
            $homepage->explore_image = $file_path;
            $homepage->save();
        }


        $notify_message = trans('translate.Update successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);
    }


    public function setup_language($lang_code)
    {
        $home_translates = HomepageTranslation::where('lang_code', admin_lang())->first();

        $new_trans = new HomepageTranslation();
        $new_trans->lang_code = $lang_code;
        $new_trans->homepage_id = $home_translates->homepage_id;
        $new_trans->intro_title = $home_translates->intro_title;
        $new_trans->home2_intro_title = $home_translates->home2_intro_title;
        $new_trans->home2_intro_description = $home_translates->home2_intro_description;
        $new_trans->total_rating = $home_translates->total_rating;
        $new_trans->total_customer = $home_translates->total_customer;
        $new_trans->working_step_title1 = $home_translates->working_step_title1;
        $new_trans->working_step_title2 = $home_translates->working_step_title2;
        $new_trans->working_step_title3 = $home_translates->working_step_title3;
        $new_trans->working_step_title4 = $home_translates->working_step_title4;
        $new_trans->working_step_des1 = $home_translates->working_step_des1;
        $new_trans->working_step_des2 = $home_translates->working_step_des2;
        $new_trans->working_step_des3 = $home_translates->working_step_des3;
        $new_trans->join_seller_title = $home_translates->join_seller_title;
        $new_trans->join_seller_des = $home_translates->join_seller_des;
        $new_trans->mobile_app_title = $home_translates->mobile_app_title;
        $new_trans->mobile_app_des = $home_translates->mobile_app_des;
        $new_trans->explore_short_title = $home_translates->explore_short_title;
        $new_trans->explore_title = $home_translates->explore_title;
        $new_trans->explore_description = $home_translates->explore_description;
        $new_trans->feature_title1 = $home_translates->feature_title1;
        $new_trans->feature_title2 = $home_translates->feature_title2;
        $new_trans->feature_title3 = $home_translates->feature_title3;
        $new_trans->feature_title4 = $home_translates->feature_title4;
        $new_trans->feature_title5 = $home_translates->feature_title5;
        $new_trans->save();
    }
}
