<?php

namespace Modules\Newsletter\App\Http\Controllers\Admin;

use Mail, Str;
use App\Models\Admin;
use App\Helper\EmailHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\Support\Facades\Log;
use Modules\Newsletter\App\Models\Newsletter;
use Modules\EmailSetting\App\Models\EmailTemplate;
use Modules\Newsletter\App\Emails\SubscirberSendMail;
use Modules\Newsletter\App\Emails\NewsletterVerification;

class NewsletterController extends Controller
{


    public function index(){

        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('subscriber_list_view')) {
            abort(403, 'Forbidden: missing permission subscriber_list_view');
        }

        $newsletters = Newsletter::where('is_verified', 1)->latest()->get();

        return view('newsletter::admin.subscriber_list', compact('newsletters'));
    }
    /**
     * Store a newly created resource in storage.
     */
    public function destroy(Request $request, $id)
    {
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('subscriber_list_delete')) {
            abort(403, 'Forbidden: missing permission subscriber_list_delete');
        }

        $newsletter = Newsletter::find($id);
        $newsletter->delete();

        $notify_message = trans('translate.Deleted successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->back()->with($notify_message);

    }


    public function email_box(){
        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('send_email_to_subscriber')) {
            abort(403, 'Forbidden: missing permission send_email_to_subscriber');
        }
        return view('newsletter::admin.mail_box');
    }


    public function send_email(Request $request){

        /** @var Admin|null $admin */
        $admin = auth('admin')->user();
        if (!$admin || !$admin->hasPermission('send_email_to_subscriber')) {
            abort(403, 'Forbidden: missing permission send_email_to_subscriber');
        }

        $request->validate([
            'subject' => 'required',
            'message' => 'required',
        ],[
            'subject.required' => trans('translate.Subject is required'),
            'message.required' => trans('translate.Message is required'),
        ]);

        $newsletters = Newsletter::where('is_verified',1)->get();
        if($newsletters->count() > 0){

            EmailHelper::mail_setup();
            foreach($newsletters as $index => $newsletter){
                try{

                    Mail::to($newsletter->email)->send(new SubscirberSendMail($request->subject,$request->message));

                }catch( \Exception $e ){

                    Log::error('Mail send error:' . $e->getMessage());
                }
            }

            $notify_message = trans('translate.Mail send successfully');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
            return redirect()->back()->with($notify_message);
        }else{
            $notify_message = trans('translate.Something Went Wrong');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
            return redirect()->back()->with($notify_message);
        }


    }



}
