@foreach ($messages as $message)
    @if ($message->send_by == 'seller')
        <li class="d-flex flex-column align-items-end gap-1">
            @if ($message->message !== null)
                <p class="bg-blue-300 text-white p-2 rounded-3 text-p-message">
                    {{ html_decode($message->message) }}
                </p>
            @endif
            <span class="text-dark-200 text-14">{{ $message->created_at->diffForHumans() }}</span>
            @if ($message->documents)
                <div class="fr-support__items">
                    @foreach (json_decode($message->documents) as $document)
                        <a href="{{ route('message-download-file', $document->id) }}" target="_blank" class="upload_photo">
                            <i class="fas fa-link"></i> {{ __('click to download') }}
                        </a>
                    @endforeach
                </div>
            @endif
        </li>
    @else
        <li class="d-flex flex-column  gap-1 left-side">
            @if ($message->message !== null)
                <p class="bg-blue-300 align-items-start  p-2 rounded-3 text-p-message">
                    {{ html_decode($message->message) }}
                </p>
            @endif
            <span class="text-dark-200 text-14">{{ $message->created_at->diffForHumans() }}</span>
            @if ($message->documents)
                <div class="fr-support__items">
                    @foreach (json_decode($message->documents) as $document)
                        <a href="{{ route('message-download-file', $document->id) }}" target="_blank"
                            class="upload_photo">
                            <i class="fas fa-link"></i> {{ __('click to download') }}
                        </a>
                    @endforeach
                </div>
            @endif
        </li>
    @endif
@endforeach
