@extends('layout')
@section('title')
    <title>{{ __('translate.Edit Propsal by Milestone') }}</title>
    <meta name="title" content="{{ __('translate.Edit Propsal by Milestone') }}">
    <meta name="description" content="{{ __('translate.Edit Propsal by Milestone') }}">
@endsection

@section('front-content')
<!-- Main Start -->
<main class="bg-offWhite">

        <!-- Breadcrumb -->
        <section
        class="w-breadcrumb-area"
        style="background-image: url({{ custom_asset($general_setting->breadcrumb_image) }});">
            <div class="container">
                <div class="row">
                    <div class="col-auto">
                    <div
                        class="position-relative z-2"
                        data-aos="fade-up"
                        data-aos-duration="1000"
                        data-aos-easing="linear"
                    >
                        <h2 class="section-title-light mb-2">{{ __('translate.Edit a Proposal') }}</h2>
                        <nav aria-label="breadcrumb">
                        <ol class="breadcrumb w-breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">{{ __('translate.Home') }}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">
                            {{ __('translate.Edit a Proposal') }}
                            </li>
                        </ol>
                        </nav>
                    </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Breadcrumb End -->

    <!-- Content -->
    <!-- <section class="py-120 legal-content">
      <div class="container">
        <div>
          <div class="row">
            <div class="co-auto">
              <div class="content-details">


              </div>
            </div>
          </div>
        </div>
      </div>
    </section> -->

    <!-- job-milestone-section -->
    <section class="fr-job py-110">
      <div class="container">
        <div class="fr-job-details">
              <div class="fr-job-heading">
                <h6 class="text-18 fw-semibold">{{ __('translate.Job Details') }}</h6>
              </div>
              <div class="fr-author-section">
                  <div class="fr-author">
                    <div class="fr-author__img">
                        @if ($job_post?->user?->image)
                            <img src="{{ custom_asset($job_post->thumb_image) }}" alt="img" />
                        @else
                            <img src="{{ custom_asset($general_setting->default_avatar) }}" alt="img" />
                        @endif
                    </div>
                    <div class="fr-author__content">
                      <h4 class="text-24 fw-bold">{{ html_decode($job_post->title) }}</h4>
                      <span class="fr-author__desc text-14">{{ $job_post?->user?->name }}</span>
                      <a href="{{ route('job-post', $job_post->slug) }}" class="blog-link d-flex gap-3 align-items-center text-dark-200">
                        {{ __('translate.View Job Post') }}
                        <svg xmlns="http://www.w3.org/2000/svg" width="15" height="10" viewBox="0 0 15 10" fill="none">
                          <path
                            d="M12.6222 4.38176C12.5582 4.38176 12.4984 4.38176 12.4344 4.38176C8.56253 4.38176 4.69065 4.38176 0.818766 4.38176C0.716312 4.38176 0.613859 4.37785 0.515674 4.40129C0.195508 4.4677 -0.0307435 4.76459 0.00340761 5.05758C0.0418276 5.37791 0.30223 5.60839 0.643741 5.62793C0.712043 5.63183 0.780345 5.63183 0.852917 5.63183C4.71199 5.63183 8.57534 5.63183 12.4344 5.63183C12.4984 5.63183 12.5582 5.63183 12.6649 5.63183C12.5966 5.69824 12.5582 5.73731 12.5155 5.77637C11.38 6.8194 10.2402 7.86243 9.10468 8.90546C8.82293 9.16329 8.79305 9.51878 9.03211 9.77661C9.27117 10.0383 9.68525 10.0774 9.9798 9.86646C10.0268 9.8352 10.0652 9.79614 10.1079 9.75707C11.6489 8.34684 13.19 6.93269 14.7268 5.51855C15.0982 5.17868 15.0982 4.83882 14.7268 4.49895C13.1772 3.077 11.6233 1.65504 10.0737 0.229173C9.86881 0.0416613 9.63829 -0.0481873 9.35228 0.0260353C8.8827 0.147137 8.7034 0.670605 9.0065 1.01437C9.04492 1.06125 9.09187 1.10032 9.13883 1.14329C10.2658 2.1746 11.3885 3.20982 12.5198 4.24113C12.5625 4.28019 12.618 4.29972 12.6649 4.33098C12.6479 4.34269 12.6351 4.36223 12.6222 4.38176Z"
                            fill="currentColor"/>
                        </svg>
                        </a>
                    </div>
                  </div>
                  <div class="fr-author__details">
                    <h4 class="text-24 fw-bold">{{ currency($job_post->regular_price) }}</h4>
                    <div class="fr-author__type d-flex align-items-center">
                      <span>
                        <svg width="12" height="10" viewBox="0 0 12 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M4.68945 5.33337H6.68945V6.00004H4.68945V5.33337Z" fill="#9900FF"/>
                          <path d="M9.23064 5.99999H7.35556V6.33332C7.35556 6.51752 7.20642 6.66666 7.02222 6.66666H4.35556C4.17135 6.66666 4.02222 6.51752 4.02222 6.33332V5.99999H2.14714C1.71615 5.99999 1.33498 5.72525 1.19852 5.3164L0 1.72021V8.99999C0 9.55138 0.448611 9.99999 1 9.99999H10.3778C10.9292 9.99999 11.3778 9.55138 11.3778 8.99999V1.72048L10.1792 5.3164C10.0428 5.72525 9.66163 5.99999 9.23064 5.99999Z" fill="#9900FF"/>
                          <path d="M7.02292 0H4.35625C3.80486 0 3.35625 0.448611 3.35625 1V1.33333H0.574219L1.83142 5.10547C1.877 5.24184 2.00425 5.33333 2.14783 5.33333H4.02292V5C4.02292 4.8158 4.17205 4.66667 4.35625 4.66667H7.02292C7.20712 4.66667 7.35625 4.8158 7.35625 5V5.33333H9.23134C9.37491 5.33333 9.50217 5.24184 9.54774 5.10547L10.805 1.33333H8.02292V1C8.02292 0.448611 7.57431 0 7.02292 0ZM4.02292 1.33333V1C4.02292 0.816059 4.17231 0.666667 4.35625 0.666667H7.02292C7.20686 0.666667 7.35625 0.816059 7.35625 1V1.33333H4.02292Z" fill="#9900FF"/>
                        </svg>
                      </span>
                      <p class="text-14">{{ __('translate.Job type') }}: <span class="fr-author-type--inner">
                        @if ($job_post->job_type == 'Hourly')
                            {{ __('translate.Hourly') }}
                        @elseif ($job_post->job_type == 'Daily')
                            {{ __('translate.Daily') }}
                        @elseif ($job_post->job_type == 'Monthly')
                            {{ __('translate.Monthly') }}
                        @elseif ($job_post->job_type == 'Yearly')
                            {{ __('translate.Yearly') }}
                        @endif
                    </span></p>
                    </div>
                    <div class="fr-author__date">
                      <span>
                        <svg width="11" height="11" viewBox="0 0 11 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path fill-rule="evenodd" clip-rule="evenodd" d="M3.81579 0.513554C3.81579 0.298962 3.64183 0.125 3.42724 0.125C3.21265 0.125 3.03868 0.298962 3.03868 0.513554V1.7167C2.18858 2.14527 1.51228 2.86822 1.14372 3.75163H9.85541C9.48685 2.86823 8.81057 2.14529 7.96048 1.71672V0.513554C7.96048 0.298962 7.78652 0.125 7.57193 0.125C7.35734 0.125 7.18337 0.298962 7.18337 0.513554V1.4222C6.85739 1.33638 6.51514 1.29067 6.16221 1.29067H4.83691C4.484 1.29067 4.14176 1.33638 3.81579 1.42219V0.513554ZM0.836914 5.29067C0.836914 5.03013 0.861825 4.7754 0.909395 4.52874H10.0897C10.1373 4.7754 10.1622 5.03013 10.1622 5.29068V6.87501C10.1622 9.08415 8.37135 10.875 6.16222 10.875H4.83692C2.62778 10.875 0.836914 9.08415 0.836914 6.87501V5.29067ZM5.49955 7.76653C5.78567 7.76653 6.01762 7.53458 6.01762 7.24846C6.01762 6.96234 5.78567 6.73039 5.49955 6.73039C5.21343 6.73039 4.98148 6.96234 4.98148 7.24846C4.98148 7.53458 5.21343 7.76653 5.49955 7.76653ZM8.08965 7.24846C8.08965 7.53458 7.8577 7.76653 7.57158 7.76653C7.28546 7.76653 7.05351 7.53458 7.05351 7.24846C7.05351 6.96234 7.28546 6.73039 7.57158 6.73039C7.8577 6.73039 8.08965 6.96234 8.08965 7.24846ZM3.4272 7.76653C3.71333 7.76653 3.94528 7.53458 3.94528 7.24846C3.94528 6.96234 3.71333 6.73039 3.4272 6.73039C3.14108 6.73039 2.90913 6.96234 2.90913 7.24846C2.90913 7.53458 3.14108 7.76653 3.4272 7.76653Z" fill="#9900FF"/>
                        </svg>
                      </span>
                      <span class="fr-author__date--text text-14">
                        @if ($job_post->created_at->diffInDays() == 0)
                            {{ __('translate.Today') }}
                        @else
                            {{ $job_post->created_at->diffInDays() }}  {{ __('translate.days ago') }}
                        @endif
                      </span>
                    </div>
                  </div>
              </div>
        </div>

        <!-- form-section -->
         <div class="fr-job-form mt-30">
              <div class="fr-job-heading">
                <h6 class="text-18 fw-semibold">{{ __('translate.Proposal Milestone') }}</h6>
              </div>
            <form action="{{route('seller.update-by-project',$job_requests->id)}}" class="fr-form__container pt-20" method="post">
                @csrf
              <div class="row g-3">
                <div class="col-lg-12">
                    <div class="fr-form__wrapper">
                        <div class="fr-form__wrapper-container">
                          <label for="deliveryTime" class="form-label fr-form-label">{{ __('translate.Select Delivery Time') }}*</label>
                          <select id="deliveryTime" autocomplete="off" class="fr-form-input form-select" name="delivery_time">
                            <option>{{ __('translate.Select') }}</option>
                            @for ($i = 1; $i <= 100; $i++)
                                <option {{ $job_requests->delivery_time ==  $i . "days" ? 'selected' : '' }} value="{{ $i }}days">{{ $i }} {{ __('translate.days') }}</option>
                            @endfor
                          </select>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="fr-form__wrapper">
                        <div class="fr-form__wrapper-container">
                          <label for="frMassage" class="form-label fr-form-label">{{ __('translate.Write Cover Letter') }}*</label>
                          <textarea name="fr_massage" id="frMassage" class="fr-form-textarea shadow-none" rows="8" placeholder="Write Cover Letter here">{{$job_requests->description}}</textarea>
                        </div>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="content-section pt-3">
                      <div class="content active" id="tab2">
                        <div class="row g-3">
                          <div class="col-lg-12">
                            <div class="fr-form__wrapper">
                              <div class="fr-form__wrapper-container">
                                @if ($job_post->job_type == 'Hourly')
                                    <label for="frProject" class="form-label fr-form-label">{{ __('translate.Hourly Rate') }}*</label>
                                @else
                                    <label for="frProject" class="form-label fr-form-label">{{ __('translate.Amount') }}*</label>
                                @endif

                                <input type="text" name="fr_Project_amount" id="frProject" value="{{$job_requests->project_price}}" class="fr-form-input" placeholder="$00.00">
                              </div>
                            </div>
                          </div>

                        </div>
                      </div>
                    </div>
                </div>

              </div>

              <div class="fr-total">
                <div class="fr-total__main">
                    <div class="fr-total__item">
                       @if ($job_post->job_type == 'Hourly')
                            <p class="text-16">{{ __('translate.Hourly Rate') }}</p>
                        @else
                            <p class="text-16">{{ __('translate.Total Price of Project') }}</p>
                        @endif
                      <h6 class="text-16" id="totalPrice">${{$job_requests->project_price}}</h6>
                    </div>
                    <div class="fr-total__item d-none">
                      <p class="text-16">{{ __('translate.Freelancer Service Fee') }}</p>
                      <h6 class="text-16" id="serviceFee">$20.00</h6>
                    </div>
                    <div class="fr-total__item d-none">
                      <p class="text-16">{{ __('translate.You’ll Receive') }}</p>
                      <h6 class="text-16" id="finalTotal">$0.00</h6>
                    </div>
                    <div class="fr-total__button">
                      <button class="w-btn-secondary-lg">
                        {{ __('translate.Update Proposal') }}
                      </button>
                    </div>
                </div>

            </div>

            </form>


         </div>
      </div>
    </section>
    <!-- job-milestone-section-End -->




  </main>
  <!-- Main End -->
@endsection
@push('js_section')
<script>
    // Update the hidden input when a radio button is selected
    document.querySelectorAll('input[name="fr_radio"]').forEach(radio => {
        radio.addEventListener('change', function() {
        document.getElementById('activeTab').value = this.value;
        });
    });

    function updateTotals() {
        const milestoneAmounts = document.querySelectorAll('input[name="fr_Amount[]"]');
        let totalMilestoneSum = 0;

        milestoneAmounts.forEach(input => {
          const value = parseFloat(input.value) || 0;
          totalMilestoneSum += value;
        });

        const projectAmount = parseFloat(document.getElementById('frProject').value) || 0;
        totalMilestoneSum += projectAmount;

        const serviceFee = parseFloat(document.getElementById('serviceFee').textContent.replace('$', '')) || 0;
        const finalTotal = totalMilestoneSum - serviceFee;

        document.getElementById('totalPrice').textContent = `$${totalMilestoneSum.toFixed(2)}`;
        document.getElementById('finalTotal').textContent = `$${finalTotal.toFixed(2)}`;
      }

      document.addEventListener('input', function(event) {
        if (event.target.name === 'fr_Amount[]' || event.target.id === 'frProject') {
          updateTotals();
        }
      });

      document.getElementById('addMilestone').addEventListener('click', function() {
        updateTotals();
      });

      document.querySelectorAll('input[name="fr_radio"]').forEach(radio => {
        radio.addEventListener('change', function() {
          // Reset all calculations
          document.getElementById('totalPrice').textContent = '$0.00';
          document.getElementById('finalTotal').textContent = '$0.00';

          // Optionally reset milestone inputs if needed
          const milestoneInputs = document.querySelectorAll('input[name="fr_Amount[]"]');
          milestoneInputs.forEach(input => {
            input.value = '';
          });

          // Reset project amount input
          document.getElementById('frProject').value = '';
        });
      });




    document.getElementById('addMilestone').addEventListener('click', function () {
      const milestoneContainer = document.getElementById('milestoneContainer');

      const newMilestone = document.createElement('div');
      newMilestone.classList.add('col-lg-6');
      newMilestone.innerHTML = `
        <div class="fr-form__wrapper">
          <div class="fr-form__wrapper-container">
            <label for="frDesc" class="form-label fr-form-label">{{ __('translate.Description') }}*</label>
            <input type="text" name="fr_Desc[]" class="fr-form-input" placeholder="Description here">
          </div>
        </div>
      `;
      milestoneContainer.appendChild(newMilestone);

      const newMilestone2 = document.createElement('div');
      newMilestone2.classList.add('col-lg-6');
      newMilestone2.innerHTML = `
        <div class="fr-form-content">
          <div class="fr-form__wrapper fr-form__wrapper--3">
            <div class="fr-form__wrapper-container fr-form__wrapper-container--2">
              <label for="frDue" class="form-label fr-form-label">{{ __('translate.Due Date') }}*</label>
              <input type="date" name="fr_Due[]" class="fr-form-input">
            </div>
            <div class="fr-form__wrapper-container fr-form__wrapper-container--2">
              <label for="frAmount" class="form-label fr-form-label">{{ __('translate.Amount') }}*</label>
              <input type="text" name="fr_Amount[]" class="fr-form-input milestone-amount" placeholder="$00.00">
            </div>
          </div>
          <button type="button" class="content-close-btn d-none d-sm-flex remove-milestone">
            <span>
              <svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M9.24309 0.757377L0.757812 9.24266M9.24309 9.24261L0.757812 0.757324" stroke="#FF3838" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
              </svg>
            </span>
          </button>
        </div>
      `;
      milestoneContainer.appendChild(newMilestone2);

      // Add event listener to remove button
      newMilestone2.querySelector('.remove-milestone').addEventListener('click', function () {
        milestoneContainer.removeChild(newMilestone);
        milestoneContainer.removeChild(newMilestone2);
        updateTotalPrice();
      });

      // Add event listener to update total price
      newMilestone2.querySelector('.milestone-amount').addEventListener('input', updateTotalPrice);
    });
  </script>
@endpush
