@extends('buyer.layout')
@section('title')
    <title>{{ __('Buyer || Message Job Post Applicants') }}</title>
    <style>
        .h-80px {
            height: 80px !important;
        }

        .w-80px {
            width: 80px !important;
        }

        .ob-cover {
            object-fit: cover;
        }

        .fm-cancel-btn {
            background-color: #FF0000 !important;
        }
    </style>
@endsection
@section('front-content')
    <main class="dashboard-main job-chat-main">
        <div class="d-flex flex-column gap-4 ">
            <!-- Content -->
            <div class="fr-massage fr-order">
                <!--chat-detail  -->
                <div class="fr-massage__details h-100">
                    <div class="fr-massage__head">
                        <div class="fr-massage__author">
                            <div class="fr-massage__person-img fr-massage__author-img">
                                @if ($buyer?->image)
                                    <img src="{{ custom_asset($buyer?->image) }}" alt="img" />
                                @else
                                    <img src="{{ custom_asset($general_setting->default_avatar) }}" alt="img" />
                                @endif
                            </div>
                            <div class="fr-massage__author-cotent">
                                <h6 class="text-18"> {{ html_decode($buyer?->name) }}</h6>
                                @if ($last_message)
                                    <p class="text-16 fr-massage__author-date">
                                        {{ $last_message->created_at->diffForHumans() }}</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="fr-massage__main">
                        <div class="fr-conversation">
                            @foreach ($messages as $message)
                                @if ($message->send_by == 'seller')
                                    <div class="fr-support">
                                        <div class="fr-support__content fs-buyer-message">
                                            @if ($message->message)
                                                <div class="fr-support__content-main ">
                                                    <p class="text-dark-300">{!! $message->message !!}</p>
                                                </div>
                                            @endif
                                            <span
                                                class="text-14 text-gray-200">{{ $message->created_at->diffForHumans() }}</span>
                                        </div>
                                    </div>
                                    @if ($message->documents)
                                        <div class="fr-support__items">
                                            @foreach (json_decode($message->documents) as $document)
                                                <a href="{{ route('job-message-download-file', $document->id) }}"
                                                    target="_blank" class="upload_photo">
                                                    <i class="fas fa-link"></i> {{ __('click to download') }}
                                                </a>
                                            @endforeach
                                        </div>
                                    @endif
                                @else
                                    <div class="fr-support fr-vendor">
                                        <div class="fr-support__content fs-seller-message">
                                            @if ($message->message)
                                                <div class="fr-support__content-main">
                                                    <p class="text-dark-300">{!! $message->message !!}</p>
                                                </div>
                                            @endif

                                            <span
                                                class="text-14 text-gray-200">{{ $message->created_at->diffForHumans() }}</span>
                                        </div>
                                        @if ($message->documents)
                                            <div class="fr-support__items">
                                                @foreach (json_decode($message->documents) as $document)
                                                    <a href="{{ route('job-message-download-file', $document->id) }}"
                                                        target="_blank" class="upload_photo">
                                                        <i class="fas fa-link"></i> {{ __('click to download') }}
                                                    </a>
                                                @endforeach
                                            </div>
                                        @endif
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <form action="{{ route('buyer.chat-msg-store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="fr-chatbox">
                                <div class="fr-chatbox-item">
                                    <input type="text" placeholder="{{ __('Type your message') }}" autocomplete="off"
                                        name="message" id="message" class="fr-chatbox-input">
                                    <input type="hidden" name="seller_id" value="{{ $job_request->seller_id }}"
                                        id="seller_id">
                                    <input type="hidden" name="request_id" value="{{ $job_request->id }}" id="request_id">
                                    <input type="hidden" name="file_type" id="file_type">

                                    <div class="fr-chatbox-attach">
                                        <button type="button" id="uploadImageButton">
                                            <span>
                                                <svg width="21" height="20" viewBox="0 0 21 20" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M19.0337 1.97517C16.4164 -0.658391 12.1576 -0.658391 9.53985 1.97517L1.40201 10.1633C-0.46744 12.0445 -0.467317 15.1054 1.40226 16.9865C2.33713 17.9272 3.56473 18.3975 4.79282 18.3974C6.02058 18.3973 7.24884 17.9271 8.18354 16.9865L15.643 9.48076C16.1864 8.93402 16.4858 8.20706 16.4859 7.43384C16.4859 6.66057 16.1866 5.93365 15.6431 5.38675C14.5212 4.25807 12.6959 4.25812 11.5743 5.38696L6.69607 10.2952C6.32156 10.672 6.32156 11.283 6.69599 11.6599C7.07046 12.0368 7.6777 12.0367 8.05225 11.6599L12.9305 6.75157C13.3044 6.37532 13.9128 6.37524 14.2868 6.75149C14.4679 6.93373 14.5677 7.17607 14.5677 7.4338C14.5677 7.69152 14.4679 7.93377 14.2868 8.1161L6.82728 15.6219C5.70546 16.7505 3.88026 16.7507 2.75852 15.6219C1.63679 14.4932 1.6367 12.6566 2.75832 11.5278L10.8961 3.33983C12.7659 1.45861 15.8079 1.45861 17.6774 3.33983C18.5832 4.25106 19.082 5.46269 19.082 6.75141C19.082 8.04013 18.5831 9.25175 17.6774 10.1631L9.53973 18.3513C9.16525 18.7282 9.16525 19.3391 9.53981 19.716C9.72709 19.9045 9.97253 19.9986 10.2179 19.9986C10.4634 19.9986 10.7088 19.9043 10.8961 19.716L19.0336 11.5278C20.3017 10.252 21 8.55575 21 6.75145C21 4.94719 20.3017 3.25094 19.0337 1.97517Z"
                                                        fill="#CACACA" />
                                                </svg>
                                            </span>
                                        </button>
                                        <input type="file" name="documents[]" id="uploadImageInput" multiple
                                            style="display: none;" accept=".pdf,.doc,.docx,.txt">

                                        <button type="button" id="uploadDocumentButton">
                                            <span>
                                                <svg width="23" height="23" viewBox="0 0 23 23" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path
                                                        d="M1.60728 18.8602L1.58628 18.8813C1.30278 18.2618 1.12428 17.5583 1.05078 16.7812C1.12428 17.5478 1.32378 18.2407 1.60728 18.8602Z"
                                                        fill="#CACACA" stroke="#CACACA" stroke-width="0.5" />
                                                    <path
                                                        d="M8.34861 9.79878C9.72881 9.79878 10.8476 8.67993 10.8476 7.29978C10.8476 5.91962 9.72881 4.80078 8.34861 4.80078C6.96845 4.80078 5.84961 5.91962 5.84961 7.29978C5.84961 8.67993 6.96845 9.79878 8.34861 9.79878Z"
                                                        fill="#CACACA" stroke="#CACACA" stroke-width="0.5" />
                                                    <path
                                                        d="M15.8995 1H7.1005C3.2785 1 1 3.2785 1 7.1005V15.8995C1 17.044 1.1995 18.0415 1.588 18.8815C2.491 20.8765 4.423 22 7.1005 22H15.8995C19.7215 22 22 19.7215 22 15.8995V13.495V7.1005C22 3.2785 19.7215 1 15.8995 1ZM20.2885 12.025C19.4695 11.3215 18.1465 11.3215 17.3275 12.025L12.9595 15.7735C12.1405 16.477 10.8175 16.477 9.9985 15.7735L9.6415 15.4795C8.896 14.8285 7.7095 14.7655 6.8695 15.3325L2.9425 17.968C2.7115 17.38 2.575 16.6975 2.575 15.8995V7.1005C2.575 4.1395 4.1395 2.575 7.1005 2.575H15.8995C18.8605 2.575 20.425 4.1395 20.425 7.1005V12.1405L20.2885 12.025Z"
                                                        fill="#CACACA" stroke="#CACACA" stroke-width="0.5" />
                                                </svg>
                                            </span>
                                        </button>
                                        <input type="file" name="documents[]" id="uploadDocumentInput"
                                            style="display: none;" accept="image/*" multiple>
                                    </div>
                                </div>
                                <div class="fr-chatbox-btn">
                                    <button type="submit" class="hero-form-btn">
                                        {{ __('Send') }}
                                    </button>
                                </div>
                            </div>
                            <script>
                                document.getElementById('uploadImageButton').addEventListener('click', function() {
                                    document.getElementById('uploadImageInput').click();
                                    document.getElementById('file_type').value = 'document';
                                });

                                document.getElementById('uploadDocumentButton').addEventListener('click', function() {
                                    document.getElementById('uploadDocumentInput').click();
                                    document.getElementById('file_type').value = 'image';
                                });

                                document.getElementById('uploadImageInput').addEventListener('change', function(event) {
                                    const files = event.target.files;
                                    // Handle image upload
                                });

                                document.getElementById('uploadDocumentInput').addEventListener('change', function(event) {
                                    const files = event.target.files;
                                    // Handle document upload
                                });
                            </script>
                        </form>
                    </div>
                </div>
                <div class="h-100 overflow-y-auto chat-sidebar">
                    <div class="">

                        {{-- if counter need to show, use this section --}}
                        {{-- @if ($job_request->status == 'approved')
                            @if ($job_request->approved_status == 'running')
                                <div class="fr-countdown mb-30">
                                    <h6 class="fr-milestone__heading text-18 fw-semibold">
                                        {{ __('Time Left to Delivery') }}</h6>
                                    <div class="fr-countdown-section">
                                        <div class="fr-countdown__items">
                                            <h6 id="days" class="text-18 text-violet-500">00</h6>
                                            <p class="text-16">{{ __('Days') }}</p>
                                        </div>
                                        <div class="fr-countdown__items">
                                            <h6 id="hours" class="text-18 text-violet-500">00</h6>
                                            <p class="text-16">{{ __('hrs') }}</p>
                                        </div>
                                        <div class="fr-countdown__items">
                                            <h6 id="minutes" class="text-18 text-violet-500">00</h6>
                                            <p class="text-16">{{ __('Min') }}</p>
                                        </div>
                                        <div class="fr-countdown__items">
                                            <h6 id="seconds" class="text-18 text-violet-500">00</h6>
                                            <p class="text-16">{{ __('Sec') }}</p>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endif --}}
                        <div class="fr-milestone-job mb-30">
                            <h6 class="fr-milestone__heading text-18 fw-semibold">{{ __('Job Details') }}</h6>
                            <div class="fr-milestone__author">
                                <div class="fr-milestone__author-img">
                                    <img class="h-80px w-80px ob-cover"
                                        src="{{ custom_asset($job_request->job_post->thumb_image) }}" alt="img">
                                </div>
                                <div class="fr-milestone__author-content">
                                    <h6 class="fr-milestone__author-title text-16 fw-semibold">
                                        {{ html_decode($job_request->job_post->title) }}</h6>
                                    <span
                                        class="fr-milestone__author-detail text-12">{{ currency($job_request->job_post->regular_price) }}</span>
                                </div>
                            </div>
                            <div class="fr-milestone__order">
                                <ul class="fr-milestone__order-list">
                                    <li>
                                        <p>{{ __('Ordered by') }}:</p>
                                    </li>

                                    {{-- <li>
                                        <p>{{ __('Delivery Date') }}:</p>
                                    </li> --}}

                                    <li>
                                        <p>{{ __('Hired Amount') }}:</p>
                                    </li>

                                    <li>
                                        <p class="pt-2">{{ __('Status') }}:</p>
                                    </li>
                                </ul>
                                <ul class="fr-milestone__order-list">
                                    <li>
                                        <p class="text-dark-300">{{ $job_request?->seller?->name }}</p>
                                    </li>

                                    {{-- <li>
                                        <p class="text-dark-300">
                                            @if ($job_request->status == 'approved')
                                                @php
                                                    $deliverydays = (int) filter_var(
                                                        $job_request->delivery_time,
                                                        FILTER_SANITIZE_NUMBER_INT,
                                                    );

                                                @endphp

                                                {{ \Carbon\Carbon::now()->addDays($deliverydays)->format('d M Y') }}
                                            @else
                                                {{ html_decode($job_request->delivery_time) }}
                                            @endif
                                        </p>
                                    </li> --}}

                                    <li>{{ currency($job_request->job_post->regular_price) }}</li>

                                    <li>
                                        @if ($job_request->status == 'approved')
                                            @if ($job_request->approved_status == 'approved')
                                                <span class="status-badge in-progress">{{ __('Completed') }}</span>
                                            @elseif ($job_request->approved_status == 'cancel')
                                                <span class="status-badge pending">{{ __('Canceled') }}</span>
                                            @else
                                            <span class="status-badge in-progress">{{ __('Hired') }}</span>
                                            @endif
                                        @elseif ($job_request->status == 'pending')
                                            <span class="status-badge pending">{{ __('Pending') }}</span>
                                        @else
                                            <span class="status-badge canceled">{{ __('Canceled') }}</span>
                                        @endif
                                    </li>

                                </ul>
                            </div>


                            <div class="fr-milestone-button ">
                                @if ($job_request->status == 'pending')
                                    <a data-bs-toggle="modal" data-bs-target="#applicationApproval"
                                        href="javascript:;">
                                        <button class="hero-form-btn">
                                            {{ __('Hire Now') }}
                                        </button>
                                    </a>
                                @endif

                                @if ($job_request->status == 'approved')
                                    @if ($job_request->approved_status !== 'approved')
                                        <a data-bs-toggle="modal" data-bs-target="#cancelModal" href="javascript:;"
                                            class="pt-3">
                                            <button class="w-btn-secondary-lg fm-cancel-btn">
                                                {{ __('Cancel Order') }}
                                            </button>
                                        </a>

                                        <a data-bs-toggle="modal" data-bs-target="#axceptModal" href="javascript:;"
                                            class="pt-3">
                                            <button class="w-btn-secondary-lg fm-green-btn">
                                                {{ __('Accept order') }}
                                            </button>
                                        </a>


                                    @endif
                                @endif


                            </div>


                        </div>
                        @if ($job_request->status == 'approved')
                            @if ($job_request->approved_status != 'cancel')
                            @if ($job_post_submition_files)

                                <div class="fr-milestone-submission">
                                    <h6 class="fr-milestone__heading text-18 fw-semibold">
                                        {{ __('Downlode Submition File') }}</h6>

                                        <a href="{{ route('download-job-post-submission-file', $job_post_submition_files->id) }}"
                                            target="_blank"
                                            class="w-btn-secondary-lg mt-3">{{ __('Download Submission File') }}</a>
                                </div>
                            @endif
                            @endif
                        @endif
                    </div>
                </div>
            </div>

            <div class="modal fade" id="seeCancleReson" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content ">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">
                                {{ __('Order Cancellation Reason') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <table class="table table-bordered table-striped">
                                <tbody>
                                    <tr>
                                        <td> {{ __('Reason buyer') }}</td>
                                        <td>{!! clean(nl2br(html_decode($job_request->cancel_reason_buyer))) !!}</td>
                                    </tr>
                                    <tr>
                                        <td> {{ __('Reason Seller') }}</td>
                                        <td>{!! clean(nl2br(html_decode($job_request->cancel_reason_seller))) !!}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
            <div class="modal fade" id="cancelModal" tabindex="-1" aria-labelledby="jobDetailsModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="bg-white p-lg-5 rounded-3">
                                <div class="proposal-container">
                                    <div class="proposal-header">
                                        <h3 class="text-dark-300 text-24 fw-bold">
                                            {{ __('Write Your Order Cancellation Reason') }}</h3>
                                    </div>
                                    <form action="{{ route('buyer.job-application-order-cancel', $job_request->id) }}"
                                        method="POST">
                                        @csrf

                                        <div class="d-flex flex-column gap-4">

                                            <div class="proposal-input-container">
                                                <label for="time"
                                                    class="proposal-form-label">{{ __('Reason') }}*</label>
                                                <textarea placeholder="{{ __('Write Cancellation Reason') }}" class="form-textarea shadow-none"
                                                    name="cancel_reason_buyer" required></textarea>
                                            </div>


                                            <div class="d-flex gap-4 align-items-center justify-content-end">
                                                <button type="button" class="w-btn-gray-sm" data-bs-dismiss="modal">
                                                    {{ __('Cancel') }}
                                                </button>
                                                <button class="w-btn-secondary-sm">
                                                    {{ __('Submit Request') }}
                                                </button>
                                            </div>

                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="applicationApproval" tabindex="-1" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('Approval Confirmation') }}
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p>{{ __('Are you realy want to approve this item?') }}</p>
                        </div>
                        <div class="modal-footer">
                            <form action="{{ route('buyer.job-application-approval', $job_request->id) }}" method="POST"
                                class="delet_modal_form">
                                @csrf
                                @method('PUT')

                                <button type="button" class="btn btn-secondary"
                                    data-bs-dismiss="modal">{{ __('Close') }}</button>
                                <button type="submit" class="btn btn-primary">{{ __('Yes, Approved') }}</button>

                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal fade" id="axceptModal" tabindex="-1" aria-labelledby="exampleModalLabelexampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">{{ __('Approval Confirmation') }}
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <p>{{ __('Do you really want to approve this submission?') }}</p>
                        </div>
                        <div class="modal-footer">
                            <form action="{{ route('buyer.job-application-order-approved', $job_request->id) }}"
                                method="POST" class="delet_modal_form">
                                @csrf
                                @method('PUT')

                                <button type="button" class="btn btn-secondary"
                                    data-bs-dismiss="modal">{{ __('Close') }}</button>
                                <button type="submit" class="btn btn-primary">{{ __('Yes, Approved') }}</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            </section>
    </main>

    <!-- Video Modal -->
    <div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="videoModalLabel">{{ __('Video Call') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p id="videoMessage">{{ __('Checking Zoom ID') }}...</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">{{ __('Close') }}</button>
                    <button type="button" class="btn btn-primary"
                        id="startZoomCall">{{ __('Start Video Call') }}</button>
                </div>
            </div>
        </div>
    </div>



@endsection


@push('js_section')
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Parse the delivery date from the database format
            const deliveryDateTime = new Date("{{ $job_request->delivery_date_time }}").getTime();

            const now = new Date().getTime();
            console.log("Delivery Date Time:", deliveryDateTime);
            console.log("Current Time:", now);

            if (isNaN(deliveryDateTime) || deliveryDateTime <= now) {
                document.querySelector(".fr-countdown-section").innerHTML = "<p>Invalid or past delivery date!</p>";
                return;
            }

            const countdownInterval = setInterval(() => {
                const now = new Date().getTime();
                const timeRemaining = deliveryDateTime - now;

                if (timeRemaining > 0) {
                    const days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));
                    const hours = Math.floor((timeRemaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    const minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);

                    document.getElementById("days").textContent = days.toString().padStart(2, '0');
                    document.getElementById("hours").textContent = hours.toString().padStart(2, '0');
                    document.getElementById("minutes").textContent = minutes.toString().padStart(2, '0');
                    document.getElementById("seconds").textContent = seconds.toString().padStart(2, '0');
                } else {
                    clearInterval(countdownInterval);
                    document.querySelector(".fr-countdown-section").innerHTML = "<p>Time's up!</p>";
                }
            }, 1000);
        });
    </script>
@endpush
