@extends('admin.master_layout')
@section('title')
    <title>{{ __('Buyer || Message Job Post Applicants') }}</title>
@endsection
@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('User Message') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Dashboard') }} >> {{ __('User Message') }}</p>
    <style>
        .bg-light {
            background-color: #f1f1f1 !important;
        }

        .bg-primary {
            background-color: #007bff !important;
        }

        .rounded {
            border-radius: 15px;
        }
    </style>
@endsection

@section('body-content')
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">

                            <div class="crancy-table crancy-table--v3 mg-top-30">

                                <div class="crancy-customer-filter">
                                    <div class="crancy-customer-filter__single crancy-customer-filter__single--csearch">
                                        <div class="crancy-header__form crancy-header__form--customer">
                                            <h4 class="crancy-product-card__title">{{ __('User Message') }}
                                            </h4>
                                        </div>
                                    </div>
                                </div>

                                <!-- crancy Table -->
                                <div id="crancy-table__main_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">
                                    <table class="crancy-table__main crancy-table__main-v3 dataTable no-footer"
                                        id="dataTable">
                                        <!-- Table Head -->
                                        <thead class="crancy-table__head">
                                            <tr>
                                                <th class="crancy-table__column-1 crancy-table__h1 sorting sorting_asc">
                                                    <div class="crancy-wc__checkbox">
                                                        <span>{{ __('Serial') }}</span>
                                                    </div>
                                                </th>

                                                <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                    {{ __('Conversation') }}
                                                </th>
                                                <th>
                                                    {{ __('Seller Name') }}
                                                </th>
                                                <th>
                                                    {{ __('Buyer Name') }}
                                                </th>
                                                <th>
                                                    {{ __('Restricted Key') }}
                                                </th>
                                                <th class="crancy-table__column-3 crancy-table__h3 sorting">
                                                    {{ __('translate.Action') }}
                                                </th>
                                            </tr>
                                        </thead>

                                        <!-- Table Body -->
                                        <tbody class="crancy-table__body">
                                            @forelse ($groupedMessages as $group)
                                                @php
                                                    if (is_array($group)) {
                                                        $key = $group['key'];
                                                        $messages = $group['messages'];
                                                    } else {
                                                        $key = $loop->key;
                                                        $messages = $group;
                                                    }

                                                    $parts = explode('-', $key);
                                                    $buyerId = $parts[0] ?? null;
                                                    $sellerId = $parts[1] ?? null;
                                                    $jobRequestId = $parts[2] ?? null;

                                                    if (!$buyerId || !$sellerId || !$jobRequestId) {
                                                        continue;
                                                    }

                                                    $buyerName = $users[$buyerId] ?? 'Unknown Buyer';
                                                    $sellerName = $users[$sellerId] ?? 'Unknown Seller';
                                                    $restrictedCount = $restrictedCounts[$key] ?? 0;
                                                    $unseenCount = $unseenCounts[$key] ?? 0;
                                                    $jobSlug = $messages->first()->job_request->title ?? 'N/A';
                                                @endphp

                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>

                                                    <td>
                                                        <a href="{{ route('admin.livechat.show', [
                                                            'buyer_id' => $buyerId,
                                                            'seller_id' => $sellerId,
                                                            'job_request_id' => $jobRequestId,
                                                        ]) }}"
                                                            class="text-decoration-none fw-semibold text-dark">
                                                            {{ $buyerName }} - {{ $sellerName }}
                                                            ({{ $jobSlug }})
                                                        </a>
                                                    </td>

                                                    <td>{{ $sellerName }}</td>
                                                    <td>{{ $buyerName }}</td>

                                                    <td>
                                                        @if ($restrictedCount > 0)
                                                            <span class="badge bg-danger">
                                                                {{ $restrictedCount }}
                                                                {{ \Illuminate\Support\Str::plural('word', $restrictedCount) }}
                                                            </span>
                                                        @else
                                                            <span class="badge bg-secondary">0</span>
                                                        @endif
                                                    </td>

                                                    <td>
                                                        <a href="{{ route('admin.livechat.show', [
                                                            'buyer_id' => $buyerId,
                                                            'seller_id' => $sellerId,
                                                            'job_request_id' => $jobRequestId,
                                                        ]) }}"
                                                            class="btn btn-xl btn-primary chat-btn position-relative">
                                                            <i class="fas fa-message"></i>

                                                            @if ($unseenCount > 0)
                                                                <span
                                                                    class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                                                    {{ $unseenCount }}
                                                                </span>
                                                            @endif
                                                        </a>
                                                    </td>
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="6" class="text-center text-muted">
                                                        {{ __('No conversations found.') }}
                                                    </td>
                                                </tr>
                                            @endforelse
                                        </tbody>

                                    </table>
                                </div>

                                <!-- End crancy Table -->
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
@endsection

@push('js_section')
    <script>
        "use strict"

        function itemDeleteConfrimation(id) {
            $("#item_delect_confirmation").attr("action", '{{ url('admin/delete-contact-message/') }}' + "/" + id)
        }
    </script>
@endpush
