<?php

namespace Modules\LiveChat\App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\LiveChat\App\Models\RestrictedKeyword;

class RestrictedKeywordController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $restricteds = RestrictedKeyword::latest('id')->get();
        return view('livechat::restricted.index', compact('restricteds'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('livechat::restricted.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'keyword_name' => 'required|max:255'
        ]);
        $restricted = new RestrictedKeyword();
        $restricted->keyword_name = $request->keyword_name;
        $restricted->save();

        $notify_message = trans('translate.Created Successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->route('admin.restricted.edit', ['restricted' => $restricted->id, 'lang_code' => admin_lang()])->with($notify_message);
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $restricted = RestrictedKeyword::findOrFail($id);
        return view('livechat::restricted.edit', compact('restricted'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'keyword_name' => 'required|max:255'
        ]);

        $restricted = RestrictedKeyword::findOrFail($id);
        $restricted->keyword_name = $request->keyword_name;
        $restricted->save();

        $notify_message = trans('translate.Updated Successfully');
        $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
        return redirect()->route('admin.restricted.edit', ['restricted' => $restricted->id, 'lang_code' => admin_lang()])->with($notify_message);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        try {
            $restricted = RestrictedKeyword::findOrFail($id);
            $restricted->delete();
            $notify_message = trans('translate.Delete Successfully');
            $notify_message = array('message' => $notify_message, 'alert-type' => 'success');
            return redirect()->route('admin.restricted.index')->with($notify_message);
        } catch (\Exception $e) {
            $notify_message = array('message' => 'Delete failed: ' . $e->getMessage(), 'alert-type' => 'error');
            return redirect()->route('admin.restricted.index')->with($notify_message);
        }
    }
}
