@extends('admin.master_layout')
@section('title')
    <title>{{ __('translate.All Services') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('translate.All Services') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Manage Service') }} >> {{ __('translate.All Service') }}</p>
@endsection

@section('body-content')
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">
                            <div class="crancy-table crancy-table--v3 mt-4 bg-white p-4 rounded shadow-sm">
                                <form class="row g-3 align-items-end">
                                    <!-- Title Search -->
                                    <div class="col-md-4">
                                        <label for="filterTitle" class="form-label">{{ __('Title') }}</label>
                                        <input type="text" id="filterTitle" name="title" class="form-control"
                                            placeholder="{{ __('Search by title') }}" value="{{ request('title') }}">
                                    </div>

                                    <!-- Seller Filter -->
                                    <div class="col-md-4">
                                        <label for="filterSeller" class="form-label">{{ __('Seller') }}</label>
                                        <select id="filterSeller" name="seller" class="form-select">
                                            <option value="">{{ __('All Sellers') }}</option>
                                            @foreach ($sellers as $seller)
                                                <option value="{{ $seller->id }}"
                                                    {{ request('seller') == $seller->id ? 'selected' : '' }}>
                                                    {{ $seller->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Category Filter -->
                                    <div class="col-md-4">
                                        <label for="filterCategory" class="form-label">{{ __('Category') }}</label>
                                        <select id="filterCategory" name="category" class="form-select">
                                            <option value="">{{ __('All Categories') }}</option>
                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}"
                                                    {{ request('category') == $category->id ? 'selected' : '' }}>
                                                    {{ $category->translate->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <!-- Price Range Filter -->
                                    <div class="col-md-4">
                                        <label class="form-label">{{ __('Price') }}</label>
                                        <div class="d-flex gap-2">
                                            <input type="number" name="price_min" class="form-control"
                                                placeholder="{{ __('Min') }}" value="{{ request('price_min') }}">
                                            <input type="number" name="price_max" class="form-control"
                                                placeholder="{{ __('Max') }}" value="{{ request('price_max') }}">
                                        </div>
                                    </div>

                                    <!-- Status Filter -->
                                    <div class="col-md-4">
                                        <label for="filterStatus" class="form-label">{{ __('Status') }}</label>
                                        <select id="filterStatus" name="status" class="form-select">
                                            <option value="">{{ __('All') }}</option>
                                            <option value="enable" {{ request('status') == 'enable' ? 'selected' : '' }}>
                                                {{ __('Approved') }}
                                            </option>
                                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>
                                                {{ __('Awaiting') }}
                                            </option>
                                        </select>
                                    </div>

                                    <!-- Filter Button -->
                                    <div class="col-md-4 d-grid">
                                        <button type="submit" class="btn btn-primary">{{ __('Filter') }}</button>
                                    </div>
                                </form>
                            </div>


                            <div class="crancy-table crancy-table--v3 mg-top-30">

                                <div class="crancy-customer-filter">
                                    <div
                                        class="crancy-customer-filter__single crancy-customer-filter__single--csearch d-flex items-center justify-between create_new_btn_box">
                                        <div
                                            class="crancy-header__form crancy-header__form--customer create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title">{{ __('translate.All Services') }}</h4>

                                            @can('service_create')
                                                <a href="{{ route('admin.listings.create') }}" class="crancy-btn ">
                                                    <span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                            viewBox="0 0 16 16" fill="none">
                                                            <path d="M8 1V15" stroke="white" stroke-width="2"
                                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                                            <path d="M1 8H15" stroke="white" stroke-width="2"
                                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                                        </svg>
                                                    </span>
                                                    {{ __('translate.Create New') }}</a>
                                            @endcan
                                        </div>
                                    </div>
                                </div>

                                <!-- crancy Table -->
                                <div id="crancy-table__main_wrapper" class=" dt-bootstrap5 no-footer">

                                    <table class="crancy-table__main crancy-table__main-v3  no-footer" id="dataTable1">
                                        <!-- crancy Table Head -->
                                        <thead class="crancy-table__head">
                                            <tr>


                                                <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                    {{ __('translate.Serial') }}
                                                </th>

                                                <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                    {{ __('translate.Seller') }}
                                                </th>

                                                <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                    {{ __('translate.Title') }}
                                                </th>

                                                <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                    {{ __('translate.Category') }}
                                                </th>


                                                <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                    {{ __('translate.Price') }}
                                                </th>

                                                <th class="crancy-table__column-2 crancy-table__h2 sorting">
                                                    {{ __('translate.Visibility') }}
                                                </th>


                                                <th class="crancy-table__column-3 crancy-table__h3 sorting">
                                                    {{ __('translate.Action') }}
                                                </th>

                                            </tr>
                                        </thead>

                                        <!-- crancy Table Body -->
                                        <tbody class="crancy-table__body">
                                            @foreach ($listings as $index => $listing)
                                                <tr class="odd">

                                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                                        <h4 class="crancy-table__product-title">{{ ++$index }}</h4>
                                                    </td>

                                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                                        <h4 class="crancy-table__product-title"><a
                                                                href="{{ route('admin.seller-show', $listing->seller_id) }}">{{ html_decode($listing?->seller?->name) }}</a>
                                                        </h4>
                                                    </td>

                                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                                        <h4 class="crancy-table__product-title"><a target="_blank"
                                                                href="{{ route('service', $listing->slug) }}">{{ html_decode($listing->translate->title) }}</a>
                                                        </h4>
                                                    </td>


                                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                                        <h4 class="crancy-table__product-title">
                                                            {{ html_decode($listing?->category?->translate?->name) }}</h4>
                                                    </td>

                                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                                        <h4 class="crancy-table__product-title">
                                                            @if ($listing->offer_price)
                                                                {{ currency($listing->offer_price) }}
                                                                dfsfsd
                                                            @else
                                                                {{ currency($listing?->listing_package?->basic_price) }}
                                                            @endif

                                                        </h4>
                                                    </td>


                                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                                        @if ($listing->approved_by_admin == 'approved')
                                                            <span
                                                                class="badge bg-success">{{ __('translate.Approved') }}</span>
                                                        @else
                                                            <span
                                                                class="badge bg-danger">{{ __('translate.Awaiting') }}</span>
                                                        @endif
                                                    </td>


                                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                                        <div class="dropdown">
                                                            <button class="crancy-btn dropdown-toggle" type="button"
                                                                id="dropdownMenuButton1" data-bs-toggle="dropdown"
                                                                aria-expanded="false">
                                                                {{ __('translate.Action') }}
                                                            </button>
                                                            <ul class="dropdown-menu"
                                                                aria-labelledby="dropdownMenuButton1">

                                                                @can('service_edit')
                                                                    <li>
                                                                        <a href="{{ route('admin.listings.edit', ['listing' => $listing->id, 'lang_code' => admin_lang()]) }}"
                                                                            class=" dropdown-item"><i class="fas fa-edit"></i>
                                                                            {{ __('translate.Edit') }}</a>

                                                                    </li>
                                                                @endcan

                                                                @can('service_gallery_item_view')
                                                                    <li>
                                                                        <a href="{{ route('admin.listings-gallery', $listing->id) }}"
                                                                            class=" dropdown-item"><i
                                                                                class="fas fa-images"></i>
                                                                            {{ __('translate.Gallery') }}</a>
                                                                    </li>
                                                                @endcan

                                                                @can('service_delete')
                                                                    <li>
                                                                        <a onclick="itemDeleteConfrimation({{ $listing->id }})"
                                                                            href="javascript:;" data-bs-toggle="modal"
                                                                            data-bs-target="#exampleModal"
                                                                            class="dropdown-item"><i class="fas fa-trash"></i>
                                                                            {{ __('translate.Delete') }}</a>
                                                                    </li>
                                                                @endcan




                                                            </ul>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach

                                        </tbody>
                                        <!-- End crancy Table Body -->
                                    </table>

                                    <div class="mt-4 d-flex justify-content-center">
                                        {{ $listings->links('pagination::bootstrap-4') }}
                                    </div>
                                </div>
                                <!-- End crancy Table -->
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->


    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">{{ __('translate.Delete Confirmation') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>{{ __('translate.Are you realy want to delete this item?') }}</p>
                </div>
                <div class="modal-footer">
                    <form action="" id="item_delect_confirmation" class="delet_modal_form" method="POST">
                        @csrf
                        @method('DELETE')

                        <button type="button" class="btn btn-secondary"
                            data-bs-dismiss="modal">{{ __('translate.Close') }}</button>
                        <button type="submit" class="btn btn-primary">{{ __('translate.Yes, Delete') }}</button>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('js_section')
    <script>
        "use strict"

        function itemDeleteConfrimation(id) {
            $("#item_delect_confirmation").attr("action", '{{ url('admin/listing/listings/') }}' + "/" + id)
        }
    </script>
@endpush
