<?php

namespace Modules\JobPost\App\Models;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Modules\JobPost\Entities\JobPost;
use Modules\JobPost\Http\Requests\JobPostRequest;

class JobPostMessage extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     */
    protected $guarded = [];

    public function buyer()
    {
        return $this->belongsTo(User::class, 'buyer_id')->select('id', 'name', 'designation', 'email', 'phone', 'image');
    }

    public function seller()
    {
        return $this->belongsTo(User::class, 'seller_id')->select('id', 'name', 'designation', 'email', 'phone', 'image');
    }

    public function documents()
    {
        return $this->hasMany(JobPostMessagesDocument::class, 'message_id');
    }

    public function job_request()
    {
        return $this->belongsTo(JobPost::class, 'job_request_id');
    }
}
