@extends('admin.master_layout')
@section('title')
    <title>{{ __('translate.Edit Admin') }}</title>
@endsection

@section('body-header')
    <h3 class="crancy-header__title m-0">{{ __('translate.Edit Admin') }}</h3>
    <p class="crancy-header__text">{{ __('translate.Admin Management') }} >> {{ __('translate.Edit Admin') }}</p>
@endsection

@section('body-content')
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="{{ route('admin.adminteam.update', $admin->id) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title">{{ __('translate.Edit Admin') }}</h4>

                                                <a href="{{ route('admin.adminteam.index') }}" class="crancy-btn "><i
                                                        class="fa fa-list"></i> {{ __('translate.Admin List') }}</a>
                                            </div>


                                            <div class="row mg-top-30">

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Name') }} * </label>
                                                        <input class="crancy__item-input" type="text" name="name"
                                                            id="name" value="{{ $admin->name }}">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Email') }} *
                                                        </label>
                                                        <input class="crancy__item-input" type="text" name="email"
                                                            id="email" value="{{ $admin->email }}">
                                                    </div>
                                                </div>


                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <div class="d-flex align-items-center mb-2">
                                                            <input type="checkbox" id="change_password_toggle"
                                                                style="margin-right:8px;" name="change_password_toggle">
                                                            <label for="change_password_toggle"
                                                                class="crancy__item-label mb-0" style="cursor:pointer;">
                                                                {{ __('translate.Change Password') }} ?
                                                            </label>
                                                        </div>
                                                        <div id="password_field_wrapper" style="display:none;">
                                                            <label class="crancy__item-label">{{ __('translate.Password') }}
                                                                *</label>
                                                            <input class="crancy__item-input" type="password"
                                                                name="password" id="password"
                                                                value="{{ old('password') }}">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Roles') }} *
                                                        </label>
                                                        <select class="crancy__item-input select2" name="role_id[]"
                                                            id="role_id" multiple>
                                                            @foreach ($roles as $role)
                                                                <option value="{{ $role->id }}"
                                                                    {{ in_array($role->id, $adminRoles) ? 'selected' : '' }}>
                                                                    {{ $role->display_name }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label">{{ __('translate.Status') }} </label>
                                                        <div
                                                            class="crancy-ptabs__notify-switch  crancy-ptabs__notify-switch--two">
                                                            <label class="crancy__item-switch">
                                                                <input name="status" type="checkbox"
                                                                    {{ $admin->status == App\Models\Admin::STATUS_ACTIVE ? 'checked' : '' }}>
                                                                <span
                                                                    class="crancy__item-switch--slide crancy__item-switch--round"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>




                                            @can('admin_edit')
                                            <button class="crancy-btn mg-top-25"
                                                type="submit">{{ __('translate.Edit Admin') }}</button>
                                            @endcan

                                        </div>
                                        <!-- End Product Card -->
                                    </div>





                                </div>



                            </form>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
@endsection

@push('style_section')
    <link rel="stylesheet" href="{{ asset('global/select2/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('global/select2/custom.css') }}">
@endpush

@push('js_section')
    <script src="{{ asset('global/select2/select2.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            $('#role_id').select2();
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var toggle = document.getElementById('change_password_toggle');
            var passwordField = document.getElementById('password_field_wrapper');
            toggle.addEventListener('change', function() {
                if (toggle.checked) {
                    passwordField.style.display = 'block';
                } else {
                    passwordField.style.display = 'none';
                    document.getElementById('password').value = '';
                }
            });
        });
    </script>
@endpush
