<?php


            // Job Management
            [
                'name' => 'job_management',
                'display_name' => 'Job Management',
                'module' => 'job',
                'description' => 'Manage job posts and related settings',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_index',
                'display_name' => 'Job Post Index',
                'module' => 'job',
                'description' => 'View job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_create',
                'display_name' => 'Create Job Post',
                'module' => 'job',
                'description' => 'Create new job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_store',
                'display_name' => 'Store Job Post',
                'module' => 'job',
                'description' => 'Store new job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_show',
                'display_name' => 'Show Job Post',
                'module' => 'job',
                'description' => 'View specific job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_edit',
                'display_name' => 'Edit Job Post',
                'module' => 'job',
                'description' => 'Edit job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_update',
                'display_name' => 'Update Job Post',
                'module' => 'job',
                'description' => 'Update job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_destroy',
                'display_name' => 'Delete Job Post',
                'module' => 'job',
                'description' => 'Delete job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_published',
                'display_name' => 'Publish Job Post',
                'module' => 'job',
                'description' => 'Publish job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_banned',
                'display_name' => 'Ban Job Post',
                'module' => 'job',
                'description' => 'Ban job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_rejected',
                'display_name' => 'Reject Job Post',
                'module' => 'job',
                'description' => 'Reject job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Job Post Category Management
            [
                'name' => 'jobpostcategory_management',
                'display_name' => 'Job Post Category Management',
                'module' => 'jobpostcategory',
                'description' => 'Manage job post categories',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_index',
                'display_name' => 'Job Post Category Index',
                'module' => 'jobpostcategory',
                'description' => 'View job post categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_create',
                'display_name' => 'Create Job Post Category',
                'module' => 'jobpostcategory',
                'description' => 'Create new job post categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_store',
                'display_name' => 'Store Job Post Category',
                'module' => 'jobpostcategory',
                'description' => 'Store new job post categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_show',
                'display_name' => 'Show Job Post Category',
                'module' => 'jobpostcategory',
                'description' => 'View specific job post category',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_edit',
                'display_name' => 'Edit Job Post Category',
                'module' => 'jobpostcategory',
                'description' => 'Edit job post categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_update',
                'display_name' => 'Update Job Post Category',
                'module' => 'jobpostcategory',
                'description' => 'Update job post categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_destroy',
                'display_name' => 'Delete Job Post Category',
                'module' => 'jobpostcategory',
                'description' => 'Delete job post categories',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_import',
                'display_name' => 'Import Job Post Categories',
                'module' => 'jobpostcategory',
                'description' => 'Import job post categories from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostcategory_export',
                'display_name' => 'Export Job Post Categories',
                'module' => 'jobpostcategory',
                'description' => 'Export job post categories to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Job Type Management
            [
                'name' => 'jobtype_management',
                'display_name' => 'Job Type Management',
                'module' => 'jobtype',
                'description' => 'Manage job types',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_index',
                'display_name' => 'Job Type Index',
                'module' => 'jobtype',
                'description' => 'View job types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_create',
                'display_name' => 'Create Job Type',
                'module' => 'jobtype',
                'description' => 'Create new job types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_store',
                'display_name' => 'Store Job Type',
                'module' => 'jobtype',
                'description' => 'Store new job types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_show',
                'display_name' => 'Show Job Type',
                'module' => 'jobtype',
                'description' => 'View specific job type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_edit',
                'display_name' => 'Edit Job Type',
                'module' => 'jobtype',
                'description' => 'Edit job types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_update',
                'display_name' => 'Update Job Type',
                'module' => 'jobtype',
                'description' => 'Update job types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_destroy',
                'display_name' => 'Delete Job Type',
                'module' => 'jobtype',
                'description' => 'Delete job types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_import',
                'display_name' => 'Import Job Types',
                'module' => 'jobtype',
                'description' => 'Import job types from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobtype_export',
                'display_name' => 'Export Job Types',
                'module' => 'jobtype',
                'description' => 'Export job types to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Schedule Management
            [
                'name' => 'schedule_management',
                'display_name' => 'Schedule Management',
                'module' => 'schedule',
                'description' => 'Manage schedules',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_index',
                'display_name' => 'Schedule Index',
                'module' => 'schedule',
                'description' => 'View schedules',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_create',
                'display_name' => 'Create Schedule',
                'module' => 'schedule',
                'description' => 'Create new schedules',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_store',
                'display_name' => 'Store Schedule',
                'module' => 'schedule',
                'description' => 'Store new schedules',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_show',
                'display_name' => 'Show Schedule',
                'module' => 'schedule',
                'description' => 'View specific schedule',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_edit',
                'display_name' => 'Edit Schedule',
                'module' => 'schedule',
                'description' => 'Edit schedules',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_update',
                'display_name' => 'Update Schedule',
                'module' => 'schedule',
                'description' => 'Update schedules',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_destroy',
                'display_name' => 'Delete Schedule',
                'module' => 'schedule',
                'description' => 'Delete schedules',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_import',
                'display_name' => 'Import Schedule',
                'module' => 'schedule',
                'description' => 'Import schedules from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_demo_download',
                'display_name' => 'Schedule Demo Download',
                'module' => 'schedule',
                'description' => 'Download schedule demo file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'schedule_export',
                'display_name' => 'Export Schedule',
                'module' => 'schedule',
                'description' => 'Export schedules to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],



            // Job Location Type Management
            [
                'name' => 'joblocationtype_management',
                'display_name' => 'Job Location Type Management',
                'module' => 'joblocationtype',
                'description' => 'Manage job location types',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_index',
                'display_name' => 'Job Location Type Index',
                'module' => 'joblocationtype',
                'description' => 'View job location types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_create',
                'display_name' => 'Create Job Location Type',
                'module' => 'joblocationtype',
                'description' => 'Create new job location types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_store',
                'display_name' => 'Store Job Location Type',
                'module' => 'joblocationtype',
                'description' => 'Store new job location types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_show',
                'display_name' => 'Show Job Location Type',
                'module' => 'joblocationtype',
                'description' => 'View specific job location type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_edit',
                'display_name' => 'Edit Job Location Type',
                'module' => 'joblocationtype',
                'description' => 'Edit job location types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_update',
                'display_name' => 'Update Job Location Type',
                'module' => 'joblocationtype',
                'description' => 'Update job location types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_destroy',
                'display_name' => 'Delete Job Location Type',
                'module' => 'joblocationtype',
                'description' => 'Delete job location types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_import',
                'display_name' => 'Import Job Location Types',
                'module' => 'joblocationtype',
                'description' => 'Import job location types from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_import_store',
                'display_name' => 'Store Imported Job Location Types',
                'module' => 'joblocationtype',
                'description' => 'Store imported job location types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_demo_download',
                'display_name' => 'Job Location Type Demo Download',
                'module' => 'joblocationtype',
                'description' => 'Download job location type demo file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'joblocationtype_export',
                'display_name' => 'Export Job Location Types',
                'module' => 'joblocationtype',
                'description' => 'Export job location types to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Certification Management

            [
                'name' => 'certification_management',
                'display_name' => 'Certification Management',
                'module' => 'certification',
                'description' => 'Manage certifications',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'certification_index',
                'display_name' => 'Certification Index',
                'module' => 'certification',
                'description' => 'View certifications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_create',
                'display_name' => 'Create Certification',
                'module' => 'certification',
                'description' => 'Create new certifications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_store',
                'display_name' => 'Store Certification',
                'module' => 'certification',
                'description' => 'Store new certifications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_show',
                'display_name' => 'Show Certification',
                'module' => 'certification',
                'description' => 'View specific certification',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_edit',
                'display_name' => 'Edit Certification',
                'module' => 'certification',
                'description' => 'Edit certifications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_update',
                'display_name' => 'Update Certification',
                'module' => 'certification',
                'description' => 'Update certifications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_destroy',
                'display_name' => 'Delete Certification',
                'module' => 'certification',
                'description' => 'Delete certifications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_import',
                'display_name' => 'Import Certifications',
                'module' => 'certification',
                'description' => 'Import certifications from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_import_store',
                'display_name' => 'Store Imported Certifications',
                'module' => 'certification',
                'description' => 'Store imported certifications',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_demo_download',
                'display_name' => 'Certification Demo Download',
                'module' => 'certification',
                'description' => 'Download certification demo file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'certification_export',
                'display_name' => 'Export Certifications',
                'module' => 'certification',
                'description' => 'Export certifications to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],




            // Salary Type Management
            [
                'name' => 'salarytype_management',
                'display_name' => 'Salary Type Management',
                'module' => 'salarytype',
                'description' => 'Manage salary types',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'salarytype_index',
                'display_name' => 'Salary Type Index',
                'module' => 'salarytype',
                'description' => 'View salary types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salarytype_create',
                'display_name' => 'Create Salary Type',
                'module' => 'salarytype',
                'description' => 'Create new salary types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salarytype_store',
                'display_name' => 'Store Salary Type',
                'module' => 'salarytype',
                'description' => 'Store new salary types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salarytype_show',
                'display_name' => 'Show Salary Type',
                'module' => 'salarytype',
                'description' => 'View specific salary type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salarytype_edit',
                'display_name' => 'Edit Salary Type',
                'module' => 'salarytype',
                'description' => 'Edit salary types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salarytype_update',
                'display_name' => 'Update Salary Type',
                'module' => 'salarytype',
                'description' => 'Update salary types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salarytype_destroy',
                'display_name' => 'Delete Salary Type',
                'module' => 'salarytype',
                'description' => 'Delete salary types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],



            // Salary Rate Management
            [
                'name' => 'salaryrate_index',
                'display_name' => 'List Salary Rates',
                'module' => 'salaryrate',
                'description' => 'View list of salary rates',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_create',
                'display_name' => 'Create Salary Rate',
                'module' => 'salaryrate',
                'description' => 'Show form to create salary rate',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_store',
                'display_name' => 'Store Salary Rate',
                'module' => 'salaryrate',
                'description' => 'Store new salary rate',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_show',
                'display_name' => 'Show Salary Rate',
                'module' => 'salaryrate',
                'description' => 'View specific salary rate',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_edit',
                'display_name' => 'Edit Salary Rate',
                'module' => 'salaryrate',
                'description' => 'Edit salary rate',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_update',
                'display_name' => 'Update Salary Rate',
                'module' => 'salaryrate',
                'description' => 'Update salary rate',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_destroy',
                'display_name' => 'Delete Salary Rate',
                'module' => 'salaryrate',
                'description' => 'Delete salary rate',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_import',
                'display_name' => 'Import Salary Rates',
                'module' => 'salaryrate',
                'description' => 'Import salary rates from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_import_store',
                'display_name' => 'Store Imported Salary Rates',
                'module' => 'salaryrate',
                'description' => 'Store imported salary rates',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_demo_download',
                'display_name' => 'Download Salary Rate Import Demo',
                'module' => 'salaryrate',
                'description' => 'Download demo file for salary rate import',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'salaryrate_export',
                'display_name' => 'Export Salary Rates',
                'module' => 'salaryrate',
                'description' => 'Export salary rates to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],



            // Suggested Search Keyword Management
            [
                'name' => 'suggested_search_keyword_management',
                'display_name' => 'Suggested Search Keyword Management',
                'module' => 'suggested_search_keyword',
                'description' => 'Manage suggested search keywords',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'suggested_search_keyword_index',
                'display_name' => 'Suggested Search Keyword Index',
                'module' => 'suggested_search_keyword',
                'description' => 'View suggested search keywords',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            [
                'name' => 'suggested_search_keyword_update',
                'display_name' => 'Update Suggested Search Keyword',
                'module' => 'suggested_search_keyword',
                'description' => 'Update suggested search keywords',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Job Post Management
            [
                'name' => 'jobpost_management',
                'display_name' => 'Job Post Management',
                'module' => 'jobpost',
                'description' => 'Manage job posts',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_index',
                'display_name' => 'View Job Posts',
                'module' => 'jobpost',
                'description' => 'View list of job posts',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_create',
                'display_name' => 'Create Job Post',
                'module' => 'jobpost',
                'description' => 'Create a new job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_store',
                'display_name' => 'Store Job Post',
                'module' => 'jobpost',
                'description' => 'Store a new job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_show',
                'display_name' => 'Show Job Post',
                'module' => 'jobpost',
                'description' => 'View details of a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_edit',
                'display_name' => 'Edit Job Post',
                'module' => 'jobpost',
                'description' => 'Edit a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_update',
                'display_name' => 'Update Job Post',
                'module' => 'jobpost',
                'description' => 'Update a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_destroy',
                'display_name' => 'Delete Job Post',
                'module' => 'jobpost',
                'description' => 'Delete a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_published',
                'display_name' => 'Publish Job Post',
                'module' => 'jobpost',
                'description' => 'Publish a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_banned',
                'display_name' => 'Ban Job Post',
                'module' => 'jobpost',
                'description' => 'Ban a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpost_rejected',
                'display_name' => 'Reject Job Post',
                'module' => 'jobpost',
                'description' => 'Reject a job post',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Job Post Report Type Management
            [
                'name' => 'jobpostreporttype_management',
                'display_name' => 'Job Post Report Type Management',
                'module' => 'jobpostreporttype',
                'description' => 'Manage job post report types',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_index',
                'display_name' => 'Job Post Report Type Index',
                'module' => 'jobpostreporttype',
                'description' => 'View job post report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_create',
                'display_name' => 'Create Job Post Report Type',
                'module' => 'jobpostreporttype',
                'description' => 'Create new job post report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_store',
                'display_name' => 'Store Job Post Report Type',
                'module' => 'jobpostreporttype',
                'description' => 'Store new job post report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_show',
                'display_name' => 'Show Job Post Report Type',
                'module' => 'jobpostreporttype',
                'description' => 'View specific job post report type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_edit',
                'display_name' => 'Edit Job Post Report Type',
                'module' => 'jobpostreporttype',
                'description' => 'Edit job post report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_update',
                'display_name' => 'Update Job Post Report Type',
                'module' => 'jobpostreporttype',
                'description' => 'Update job post report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_destroy',
                'display_name' => 'Delete Job Post Report Type',
                'module' => 'jobpostreporttype',
                'description' => 'Delete job post report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_import',
                'display_name' => 'Import Job Post Report Types',
                'module' => 'jobpostreporttype',
                'description' => 'Import job post report types from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_import_store',
                'display_name' => 'Store Imported Job Post Report Types',
                'module' => 'jobpostreporttype',
                'description' => 'Store imported job post report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_demo_download',
                'display_name' => 'Job Post Report Type Demo Download',
                'module' => 'jobpostreporttype',
                'description' => 'Download job post report type demo file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'jobpostreporttype_export',
                'display_name' => 'Export Job Post Report Types',
                'module' => 'jobpostreporttype',
                'description' => 'Export job post report types to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Job Post Report Management
            [
                'name' => 'jobpost_report_management',
                'display_name' => 'Job Post Report Management',
                'module' => 'jobpost',
                'description' => 'Manage job post reports',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],

            [
                'name' => 'jobpost_reports',
                'display_name' => 'Job Post Reports',
                'module' => 'jobpost',
                'description' => 'View job post reports',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            [
                'name' => 'jobpost_report',
                'display_name' => 'View Job Post Report',
                'module' => 'jobpost',
                'description' => 'View job post report',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            [
                'name' => 'jobpost_report_delete',
                'display_name' => 'Delete Job Post Report',
                'module' => 'jobpost',
                'description' => 'Delete job post report',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],



            // Company Report Type Management
            [
                'name' => 'companyreporttype_management',
                'display_name' => 'Company Report Type Management',
                'module' => 'companyreporttype',
                'description' => 'Manage company report types',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_index',
                'display_name' => 'Company Report Type Index',
                'module' => 'companyreporttype',
                'description' => 'View company report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_create',
                'display_name' => 'Create Company Report Type',
                'module' => 'companyreporttype',
                'description' => 'Create new company report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_store',
                'display_name' => 'Store Company Report Type',
                'module' => 'companyreporttype',
                'description' => 'Store new company report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_show',
                'display_name' => 'Show Company Report Type',
                'module' => 'companyreporttype',
                'description' => 'View specific company report type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_edit',
                'display_name' => 'Edit Company Report Type',
                'module' => 'companyreporttype',
                'description' => 'Edit company report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_update',
                'display_name' => 'Update Company Report Type',
                'module' => 'companyreporttype',
                'description' => 'Update company report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_destroy',
                'display_name' => 'Delete Company Report Type',
                'module' => 'companyreporttype',
                'description' => 'Delete company report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_import',
                'display_name' => 'Import Company Report Types',
                'module' => 'companyreporttype',
                'description' => 'Import company report types from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_import_store',
                'display_name' => 'Store Imported Company Report Types',
                'module' => 'companyreporttype',
                'description' => 'Store imported company report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_demo_download',
                'display_name' => 'Download Company Report Type Demo File',
                'module' => 'companyreporttype',
                'description' => 'Download demo file for company report type import',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'companyreporttype_export',
                'display_name' => 'Export Company Report Types',
                'module' => 'companyreporttype',
                'description' => 'Export company report types to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Company Report Management
            [
                'name' => 'company_report_management',
                'display_name' => 'Company Report Management',
                'module' => 'companyreporttype',
                'description' => 'Manage company reports',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],

            [
                'name' => 'company_reports',
                'display_name' => 'Company Reports',
                'module' => 'companyreporttype',
                'description' => 'View company reports',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'company_report',
                'display_name' => 'View Company Report',
                'module' => 'companyreporttype',
                'description' => 'View company report',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'company_report_delete',
                'display_name' => 'Delete Company Report',
                'module' => 'companyreporttype',
                'description' => 'Delete company report',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],


            // Company Review Management


            [
                'name' => 'company_review_management',
                'display_name' => 'Company Review Management',
                'module' => 'companyreview',
                'description' => 'Manage company reviews',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'company_reviews',
                'display_name' => 'Company Reviews',
                'module' => 'companyreview',
                'description' => 'View company reviews',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'company_review',
                'display_name' => 'View Company Review',
                'module' => 'companyreview',
                'description' => 'View a specific company review',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'show_review_attachment',
                'display_name' => 'Show Review Attachment',
                'module' => 'companyreview',
                'description' => 'Show attachment for a company review',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'company_review_status',
                'display_name' => 'Update Company Review Status',
                'module' => 'companyreview',
                'description' => 'Update the status of a company review',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'company_review_delete',
                'display_name' => 'Delete Company Review',
                'module' => 'companyreview',
                'description' => 'Delete a company review',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],

            // Review Report Type Management
            [
                'name' => 'reviewreporttype_management',
                'display_name' => 'Review Report Type Management',
                'module' => 'reviewreporttype',
                'description' => 'Manage review report types',
                'parent_id' => null,
                'is_group' => true,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_index',
                'display_name' => 'View Review Report Types',
                'module' => 'reviewreporttype',
                'description' => 'View list of review report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_create',
                'display_name' => 'Create Review Report Type',
                'module' => 'reviewreporttype',
                'description' => 'Create a new review report type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_edit',
                'display_name' => 'Edit Review Report Type',
                'module' => 'reviewreporttype',
                'description' => 'Edit an existing review report type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_delete',
                'display_name' => 'Delete Review Report Type',
                'module' => 'reviewreporttype',
                'description' => 'Delete a review report type',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_import',
                'display_name' => 'Import Review Report Types',
                'module' => 'reviewreporttype',
                'description' => 'Import review report types from file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_import_store',
                'display_name' => 'Store Imported Review Report Types',
                'module' => 'reviewreporttype',
                'description' => 'Store imported review report types',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_demo_download',
                'display_name' => 'Download Review Report Type Import Demo',
                'module' => 'reviewreporttype',
                'description' => 'Download demo file for review report type import',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
            [
                'name' => 'reviewreporttype_export',
                'display_name' => 'Export Review Report Types',
                'module' => 'reviewreporttype',
                'description' => 'Export review report types to file',
                'parent_id' => null,
                'is_group' => false,
                'status' => 'active',
            ],
